/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#ifndef __SKIPSTONE__H
#define __SKIPSTONE__H

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gtkmozembed.h>

#include "intl.h"
#include "skipstone-types.h"
#include "skipstone-print.h"
#include "debug.h"

/* version information */
#define SKIPSTONE_MAJOR 0
#define SKIPSTONE_MINOR 9
#define SKIPSTONE_MICRO 2
/* ------------------- */

/*  dirs  */
#define SKIPSTONE_SYSTEM_THEME_DIR "/usr/share/skipstone/pixmaps"
#define SKIPSTONE_SYSTEM_PLUGIN_DIR "/usr/share/skipstone/plugins"
/*--------*/

/* bookmarks */

void generate_bookmark_ui(SkipStone *skipstone);
void add_bookmark(GtkWidget *menuitem, SkipStone *skipstone);
void add_bookmark_with_info(gchar *title, gchar *url, SkipStone *skipstone);

/* callbacks */

void blank_new_window(GtkWidget *menuitem,gpointer data); 
void open_in_new_window(GtkWidget *menuitem,gpointer data); 
void open_in_current_window(GtkWidget *menuitem,SkipStone *skipstone);
void close_window(GtkWidget *menuitem,SkipStone *skipstone);
void exit_app(GtkWidget *menuitem,gpointer data);
void change_layout(GtkWidget *menuitem,gpointer data);
void destroy_window_callback(GtkWidget *window,SkipStone *skipstone);
void on_entry(GtkWidget *entry,SkipStone *skipstone);
gint on_entry_button_press(GtkWidget *entry, GdkEventButton *button, SkipStone *skipstone);
void on_list_select(GtkWidget *combo,SkipStone *skipstone);
void on_back(GtkWidget *button,SkipStone *skipstone);
void on_forward(GtkWidget *button,SkipStone *skipstone);
void on_reload(GtkWidget *button, SkipStone *skipstone);
gint on_reload_button_press(GtkWidget *button, GdkEventButton *ev, SkipStone *skipstone);
void on_reload_popup_menu_selection_made(GtkWidget *menuitem, SkipStone *skipstone);
void on_stop(GtkWidget *button, SkipStone *skipstone);
void go_home(GtkWidget *button, SkipStone *skipstone);
void about_skipstone(GtkWidget *menuitem);
void hide_bookmark_toolbar(GtkCheckMenuItem *cb_menuitem, SkipStone *skipstone);
void hide_navigation_toolbar(GtkCheckMenuItem *cb_menuitem, SkipStone *skipstone);
void on_view_source(GtkWidget *MenuItem, SkipStone *skipstone);
void on_windowmenu_item_clicked(GtkWidget *menuitem,GtkWidget *window);
void find_dialog (GtkWidget *w, SkipStone *skipstone);
void on_print(GtkWidget *menuitem, SkipStone *skipstone);
void skipstone_print_dialog_new(SkipStone *skipstone);
void switch_layouts(void);
void on_selection_get(GtkWidget *window, GtkSelectionData *selection_data, guint info, guint time_stamp, SkipStone *skipstone);
void on_selection_received(GtkWidget *widget, GtkSelectionData *selection_data, guint time, SkipStone *skipstone);
void on_window_size_request(GtkWidget *window, GtkRequisition *req, SkipStone *skipstone);
void save_document(GtkWidget *menuitem, SkipStone *skipstone);
void save_image(SkipStone *skipstone, gchar *image_link, gchar *image_name);
void toggle_mime_handling(void);
void create_dialog(gchar *title, gchar *labeltext, gint logo, gint lock); /* generic dialog */
void on_offline_toggle_cb(GtkCheckMenuItem *menuitem);
void _skipstone_load_url(SkipStone *skipstone, gchar *url);
void skipstone_window_set_icon(GtkWidget *window);			   
			   
/* configure */

void open_config_dialog(GtkWidget *menuitem,gpointer data);

/* crash */

gint check_crash_file(void);
void handle_segv_signal(int sig); /*Taras' code*/
void save_crash_state(void);


/* history */

void add_to_history(gchar *url);
void on_view_history(GtkWidget *widget,SkipStone *skipstone);

/* interface */

SkipStone * new_skipstone_window(gboolean with_plugins, gboolean set_size);
void make_window_menu(SkipStone *skipstone);
void make_window(const gchar *url);
void make_notebook_tab(const gchar *url);
void make_real_window(const gchar *url);
void make_menu(SkipStone *skipstone);
void create_toolbar(SkipStone *skipstone, gint i);
void connect_embed_signals(SkipStone *skipstone);
void make_themes_menu(GtkWidget *menu);


/* interface - Notebook */

SkipStone *new_skipstone_tab(gboolean with_plugins);
SkipStone *get_current_browser_from_notebook(void);
GtkWidget *make_notebook_tab_widget(SkipStone *skipstone);
void skipstone_append_tab(SkipStone *skipstone);
void make_notebook_window(void);
void add_to_notebook(const gchar *url);
void detab(void);
void clear_variables(void); /* prepares for switching */
void hide_bmark_toolbar_nb(void);
/* ipc */

void handle_usr1_signal(gint sig);
void check_running(gint argc, gchar *argv[]);
void set_running(void);

/* context */

GtkWidget * get_link_popup_menu(SkipStone *skipstone, gchar *href, gchar *linktext);
GtkWidget * get_doc_popup_menu(SkipStone *skipstone, gchar *href);
GtkWidget * get_image_popup_menu(SkipStone *skipstone, gchar *img);
GtkWidget * get_link_image_popup_menu(SkipStone *skipstone, gchar *img, gchar *href);
GtkWidget * get_reload_menu(SkipStone *skipstone);

/* moz_callbacks */

gint on_mouse_click(GtkMozEmbed *embed, gpointer dom_event, SkipStone *skipstone);
gint on_key_press(GtkMozEmbed *embed, gpointer event, SkipStone *skipstone);
gint handle_open_uri(GtkMozEmbed *embed,const gchar *uri,SkipStone *skipstone);
void start_load(GtkMozEmbed *embed,SkipStone *skipstone);
void link_message(GtkMozEmbed *embed, SkipStone *skipstone);
void title_changed(GtkMozEmbed *embed, SkipStone *skipstone);
void url_clicked(GtkMozEmbed *embed, SkipStone *skipstone);
void stop_load(GtkMozEmbed *embed,SkipStone *skipstone);
void moz_new_window_cb(GtkMozEmbed *embed, GtkMozEmbed **retval, guint chromemask);
void net_state_cb (GtkMozEmbed *embed, gint state, guint status, SkipStone *skipstone);
void destroy_browser(GtkMozEmbed *embed, SkipStone *skipstone);
void update_navigation_buttons(SkipStone *skipstone);
void size_to_cb(GtkMozEmbed *embed, gint width, gint height, SkipStone *skipstone);
void js_status_cb(GtkMozEmbed *embed, SkipStone *skipstone);
void new_window_orphan_cb(GtkMozEmbedSingle *embed, GtkMozEmbed **retval, guint chromemask, gpointer data);
void handle_progress(GtkMozEmbed *embed, const char *aURI, gint cur, gint max, SkipStone *skipstone);

/* mozilla.cpp */

extern gboolean mozilla_preference_set(const gchar *preference_name, const gchar *new_value);
extern gboolean mozilla_preference_set_boolean(const gchar *preference_name, gboolean new_boolean_value);
extern gboolean mozilla_preference_set_int (const gchar  *preference_name,    gint  new_int_value);
extern gboolean mozilla_find(GtkMozEmbed *b, const gchar *exp, gboolean matchcase, gboolean search_backwards, gboolean search_wrap_around, gboolean search_for_entire_word, gboolean search_in_frames, gboolean found);
extern gboolean mozilla_save(GtkMozEmbed *b, gchar *file, gint all);
extern gboolean mozilla_init_prompt_service(void);
extern gboolean mozilla_print(GtkMozEmbed *b, PrintInfo *info);
extern gboolean mozilla_set_offline(gboolean offline);
extern gboolean mozilla_force_charset(GtkMozEmbed *aEmbed, gchar *aCharSet);
extern gint mozilla_get_button(gpointer dom_event);
extern gint mozilla_get_key(gpointer event, gint *modifier);
extern gulong mozilla_get_context_menu_type(GtkMozEmbed *b, gpointer event, gchar **img, gchar **link, gchar **linktext);
extern void mozilla_save_image(GtkMozEmbed *b,gchar *location,gchar *FullPath);
extern gchar * mozilla_get_document_title (GtkMozEmbed *embed);
extern gboolean mozilla_init_chrome (void);

extern gboolean mozilla_save_prefs (void);

/* go */

GoMenu *go_menu_init(void);
void go_menu_append(GoMenu *go_menu, gchar *location, SkipStone *skipstone);

/* encoding */

GtkWidget *skipstone_get_encoding_menu(SkipStone *skipstone);

/* session */

void skipstone_save_a_session(void);
void skipstone_load_a_session(void);

/* support */
gboolean open_uri (const gchar *uri);
gint progress(SkipStone *skipstone);
GtkWidget* create_pixmap(GtkWidget *widget, const gchar *filename, gint *loaded);
GtkWidget* create_dummy_pixmap(GtkWidget *widget);
GtkWidget* create_pixmap_from_path(gchar *dir, gchar *theme_dir, GtkWidget *menu_item);
void read_skipstone_config(void);
void write_skipstone_config(void);
void read_history(void);
void write_history(void);
void read_urls(void);
void write_urls(void);
void update_layout(void);
void insert_in_combo(gchar *url, SkipStone *skipstone);
void make_window_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void browse_in_window_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void download_link_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void save_image_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void copy_link_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void add_link_from_popup(GtkWidget *menuitem, SkipStone *skipstone);
void quit_skipstone(void);
void read_bookmarks(void);
void write_bookmarks(void);
void read_prefixes(void);
void write_prefixes(void);
void switch_theme(GtkWidget *menu_item, gchar *theme);
void set_mozilla_prefs(void);
void set_selection_targets(GtkWidget *window, SkipStone *skipstone);
void setup_escape_key_handler(GtkWidget *window);
gint escape_key_handler(GtkWidget *window, GdkEventKey *ev);

#include "skipstone-plugin.h"

SkipStonePlugin *load_plugin(gchar *plugin_name);
void skipstone_plugin_check(SkipStone *skipstone, PLUGIN_POS current_position);
void skipstone_write_plugin_config(gpointer key, gpointer value, 
				   gpointer user_data);

#endif /* __SKIPSTONE__H */
