#ifndef __SKIPSTONE_TYPE__H__
#define __SKIPSTONE_TYPE__H__

typedef struct _PrintDialog PrintDialog;
typedef struct _GoMenu GoMenu;
typedef struct _SkipStone SkipStone;
typedef struct _DialogData DialogData;
typedef struct _CWindow CWindow;
typedef struct _ConfigData ConfigData;
typedef struct _BookmarkData BookmarkData;
typedef struct _BookmarkFuncData BookmarkFuncData;
typedef struct _BookmarkCTreeData BookmarkCTreeData;
typedef struct _BookmarkWindow BookmarkWindow;
typedef struct _SkipPrefix SkipPrefix;


struct _GoMenu
{
	GtkWidget *menu;
	GSList *items;
};


struct _SkipStone		/* Browser window structure */
{
	GtkWidget *window;
	GtkWidget *handlebox;
	GtkWidget *menubar;
	GtkWidget *toolbar;
	GtkWidget *back;
     	GtkWidget *forward;
     	GtkWidget *stop;
     	GtkWidget *reload;
     	GtkWidget *home;
     	GtkWidget *combo;
	GtkWidget *statusbar;
	GtkWidget *progressbar;
	GtkAccelGroup *accelgroup;
     
	GtkWidget *window_menuitem;
	GtkWidget *windowmenu;
     	GtkWidget *menuhandlebox;
	GtkWidget *bookmark_menubar_item;
	GtkWidget *bookmark_menu;
	GtkWidget *bookmark_toolbar;
	GtkWidget *bmarkhandlebox;
     	GSList *bookmark_toolbar_widgets;
	GtkMozEmbed *embed;
     	GtkWidget *statusbox;
	GtkWidget *use_skipstone_mime; /* use mozilla or skipstone for mime handling */
	GtkWidget *reload_menu; /* context menu for reload flags */
     	GtkWidget *doc_menu; /* pointer to document popup menu */
       	GtkWidget *image_menu; /* pointer to image popup menu */
     	GtkWidget *link_menu; /* pointer to link popup menu */
     	GtkWidget *image_link_menu; /* pointer to image link popup menu */
	GtkWidget *right_of_embed_box;
	GtkWidget *left_of_embed_box;
	GtkWidget *main_hbox;
	GtkWidget *embedbox;
	/* notebook mode specific stuff */
     	GtkWidget *notebook_label;
     	GtkWidget *vbox;
     	gint visible;
	gint is_notebook;
     	/* ---------------------------- */	
     	gint timer;
	GoMenu *go_menu;
	gboolean didFind;
     	gboolean is_loading;
	PrintDialog *pd;
	gint prev_seconds;
     	gint prev_useconds;
     	gint prev_bytes;
        gint initilized;
	gchar *title;     
        /*statusbar message context id's(moz_callbacks.c interface*.c)*/
        gint sbar_temp_msg_id; /* progress, javascript, request, link */
        gint sbar_status_msg_id; /* document state */
        /* ------------------------------ */
};


struct _DialogData		/* Dialog window struct */
{
	GtkWidget *dialog;
	GtkWidget *entry;
};


struct _CWindow		/* Config window struct */
{
	GtkWidget *window;
	GtkWidget *notebook;
     	GtkWidget *ctree;
     	GtkWidget *home_entry;
	GtkWidget *email_entry;
	GtkWidget *downloader_entry;
	GtkWidget *prefix_list;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *maxpopups;       
	GtkObject *maxpopups_adj;
	GtkWidget *max_go;
	GtkObject *max_go_adj;
     	GtkWidget *show_tabs;
	GtkWidget *back;
	GtkWidget *forw;
	GtkWidget *reload;
	GtkWidget *stop;
	GtkWidget *home;
	GtkWidget *java;       
     	GtkWidget *javascript;
     	GtkWidget *serif_font;
     	GtkWidget *sansserif_font;
     	GtkWidget *cursive_font;
     	GtkWidget *fantasy_font;
     	GtkWidget *monospace_font;
     	GtkWidget *lang_font_option_menu;
     	GtkWidget *lang_font_menu;
     	GtkWidget *font_size;
     	GtkObject *font_size_adj;
     	GtkWidget *min_font_size;
     	GtkObject *min_font_size_adj;
     	GtkWidget *http_proxy;
     	GtkWidget *http_proxy_port;
	GtkWidget *ftp_proxy;
	GtkWidget *ftp_proxy_port;
     	GtkWidget *ssl_proxy;
     	GtkWidget *ssl_proxy_port;
     	GtkWidget *image_option_menu;
     	GtkWidget *image_menu;
     	GtkWidget *language_option_menu;
     	GtkWidget *language_menu;
     	GtkWidget *default_charset_combo;
     	GtkWidget *http_version;
	GtkWidget *respect_sizeto;     
	GtkWidget *disk_cache;
     	GtkWidget *mem_cache;
	GtkWidget *no_proxy_for;
	GtkWidget *direct_connection;
	GtkWidget *cookie_behavior;
	GtkWidget *cookie_behavior_menu;
	GtkWidget *warn_about_cookie;
     	GtkWidget *popup_in_new_window;
     	GtkWidget *natural_tabs;
     	GtkWidget *fixed_tabs;
     	GtkWidget *shorten_tabs;
     	GtkWidget *tab_text_length;
     	GtkWidget *use_document_fonts;
     	GtkWidget *use_document_colors;
     	GtkWidget *underline_links;
     	GtkWidget *jump_to_new_tab;
     	GtkWidget *remember_signons;
     	GtkWidget *default_search_engine;
     	GtkWidget *disable_popups;
     	GtkWidget *red_while_loading;
     	GtkWidget *tabs_in_focus_order;
};


#define LANG_FONT_NUM 15
#define DEFAULT_FONT_SIZE 14
#define DEFAULT_MIN_FONT_SIZE 10
#define DEFAULT_SERIF_FONT     "-adobe-times-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_SANSSERIF_FONT "-adobe-times-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_CURSIVE_FONT   "-adobe-times-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_FANTASY_FONT   "-adobe-times-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define DEFAULT_MONOSPACE_FONT "-adobe-times-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"


struct _ConfigData 		/* configuration data struct */
{
	/* skipstone prefs */
     	gchar *home;
	gchar *mailer;
     	gchar *downloader;
     	gint xsize;
	gint ysize;
	gint layout;
	gint maxpopupitems;
	gint max_go;     
	gint bmarktbar;
	gint navbar_buttons;
	gint navtbar;
     	gint notebook;
	gint notebook_tabs_pos;
     	/* mozilla prefs */
     	gint images;
     	gint language;
     	gchar *default_charset;
     	gchar *accept_languages;
     	gchar *accept_languages_temp;
     	gchar *http_proxy;
     	gchar *http_proxy_port;
	gchar *ftp_proxy;
	gchar *ftp_proxy_port;
     	gchar *ssl_proxy;
     	gchar *ssl_proxy_port;
     	gint lang_font;
     	gchar *serif_font[LANG_FONT_NUM];
     	gchar *sansserif_font[LANG_FONT_NUM];
     	gchar *cursive_font[LANG_FONT_NUM];
     	gchar *fantasy_font[LANG_FONT_NUM];
     	gchar *monospace_font[LANG_FONT_NUM];
     	gint font_size[LANG_FONT_NUM];
     	gint min_font_size[LANG_FONT_NUM];
     	gboolean java;
     	gboolean javascript;
	gboolean use_document_fonts;
     	gboolean use_document_colors;
     	gboolean underline_links;
     	gchar *theme;
     	gchar *http_version;
	gint respect_sizeto;
	gchar *disk_cache;
     	gchar *mem_cache;
     	gchar *no_proxy_for;
     	gchar *default_search_engine;
	gint use_skipstone_mime;
	gint direct_connection;
	gint cookie_behavior;
	gint warn_about_cookie;
     	gint show_tabs;
     	gint popup_in_new_window;
     	gint shorten_tabs;
     	gint tab_text_length;
	gint jump_to_new_tab;
     	gint remember_signons;
     	gint disable_popups;
     	gint red_while_loading;     
     	gint tabs_in_focus_order;     
};


struct _BookmarkData {
	gchar *label;
	gchar *url;
	gint type; /* 0 - folder, 1 - url, 2 - sep */
};

struct _BookmarkFuncData {
	SkipStone *skipstone;
	GtkWidget *widget;
};

struct _BookmarkCTreeData {
	GtkWidget *ctree;
	GtkCTreeNode *parent;
};

struct _BookmarkWindow {
	GtkWidget *window;
	GtkWidget *scrolled_window;
	GtkWidget *ctree;
	GtkCTreeNode *menu_node;
	GtkCTreeNode *toolbar_node;
	GtkWidget *text_entry;
	GtkWidget *url_entry;
	GtkWidget *folder_entry;
};

struct _SkipPrefix {
	gchar *prefix;
	gchar *url;
};


struct _PrintDialog
{
	GtkWidget *window;
	GtkWidget *PrintToPrinterRb;
     	GtkWidget *PrintToFileRb;
     	GtkWidget *PrintCommand;
     	GtkWidget *FileName;
     	GtkWidget *FirstPageFirst;
     	GtkWidget *LastPageFirst;
     	GtkWidget *Color;
     	GtkWidget *GreyScale;
     	GtkWidget *Letter;
     	GtkWidget *Legal;
     	GtkWidget *A4;
     	GtkWidget *Executive;
     	GtkWidget *AllPages;
     	GtkWidget *Pages;
     	GtkWidget *From;
     	GtkWidget *To;
     	GtkWidget *Selection;
     	GtkWidget *TopMargin;
     	GtkWidget *LeftMargin;
     	GtkWidget *RightMargin;
     	GtkWidget *BottomMargin;     
     	SkipStone *skipstone;
};

enum navbar_buttons {	
     			NAVBAR_BACK = 2,
			NAVBAR_FOR = 4,
			NAVBAR_RELOAD = 8,
			NAVBAR_STOP = 16,
			NAVBAR_HOME = 32 
};



#endif /* __SKIPSTONE_TYPE__H__ */
