/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"

#define PACK(box,widget) gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0)
#define RADIO(group,name) gtk_radio_button_new_with_label(group, name)
#define GROUP(button) gtk_radio_button_group(GTK_RADIO_BUTTON(button))

static PrintInfo *skipstone_print_get_info(PrintDialog *pd);
static gfloat get_float_from_entry (GtkWidget *entry);
static gint get_int_from_entry (GtkWidget *entry);
static gint get_radiobutton_active_index (GtkWidget *radiobutton);
static void on_print_ok(GtkWidget *button, PrintDialog *pd);
static void on_print_cancel(GtkWidget *button, PrintDialog *pd);
static void on_print_destroy(GtkWidget *dialog, PrintDialog *pd);
static void print_info_free (PrintInfo *info);
static void On_Toggle_Printer(GtkWidget *rb, PrintDialog *pd);
static void On_Toggle_Pages(GtkWidget *rb, PrintDialog *pd);

extern gchar *home;

static void On_Toggle_Printer(GtkWidget *rb, PrintDialog *pd)
{
	gboolean s;
     	D_ENTER;
     	s = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb));
       	gtk_widget_set_sensitive(pd->FileName, !s);
     	gtk_widget_set_sensitive(pd->PrintCommand, s);
     	D_RETURN;
}

static void On_Toggle_Pages(GtkWidget *rb, PrintDialog *pd)
{
     	gboolean s;
     	D_ENTER;
     	s = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rb));
     	gtk_widget_set_sensitive(pd->To, !s);
     	gtk_widget_set_sensitive(pd->From, !s);
     	D_RETURN;
}

void skipstone_print_dialog_new(SkipStone *skipstone)
{	
	GtkWidget *PrintTo, *PrintCommand, *File, *Print, *Color,
       		  *PaperSize, *From, *To, *PrintRange, *Margins,
       		  *TopMargin, *BottomMargin, *RightMargin, *LeftMargin, 
       		  *Ok, *Cancel, *vbox, *hbox, *mainvbox;
	
     	PrintDialog *pd=NULL;
     	GSList *group=NULL, *group2 = NULL, *group3=NULL, *group4=NULL, 
       	       *group5=NULL;
	gchar *text=NULL;
     
     	D_ENTER;
     	
     	pd = g_new0(PrintDialog, 1);
	pd->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        skipstone_window_set_icon(pd->window);
     	setup_escape_key_handler(pd->window);
     	gtk_window_set_modal(GTK_WINDOW(pd->window), TRUE);
     	gtk_window_set_position(GTK_WINDOW(pd->window), GTK_WIN_POS_MOUSE);
     	gtk_window_set_title(GTK_WINDOW(pd->window), _("Skipstone Print Dialog"));
     	mainvbox = gtk_vbox_new(FALSE, 4);
     	gtk_container_add(GTK_CONTAINER(pd->window), mainvbox);	
     	g_signal_connect(G_OBJECT(pd->window), "destroy", G_CALLBACK(on_print_destroy), pd);
     	
     	PrintTo = gtk_label_new(_("Print To: "));
     	gtk_widget_set_usize(PrintTo, 100, -1);
     	pd->PrintToPrinterRb = RADIO(group, _("Printer"));
     	group = GROUP(pd->PrintToPrinterRb);
     	pd->PrintToFileRb = RADIO(group, _(" File"));
     	group = GROUP(pd->PrintToFileRb);
     	g_signal_connect(G_OBJECT(pd->PrintToPrinterRb), "toggled",
			   G_CALLBACK(On_Toggle_Printer), pd);
     	
     	hbox = gtk_hbox_new(FALSE, 0);     	
     	PACK(hbox, PrintTo);
	PACK(hbox, pd->PrintToPrinterRb);
	PACK(hbox, pd->PrintToFileRb);
	PACK(mainvbox, hbox);
     	
     	PrintCommand = gtk_label_new(_("Print Command: "));
     	gtk_widget_set_usize(PrintCommand, 100, -1);
     	pd->PrintCommand = gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(pd->PrintCommand), "lpr");
     	
     	hbox = gtk_hbox_new(FALSE, 0);
     	PACK(hbox, PrintCommand);
	PACK(hbox, pd->PrintCommand);     	
     	PACK(mainvbox, hbox);
          	
     	File = gtk_label_new(_("File: "));
     	gtk_widget_set_usize(File, 100, -1);
     	pd->FileName = gtk_entry_new();
     	text = g_strconcat(home, "/skipstone.ps",NULL);
     	gtk_entry_set_text(GTK_ENTRY(pd->FileName), text);
     	gtk_widget_set_sensitive(pd->FileName, FALSE);
	hbox = gtk_hbox_new(FALSE, 0);
     	PACK(hbox, File);
     	PACK(hbox, pd->FileName);
     	PACK(mainvbox, hbox);
	
     	Print = gtk_label_new(_("Print: "));
     	gtk_widget_set_usize(Print, 100, -1);
     	pd->FirstPageFirst = RADIO(group2, _("First Page First"));
     	group2 = GROUP(pd->FirstPageFirst);
     	pd->LastPageFirst = RADIO(group2, _("Last Page First"));
     	group2 = GROUP(pd->LastPageFirst);
       
     	hbox = gtk_hbox_new(FALSE, 0);
     	PACK(hbox,Print);
     	PACK(hbox,pd->FirstPageFirst);
     	PACK(hbox,pd->LastPageFirst);
     	PACK(mainvbox,hbox);
     	     	
     	Color = gtk_label_new(_("Color: "));
     	gtk_widget_set_usize(Color, 100, -1);
     	pd->GreyScale = RADIO(group3,_("GreyScale"));
     	group3 = GROUP(pd->GreyScale);     	
     	pd->Color = RADIO(group3, _("Color"));
     	group3 = GROUP(pd->Color);
     	
     	hbox = gtk_hbox_new(FALSE, 0);
     	PACK(hbox,Color);
     	PACK(hbox,pd->GreyScale);
     	PACK(hbox,pd->Color);
     	PACK(mainvbox,hbox);
	
     	PaperSize = gtk_label_new(_("Paper Size: "));
     	gtk_widget_set_usize(PaperSize, 100, -1);
     	pd->Letter = RADIO(group4,_("Letter (8 1/2 x 11 in.)"));
     	group4 = GROUP(pd->Letter);
     	pd->Legal = RADIO(group4, _("Legal (8 1/2 x 14 in.)"));
     	group4 = GROUP(pd->Legal);
     	pd->Executive = RADIO(group4, _("Executive (7 1/2 x 10 in.)"));
     	group4 = GROUP(pd->Executive);
     	pd->A4 = RADIO(group4, _("A4 (210x297 mm)"));
     	group4 = GROUP(pd->A4);
     	
     	hbox = gtk_hbox_new(FALSE, 0);
     	vbox = gtk_vbox_new(FALSE, 0);
     	PACK(hbox, PaperSize);
     	PACK(vbox, pd->Letter);
     	PACK(vbox, pd->Legal);
     	PACK(vbox, pd->Executive);
     	PACK(vbox, pd->A4);
     	PACK(hbox,vbox);
     	PACK(mainvbox, hbox);
	
     	PrintRange = gtk_label_new(_("Print Range: "));
     	gtk_widget_set_usize(PrintRange, 100, -1);
     	pd->AllPages = RADIO(group5,_("All Pages"));     	
     	group5 = GROUP(pd->AllPages);
     	g_signal_connect(G_OBJECT(pd->AllPages), "toggled", 
			   G_CALLBACK(On_Toggle_Pages), pd);
     	pd->Selection = RADIO(group5, _("Selection"));
     
     	group5 = GROUP(pd->Selection);
     	g_signal_connect(G_OBJECT(pd->Selection), "toggled", 
			   G_CALLBACK(On_Toggle_Pages), pd);
     
     	pd->Pages = RADIO(group5, _("Pages"));
     	group5 = GROUP(pd->Pages);
     	From = gtk_label_new(_("From: "));
     	To = gtk_label_new(_("To: "));
     	pd->From = gtk_entry_new();
     	pd->To = gtk_entry_new();
     	
     	gtk_widget_set_usize(pd->To,25,25);
     	gtk_widget_set_usize(pd->From,25,25);
	gtk_widget_set_sensitive(pd->To, FALSE);
     	gtk_widget_set_sensitive(pd->From, FALSE);
     	
     	hbox = gtk_hbox_new(FALSE, 0);
     	PACK(hbox, PrintRange);
     	PACK(hbox, pd->AllPages);
     	PACK(hbox, pd->Selection);
     	PACK(hbox, pd->Pages);
	PACK(hbox, From);
     	PACK(hbox, pd->From);
     	PACK(hbox, To);
     	PACK(hbox, pd->To);
     	PACK(mainvbox, hbox);
     
     	Margins = gtk_label_new(_("Margins (inches): "));
     	gtk_widget_set_usize(Margins, 100, -1);
     	TopMargin = gtk_label_new(_("Top: "));
     	BottomMargin = gtk_label_new(_("Bottom: "));
     	RightMargin = gtk_label_new(_("Right: "));
     	LeftMargin = gtk_label_new(_("Left: "));
     
     	pd->TopMargin = gtk_entry_new();
     	pd->LeftMargin = gtk_entry_new();
     	pd->RightMargin = gtk_entry_new();
     	pd->BottomMargin = gtk_entry_new();
     
     	gtk_widget_set_usize(pd->TopMargin, 30, 25);
     	gtk_widget_set_usize(pd->BottomMargin, 30, 25);
     	gtk_widget_set_usize(pd->LeftMargin, 30, 25);
     	gtk_widget_set_usize(pd->RightMargin, 30, 25);
     
     	gtk_entry_set_text(GTK_ENTRY(pd->TopMargin), "0.5");
     	gtk_entry_set_text(GTK_ENTRY(pd->BottomMargin), "0.5");
     	gtk_entry_set_text(GTK_ENTRY(pd->LeftMargin), "0.5");
     	gtk_entry_set_text(GTK_ENTRY(pd->RightMargin), "0.5");

     	hbox = gtk_hbox_new(FALSE, 2);
     	PACK(hbox, Margins);
     	PACK(hbox, TopMargin);
       	PACK(hbox, pd->TopMargin);
     	PACK(hbox, BottomMargin);
     	PACK(hbox, pd->BottomMargin);
     	PACK(hbox, LeftMargin);
     	PACK(hbox, pd->LeftMargin);
     	PACK(hbox, RightMargin);
     	PACK(hbox, pd->RightMargin);
     	PACK(mainvbox, hbox);
     
     	Ok = gtk_button_new_with_label(_("Ok"));
     	Cancel = gtk_button_new_with_label(_("Cancel"));
	g_signal_connect(G_OBJECT(Cancel), "clicked",
			   G_CALLBACK(on_print_cancel),
			   pd);
	g_signal_connect(G_OBJECT(Ok), "clicked", 
			   G_CALLBACK(on_print_ok),
			   pd);
     
     	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(hbox), Ok, TRUE, TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(hbox), Cancel, TRUE, TRUE, 0);

     	PACK(mainvbox, hbox);
     
     	pd->skipstone = skipstone;
     	skipstone->pd = pd;
	gtk_widget_show_all (pd->window);
     	g_free(text);
     	D_RETURN;

}


static PrintInfo *skipstone_print_get_info (PrintDialog *pd)
{
	PrintInfo *info;
     	D_ENTER;
	info = g_new0(PrintInfo, 1);
      	info->PrintToFile =  get_radiobutton_active_index (pd->PrintToPrinterRb);
	info->Printer = gtk_editable_get_chars (GTK_EDITABLE (pd->PrintCommand), 0, -1);
	info->File = gtk_editable_get_chars (GTK_EDITABLE (pd->FileName), 0, -1);
	info->TopMargin = get_float_from_entry (pd->TopMargin);
	info->BottomMargin = get_float_from_entry (pd->BottomMargin);
	info->LeftMargin = get_float_from_entry (pd->LeftMargin);
	info->RightMargin = get_float_from_entry (pd->RightMargin);
	info->From = get_int_from_entry (pd->From);
	info->To = get_int_from_entry (pd->To);
	info->Paper = get_radiobutton_active_index (pd->Letter);
	info->Pages = get_radiobutton_active_index (pd->AllPages);
	info->Reversed = get_radiobutton_active_index (pd->FirstPageFirst);
     	info->Color = get_radiobutton_active_index(pd->Color);
	D_RETURN_ ( info );
}

static void on_print_ok(GtkWidget *button, PrintDialog *pd)
{
	PrintInfo *info;
     	D_ENTER;
	info = skipstone_print_get_info(pd);
	if (!mozilla_print(pd->skipstone->embed, info))
		skipstone_error_dialog(_("Print Error!"), _("Print Failed!"), FALSE);	
	print_info_free(info);
	gtk_widget_destroy (pd->window);
     	D_RETURN;
}

static void print_info_free (PrintInfo *info)
{
     	D_ENTER;
	g_free(info->Printer);
	g_free(info->File);
	g_free(info);
     	D_RETURN;
}


static void on_print_cancel(GtkWidget *button, PrintDialog *pd)
{
     	D_ENTER;
	gtk_widget_destroy (pd->window);
     	D_RETURN;
}

static void on_print_destroy(GtkWidget *dialog, PrintDialog *pd)
{     	
     	SkipStone *skipstone;
     	D_ENTER;
	skipstone = pd->skipstone;
     	g_free(pd);
     	skipstone->pd = NULL;
     	D_RETURN;
}


static gfloat get_float_from_entry (GtkWidget *entry)
{
	gdouble f;
	gchar *temp;
     	D_ENTER;
	temp = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	f = strtod(temp,(gchar**)NULL);
	g_free (temp);
	D_RETURN_ ( f );
}

static gint get_int_from_entry(GtkWidget *entry)
{
	gint i;
	gchar *temp;
     	D_ENTER;
	temp = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	i = strtol(temp, (gchar **)NULL, 10);
	g_free(temp);
	D_RETURN_ ( i );
}

static gint get_radiobutton_active_index(GtkWidget *radiobutton)
{
	GSList *group, *l;
	gint i = 0, selected = -1;
	D_ENTER;
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(radiobutton));

	for (l = group; l ; l = l->next)
	{
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (l->data)))
		{
			selected = i;
		}
		
		i++;
	}

	D_RETURN_(  (selected<0) ? -1 : i-selected-1 );
}

