#ifndef __SKIPSTONE__PLUGIN__H
#define __SKIPSTONE__PLUGIN__H 

#include "skipstone.h"

typedef enum
{
	PLUGIN_IN_TOOLBAR, /* Plugin will be appended to the toolbar after the HOME button */
	PLUGIN_AFTER_TOOLBAR, /* plugin will be appended after the toolbar */
	PLUGIN_RIGHT_OF_MOZEMBED, /* to the right of the embedding widget */
	PLUGIN_LEFT_OF_MOZEMBED, /* to the left of the embedding widget */
	PLUGIN_AFTER_MOZEMBED, /* after the embedding widget (before the statusbar) */
	PLUGIN_AFTER_STATUSBAR, /* after the statusbar */
        PLUGIN_IN_TOOLBAR_START, /* Plugin will be appended to the toolbar before the back button */
        PLUGIN_IN_TOOLBAR_BEFORE_ENTRY /* Plugin will be appended after the stop button and before the entry */
}PLUGIN_POS;       
       
typedef struct
{
	gchar *name; /* plugin name */
     	PLUGIN_POS position; /* position */
	void (*create_plugin)(SkipStone *skipstone); /* This function will be
						      * called when its time
						      * for the plugin to 
						      * create itself 
						      */
     	GtkWidget *(*get_config_widget)(void); /* This function will be called
						* if its time for a config
						* session for skipstone,
						* it will call the plugins
						* to get GtkWidget *
						* to add to its config notebook
						*/
     
     	void (*save_your_config)(GtkWidget *widget); /* This function will be
						     * called when someone
						     * hits apply/ok in skipstone's
						     * config letting the plugin
						     * its time to get values
						     * for your config, it will
						     * pass the same widget
						     * that the plugin passed at
						     * get_config_widget()
						     */
	gint in_each_window; /* create plugin in each window?/tab */
}SkipStonePlugin;

/* returns TRUE if skipstone is currently loading a page and FALSE if not */
gboolean skipstone_is_loading(SkipStone *skipstone);

/* packs the GtkWidget of the plugin in SkipStone's - you need to call it 
   in the create_plugin function so that it figures where to pack your
   plugin */

void skipstone_pack_plugin(SkipStone *skipstone, GtkWidget *plugin);

/* appends the GtkWidget of the plugin into the toolbar - Call this function
 * in your create_plugin function if its to be added to the toolbar
 * pass NULL for tip_text if you dont want any tooltip text displayed
 * for your plugin. */

void skipstone_add_plugin_to_toolbar(SkipStone *skipstone, GtkWidget *plugin,
				     gchar *tip_text);

/* returns an exact copy of skipstone's internal history GSList with g_slist_copy () */
GSList *skipstone_get_history(void); 

/* queues a resize of skipstone's vbox - say after resizing your plugin or hiding/showing it */
void skipstone_queue_resize(SkipStone *skipstone);

/* loads a url into skipstone */
void skipstone_load_url(SkipStone *skipstone, gchar *url);

/* opens a new skipstone window or tab according to user config and loads
 * a url in it if the url is not NULL, otherwise a new window is made
 * and the users configured home page is loaded. */

void skipstone_new_window(gchar *url);

/* configuration convineince functions */

/* sets a config value for the plugin with a certain key, can set
 * an integer or a char * value, the char *value will be allocated 
 * by skipstone never free it directly, when you set it differently,
 * skipstone will manage that and free the old value and replace it
 * with the new value that it will g_strdup() */


void skipstone_set_config_value_as_int(gchar *plugin_name,
				       gchar *key,
				       gint value);

void skipstone_set_config_value_as_str(gchar *plugin_name,
				       gchar *key,
				       gchar *value);

/* retrives an integer config value or -1 if it doesn't exist */
gint skipstone_get_config_value_as_int(gchar *plugin_name, gchar *key);

/* returns a pointer to the char value of a config set by the plugin 
 or NULL if it doesnt exist - DO NOT FREE */

gchar *skipstone_get_config_value_as_str(gchar *plugin_name, gchar *key);

/* pop a dialog with an error displayed if modal set to true the dialog
   will be modal*/

void skipstone_error_dialog(gchar *title, gchar *error, gboolean modal);

#endif /* __SKIPSTONE__PLUGIN__H */
