/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/


#include "skipstone.h"


gchar *accept_languages_setup_or_lookup(GtkWidget *clist, gint lookup_only);

static void on_tree_select(GtkWidget *ctree, GtkCTreeNode *node, gint column, CWindow *config_window);
static void close_config_window(GtkWidget *button,CWindow *config_window);
static void destroy_config_window(GtkWidget *window,CWindow *config_window);
static void on_config_ok(GtkWidget *button, CWindow *config_window);
static void on_config_apply(GtkWidget *button, CWindow *config_window);
static void clear_popup_urls(void);
static void lang_font_changed (GtkWidget *widget, CWindow *config_window);
static void change_font(GtkWidget *button, GtkWidget *entry);
static void close_font_selection(GtkWidget *button, GtkWidget *fs);
static void set_font(GtkWidget *button, GtkWidget *fs);
static void fontsize_changed (GtkWidget *widget, CWindow *config_window);
static void min_fontsize_changed (GtkWidget *widget, CWindow *config_window);
static void font_changed (GtkWidget *entry, CWindow *config_window);
static void on_languages_select(GtkCList *clist, gint row, gint column, GdkEventButton *event);
static void on_languages_unselect(GtkCList *clist, gint row, gint column, GdkEventButton *event);
static void on_connection_type_toggle(GtkWidget *toggle_button, CWindow *config_window);
static void prefix_add_clicked(GtkWidget *button,GtkCList *clist);
static void prefix_delete_clicked(GtkWidget *button,GtkCList *clist);
static void open_add_prefix_window(GtkCList *clist);
static void real_prefix_add_clicked(GtkWidget *button,GtkWidget *window);
static void cancel_prefix_add_clicked(GtkWidget *button,GtkWidget *window);
static gboolean prefix_window_delete_event(GtkWidget *window,GdkEvent *event,gpointer user_data);
static void skipstone_pack_plugin_configs(CWindow *config_window, gint i);
static void save_config(CWindow *config_window, gint close);

/* node init functions */
static void init_home_node(CWindow *config_window);
static void init_helper_apps_node(CWindow *config_window);
static void init_misc_node(CWindow *config_window);
static void init_prefixes_node(CWindow *config_window);
static void init_navigation_node(CWindow *config_window);
static void init_mozilla_node(CWindow *config_window);
static void init_proxy_node(CWindow *config_window);
static void init_appearance_node(CWindow *config_window);
static void init_fonts_node(CWindow *config_window);
static void init_languages_node(CWindow *config_window);
/* ================== */

extern gboolean skipstone_plugin_is_enabled(gchar *name);

extern GSList *window_count;
extern ConfigData config;
extern GList *combo_urls;
extern gchar *get_bracketed_string (gchar *str);
extern GSList *prefixes;
extern GSList *plugins;
extern GtkWidget *main_notebook;

extern  gchar *language_settings[];
extern  gchar *default_charset_settings[];

static GSList *plugin_widgets = NULL;
static GSList *plugin_enable_disable = NULL;
static GdkWindow *gdkwindow = NULL;

typedef struct
{
     GtkWidget *widget;
     SkipStonePlugin *plugin;
     gint call_save;
}PluginWidget;
       

const gchar *reserved_prefixes[] = {"http:","https:","file:","ftp:",NULL};

static const struct
{
	gchar *node;
        void (*func)(CWindow *config_window);
}nodes[] =
{
	  {N_("Home"), init_home_node},
	  {N_("Helper Apps"), init_helper_apps_node},
	  {N_("Prefixes"), init_prefixes_node},
	  {N_("Misc"), init_misc_node},
	  {N_("Navigation"), init_navigation_node},
	  {N_("Mozilla"), init_mozilla_node},
	  {N_("Proxy"), init_proxy_node},
     	  {N_("Appearance"), init_appearance_node},
	  {N_("Fonts"), init_fonts_node},
	  {N_("Languages"), init_languages_node},
     	  {NULL,NULL}
};

static struct
{
	gchar *serif;
     	gchar *sansserif;
     	gchar *cursive;
     	gchar *fantasy;
     	gchar *monospace;
     	gint size;
     	gint min_size;
} font_tmp[LANG_FONT_NUM];

static gint config_is_opened = 0;

void open_config_dialog(GtkWidget *menuitem,gpointer data)
{
        GtkWidget *vbox, *buttonbox, *apply, *main_hbox;
	gchar *ctree_title[1] = { "SkipStone" };
     	CWindow *config_window;
     	GtkCTreeNode *mozilla_node = NULL, *zeronode = NULL;
	gint i;
	
     	D_ENTER;
     	
     	if (config_is_opened) {
	     	if (gdkwindow) gdk_window_raise(gdkwindow);
	     	D_RETURN;
	}
     
     	config_window = g_new0(CWindow,1);
	config_window->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        skipstone_window_set_icon(config_window->window);
	gtk_window_set_title(GTK_WINDOW(config_window->window), _("SkipStone configuration"));
     	gtk_window_set_default_size(GTK_WINDOW(config_window->window), 475,475);
     	gtk_window_set_position(GTK_WINDOW(config_window->window), GTK_WIN_POS_MOUSE);
     	config_window->notebook = gtk_notebook_new();
     	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(config_window->notebook), FALSE);
     	
     	config_window->ctree = gtk_ctree_new_with_titles(1, 0, ctree_title);
     	gtk_widget_set_usize(config_window->ctree,150, 0);
     	g_signal_connect(G_OBJECT(config_window->ctree), "tree_select_row", G_CALLBACK(on_tree_select), config_window);
	
     	/* insert nodes */
     	for (i = 0; nodes[i].func != NULL ; i++) {
	     	GtkCTreeNode *node;
	     	gchar *name[1];
	     	name[0] = _(nodes[i].node);
	     	if (i < 5)
		     	node = gtk_ctree_insert_node(GTK_CTREE(config_window->ctree), NULL, NULL, name, 5, NULL, NULL, NULL, NULL, FALSE, TRUE);
	     	else 
	       		node = gtk_ctree_insert_node(GTK_CTREE(config_window->ctree), mozilla_node, NULL, name, 5, NULL, NULL, NULL, NULL, FALSE, TRUE);
	     	gtk_ctree_node_set_row_data(GTK_CTREE(config_window->ctree), node, GINT_TO_POINTER(i));
		if (i == 0) 
			zeronode = node;
		
		if (i == 5) /* mozilla node */
	       		mozilla_node = node;
		nodes[i].func(config_window);
	}

       	skipstone_pack_plugin_configs(config_window,i);
     	
     	gtk_ctree_select(GTK_CTREE(config_window->ctree),zeronode);

     	vbox = gtk_vbox_new(0,5);
     	gtk_container_add(GTK_CONTAINER(config_window->window),vbox);
     	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
     	
     	main_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(vbox), main_hbox, TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(main_hbox), config_window->ctree, TRUE, TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(main_hbox), config_window->notebook, TRUE, TRUE, FALSE);
     	     				   
     	config_window->ok_button = gtk_button_new_with_label(_("Ok"));
	config_window->cancel_button = gtk_button_new_with_label(_("Cancel"));
	apply = gtk_button_new_with_label(_("Apply"));
     	gtk_widget_set_usize(config_window->ok_button,55,22);
     	gtk_widget_set_usize(config_window->cancel_button,55,22);
     	gtk_widget_set_usize(apply,55,22);
     
	buttonbox = gtk_hbox_new(0,0);
/*     	gtk_box_pack_start(GTK_BOX(vbox), buttonbox, FALSE, TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(buttonbox), config_window->ok_button, TRUE,TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(buttonbox), apply, TRUE,TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(buttonbox), config_window->cancel_button, TRUE,TRUE, 0);*/

        gtk_box_pack_start_defaults(GTK_BOX(vbox), buttonbox);
     	gtk_box_pack_start_defaults(GTK_BOX(buttonbox), config_window->ok_button);
     	gtk_box_pack_start_defaults(GTK_BOX(buttonbox), apply);
     	gtk_box_pack_start_defaults(GTK_BOX(buttonbox), config_window->cancel_button);
 
     
	gtk_widget_show_all(config_window->window);

	g_signal_connect(G_OBJECT(config_window->window),"destroy",G_CALLBACK(destroy_config_window),config_window);
	g_signal_connect(G_OBJECT(config_window->cancel_button),"clicked",G_CALLBACK(close_config_window),config_window);
	g_signal_connect(G_OBJECT(config_window->ok_button),"clicked",G_CALLBACK(on_config_ok),config_window);
	g_signal_connect(G_OBJECT(apply), "clicked",G_CALLBACK(on_config_apply), config_window);
       	setup_escape_key_handler(config_window->window);
     	gdkwindow = config_window->window->window;
     	config_is_opened = 1;
     	D_RETURN;
}

static void skipstone_pack_plugin_configs(CWindow *config_window,gint i)
{
     	GSList *l;
     	GtkCTreeNode *root = NULL;
     	gchar *text[1];
     	D_ENTER;
     	if (plugins == NULL) D_RETURN;
	for (l = plugins; l ; l = l->next) {
		SkipStonePlugin *plugin = (SkipStonePlugin *)l->data;	
		
		/* build the root node for plugins, this controls enable/disable settings */
		
		if (root==NULL) {
			GtkWidget *vbox, *label;
			GSList *ll;
			text[0]=_("Plugins");
			vbox = gtk_vbox_new(FALSE,0);
			for (ll=plugins; ll ; ll=ll->next) 
			{
				SkipStonePlugin *plugin=(SkipStonePlugin *)ll->data;
				gchar *t = g_strdup_printf("Disable %s",plugin->name);
				GtkWidget *cb = gtk_check_button_new_with_label(t);
				gboolean enabled = skipstone_plugin_is_enabled(plugin->name);
				g_free(t);
				gtk_box_pack_start(GTK_BOX(vbox), cb, FALSE, FALSE, 0);			  
				if (!enabled) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb), TRUE);
				plugin_enable_disable = g_slist_append(plugin_enable_disable,cb);
				g_object_set_data(G_OBJECT(cb), "name",plugin->name);
		       }
			label = gtk_label_new(_("\n\nEnabling or disabling a plugin won't have an effect\nwithout a restart"));
			gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
			root = gtk_ctree_insert_node(GTK_CTREE(config_window->ctree),NULL,NULL,text,5,NULL,NULL,NULL,NULL,FALSE,TRUE);
			gtk_ctree_node_set_row_data(GTK_CTREE(config_window->ctree),root,GINT_TO_POINTER(i));
			gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook), vbox, gtk_label_new(_("Plugins")));
			i++;
		}						     
	
		/* individual plugins config starts here */
		
		if (plugin && plugin->get_config_widget != NULL) {
			PluginWidget *pw;		  
			GtkWidget *plugin_config_widget;
			GtkCTreeNode *node;
			pw = g_new0(PluginWidget,1);
			pw->call_save=1;
			pw->plugin = plugin;
			plugin_config_widget=plugin->get_config_widget();
			/* failed to get config widget? */
			if (!plugin_config_widget) {
				GtkWidget *label;
				gchar *label_text;
				label_text=g_strdup_printf(_("Failed to load plugin %s config widget!"),plugin->name);
				label = gtk_label_new(label_text);
				g_free(label_text);
				plugin_config_widget = gtk_vbox_new(FALSE,0);
				gtk_box_pack_start(GTK_BOX(plugin_config_widget),label, FALSE, FALSE, 0);
				gtk_widget_show_all(plugin_config_widget);		       	
				pw->call_save=0;
			}		  
			pw->widget=plugin_config_widget;
			text[0]=plugin->name;
			node=gtk_ctree_insert_node(GTK_CTREE(config_window->ctree),root,NULL,text,5,NULL,NULL,NULL,NULL,FALSE,TRUE);
			gtk_ctree_node_set_row_data(GTK_CTREE(config_window->ctree),node,GINT_TO_POINTER(i));
			gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook), plugin_config_widget, gtk_label_new(plugin->name));
			plugin_widgets=g_slist_append(plugin_widgets,pw);
			i++;
		  
		}
						       
	}
	D_RETURN;
}
     
       

static void init_home_node(CWindow *config_window)
{

	GtkWidget *page1_label, *page1_vbox, *config_pic, *home_label, *home_hbox;
        gint loaded;
     	D_ENTER;
     	page1_label = gtk_label_new(_("Home"));
     	page1_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page1_vbox), 5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),page1_vbox,page1_label);

	config_pic = create_pixmap(config_window->window,"config.png",&loaded);
	gtk_box_pack_start(GTK_BOX(page1_vbox), config_pic, TRUE, TRUE, 5);

     	home_label = gtk_label_new(_("Home page: "));
     	gtk_widget_set_usize(home_label,100,10);
     	config_window->home_entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(config_window->home_entry),config.home);
	gtk_widget_set_usize(config_window->home_entry, 200, 0);
     	home_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(page1_vbox), home_hbox, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(home_hbox), home_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(home_hbox), config_window->home_entry, FALSE, FALSE, FALSE);
     	gtk_widget_show_all(page1_vbox);
	D_RETURN;
}

static void init_helper_apps_node(CWindow *config_window)
{
	GtkWidget *page2_label, *page2_vbox, *email_hbox, *download_label, *download_hbox,
	          *mailer_label;
	D_ENTER;
     	page2_label = gtk_label_new(_("Helper apps"));
     	page2_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page2_vbox), 5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook), page2_vbox, page2_label);
     	mailer_label = gtk_label_new(_("Mailer: "));
     	gtk_widget_set_usize(mailer_label,100,10);
     	config_window->email_entry = gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(config_window->email_entry),config.mailer);
	email_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(page2_vbox), email_hbox, FALSE, FALSE, FALSE);     
     	gtk_box_pack_start(GTK_BOX(email_hbox), mailer_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(email_hbox), config_window->email_entry, FALSE, FALSE, FALSE);
     	
     	mailer_label=gtk_label_new(_("Supported Switches:\n%t will be replaced with To address\n%s with subject\n%c with CC address\nand %b with bcc address"));
     	gtk_box_pack_start(GTK_BOX(page2_vbox), mailer_label, FALSE, FALSE, 0);
     
     	download_label = gtk_label_new(_("Download With: "));
     	gtk_widget_set_usize(download_label,100,10);
     	config_window->downloader_entry = gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(config_window->downloader_entry), config.downloader);
     	
     	download_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(page2_vbox), download_hbox, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(download_hbox), download_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(download_hbox), config_window->downloader_entry, FALSE, FALSE, FALSE);
     	D_RETURN;
}

static void init_prefixes_node(CWindow *config_window)
{
	GSList *l;
	GtkWidget *page3_label, *page3_vbox, *page2_prefix_hbox, *page2_prefix_add_button,
	          *page2_prefix_delete_button, *page2_prefix_label;
	gchar *prefix_clist_titles[] = {_("Prefix"),_("URL")};

     	D_ENTER;
     
	page3_label = gtk_label_new(_("Prefixes"));
	page3_vbox = gtk_vbox_new(0,0);
	gtk_container_set_border_width(GTK_CONTAINER(page3_vbox), 5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook), page3_vbox, page3_label);

	page2_prefix_label = gtk_label_new(_("Prefixes.  Specify prefixes such as 'fm:'\nthat will load alternate pages with the specified string."));
	gtk_box_pack_start(GTK_BOX(page3_vbox),page2_prefix_label,FALSE,FALSE,0);

	config_window->prefix_list = gtk_clist_new_with_titles(2,prefix_clist_titles);
	gtk_box_pack_start(GTK_BOX(page3_vbox),config_window->prefix_list,TRUE,TRUE,0);

	for (l = prefixes; l; l = l->next) {
		SkipPrefix *prefix = l->data;
		gchar *text[2];
	     	gint row;
	     	
	     	text[0] = prefix->prefix;
	       	text[1] = prefix->url;
		row = gtk_clist_append(GTK_CLIST(config_window->prefix_list),text);
		gtk_clist_set_row_data(GTK_CLIST(config_window->prefix_list),row,prefix);
	}

	page2_prefix_hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(page3_vbox),page2_prefix_hbox,FALSE,FALSE,0);

	page2_prefix_add_button = gtk_button_new_with_label(_("Add"));
	gtk_box_pack_start(GTK_BOX(page2_prefix_hbox),page2_prefix_add_button,TRUE,FALSE,0);
	g_signal_connect(G_OBJECT(page2_prefix_add_button),"clicked",G_CALLBACK(prefix_add_clicked),config_window->prefix_list);

	page2_prefix_delete_button = gtk_button_new_with_label(_("Delete"));
	gtk_box_pack_start(GTK_BOX(page2_prefix_hbox),page2_prefix_delete_button,TRUE,FALSE,0);
	g_signal_connect(G_OBJECT(page2_prefix_delete_button),"clicked",G_CALLBACK(prefix_delete_clicked),config_window->prefix_list);
	D_RETURN;
}


static void init_misc_node(CWindow *config_window)
{
	

	GtkWidget *page3_label, *page3_vbox, *maxpopup_label, *maxpopupbox, *max_go, 
	          *max_go_box, *clear_popup, *hbox;
     	gchar *temp;

	D_ENTER;	
     
     	page3_label = gtk_label_new(_("Misc"));
     	page3_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page3_vbox), 5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook), page3_vbox, page3_label);
     
     	config_window->respect_sizeto = gtk_check_button_new_with_label(_("Respect java script window sizing?"));
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->respect_sizeto, FALSE, FALSE, 0);
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->respect_sizeto), config.respect_sizeto);
     	
     	maxpopup_label = gtk_label_new(_("Maximum popup entries: "));
     	config_window->maxpopups_adj = gtk_adjustment_new(config.maxpopupitems,5,50,1,1,1);
     	config_window->maxpopups = gtk_spin_button_new(GTK_ADJUSTMENT(config_window->maxpopups_adj),1,0);
     	clear_popup = gtk_button_new_with_label(_("Clear popup items"));
     	g_signal_connect(G_OBJECT(clear_popup), "clicked", G_CALLBACK(clear_popup_urls), NULL);
     	maxpopupbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), maxpopupbox, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(maxpopupbox), maxpopup_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(maxpopupbox), config_window->maxpopups ,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(maxpopupbox), clear_popup, FALSE, FALSE, 0);
	
	max_go = gtk_label_new(_("Maximum Go menu items: "));
	config_window->max_go_adj = gtk_adjustment_new(config.max_go, 5, 50, 1, 1, 1);
	config_window->max_go = gtk_spin_button_new(GTK_ADJUSTMENT(config_window->max_go_adj), 1, 0);
	max_go_box = gtk_hbox_new(0,0);
	gtk_box_pack_start(GTK_BOX(max_go_box), max_go, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(max_go_box), config_window->max_go, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(page3_vbox), max_go_box, FALSE, FALSE, 0);
	
     	config_window->popup_in_new_window = gtk_check_button_new_with_label(_("Popups should have their own windows in tabbed mode?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->popup_in_new_window), config.popup_in_new_window);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->popup_in_new_window, FALSE, FALSE, 0);
     	
     	config_window->jump_to_new_tab = gtk_check_button_new_with_label(_("Automatically jump to new tabs?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->jump_to_new_tab), config.jump_to_new_tab);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->jump_to_new_tab, FALSE, FALSE, 0);

     	config_window->tabs_in_focus_order = gtk_check_button_new_with_label(_("When closing tabs, go to last focused tab?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->tabs_in_focus_order), config.tabs_in_focus_order);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->tabs_in_focus_order, FALSE, FALSE, 0);

     	config_window->show_tabs = gtk_check_button_new_with_label(_("Always show tabs in tabbed Mode?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->show_tabs), config.show_tabs);
     	max_go = gtk_label_new(_("If the above option is unchecked,\ntabs will only be shown\nwhen the number of open tabs is bigger than one."));
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->show_tabs, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), max_go, FALSE, FALSE, 0);

     	config_window->red_while_loading = gtk_check_button_new_with_label(_("Tab caption is red until page is loaded?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->red_while_loading), config.red_while_loading);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->red_while_loading, FALSE, FALSE, 0);

	config_window->natural_tabs = gtk_radio_button_new_with_label(NULL,_("Do not Shorten Tab Names."));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->natural_tabs), 0==config.shorten_tabs);     
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->natural_tabs, FALSE, FALSE, 0);
     	config_window->shorten_tabs = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(config_window->natural_tabs),_("Shorten Tab Names."));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->shorten_tabs), 1==config.shorten_tabs);     
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->shorten_tabs, FALSE, FALSE, 0);
     	config_window->fixed_tabs = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(config_window->natural_tabs),_("Use Fixed Tab Label Size"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->fixed_tabs), 2==config.shorten_tabs);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), config_window->fixed_tabs, FALSE, FALSE, 0);
     
     	max_go = gtk_label_new(_("Target length of tab label text: "));
     	config_window->tab_text_length = gtk_entry_new();
     	temp = g_strdup_printf("%d",config.tab_text_length);
     	gtk_entry_set_text(GTK_ENTRY(config_window->tab_text_length), temp);
     	g_free(temp);
     	hbox = gtk_hbox_new(FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(hbox), max_go, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(hbox), config_window->tab_text_length, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(page3_vbox), hbox, FALSE, FALSE, 0);
     	D_RETURN;
     	
}

static void init_navigation_node(CWindow *config_window)
{
	GtkWidget *page4_label, *page4_vbox, *page4_label2, *page4_hbox;
     	
     	D_ENTER;
     
	page4_label = gtk_label_new(_("Navigation Bar"));
	page4_vbox = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width(GTK_CONTAINER(page4_vbox),5);
	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),page4_vbox,page4_label);

	page4_label2 = gtk_label_new(_("Which buttons should appear in the navigation bar?"));
	gtk_box_pack_start(GTK_BOX(page4_vbox),page4_label2,FALSE,FALSE,0);

	page4_hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(page4_vbox),page4_hbox,FALSE,FALSE,0);

	config_window->back = gtk_toggle_button_new_with_label(_("Back"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->back),(config.navbar_buttons & NAVBAR_BACK));
	gtk_box_pack_start(GTK_BOX(page4_hbox),config_window->back,TRUE,FALSE,0);

	config_window->forw = gtk_toggle_button_new_with_label(_("Forward"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->forw),(config.navbar_buttons & NAVBAR_FOR));
	gtk_box_pack_start(GTK_BOX(page4_hbox),config_window->forw,TRUE,FALSE,0);

	config_window->reload = gtk_toggle_button_new_with_label(_("Reload"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->reload),(config.navbar_buttons & NAVBAR_RELOAD));
	gtk_box_pack_start(GTK_BOX(page4_hbox),config_window->reload,TRUE,FALSE,0);

	config_window->stop = gtk_toggle_button_new_with_label(_("Stop"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->stop),(config.navbar_buttons & NAVBAR_STOP));
	gtk_box_pack_start(GTK_BOX(page4_hbox),config_window->stop,TRUE,FALSE,0);

	config_window->home = gtk_toggle_button_new_with_label(_("Home"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->home),(config.navbar_buttons & NAVBAR_HOME));
	gtk_box_pack_start(GTK_BOX(page4_hbox),config_window->home,TRUE,FALSE,0);
	D_RETURN;
}


static void init_mozilla_node(CWindow *config_window)
{
	GtkWidget *page5_label, *page5_vbox, *images_label, *cookie_behavior, *disk_cache,
	          *cache_box, *cache_box2, *mem_cache, *images_box, *cookie_box,
       		  *search_box, *search_label;
	
	gchar *image_settings[] =  { _("Load all images"),
	       			     _("Only load images from originating server"),
	       			     _("Don't load images")
			       	   };
	gchar *cookie_settings[] = { _("Accept All cookies"), _("Dont accept Foreign cookies"), _("Dont use Cookies") };
	gint i;
     	
     	D_ENTER;
     
     	page5_label = gtk_label_new("Mozilla");
     	page5_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page5_vbox),5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),page5_vbox,page5_label);
	
     	config_window->java = gtk_check_button_new_with_label(_("Enable Java?"));
     	config_window->javascript = gtk_check_button_new_with_label(_("Enable JavaScript?"));
     	config_window->disable_popups = gtk_check_button_new_with_label(_("Disable Popup windows?"));
     
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->java), config.java);
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->javascript),config.javascript);
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->disable_popups),config.disable_popups);
     
     	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->java, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->javascript, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->disable_popups, FALSE, FALSE, FALSE);
	
	config_window->warn_about_cookie = gtk_check_button_new_with_label(_("Warn about cookies?"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->warn_about_cookie),  config.warn_about_cookie);

	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->warn_about_cookie, FALSE, FALSE, 0);

	config_window->remember_signons = gtk_check_button_new_with_label(_("Automatically Remember Signons?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->remember_signons), config.remember_signons);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->remember_signons, FALSE, FALSE, 0);
     	
	config_window->http_version = gtk_check_button_new_with_label(_("Use HTTP version 1.0? (if unchecked, 1.1 is used)"));
        if (!strcmp(config.http_version,"1.0")) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->http_version), TRUE);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), config_window->http_version, FALSE, FALSE, 0);
     
     	images_label = gtk_label_new(_("Images: "));
     	config_window->image_option_menu = gtk_option_menu_new();
     	config_window->image_menu = gtk_menu_new();
     	
     	for (i = 0; i < 3; i++) {
	     	GtkWidget *menu_item;
	     	menu_item = gtk_menu_item_new_with_label(image_settings[i]);
	     	g_object_set_data(G_OBJECT(menu_item),"image_setting",GINT_TO_POINTER(i));
	     	gtk_menu_append(GTK_MENU(config_window->image_menu), menu_item);
	}
     	
     	gtk_menu_set_active(GTK_MENU(config_window->image_menu), config.images);   	
     	gtk_option_menu_set_menu(GTK_OPTION_MENU(config_window->image_option_menu), config_window->image_menu);
	gtk_widget_set_usize(config_window->image_option_menu,250,30);
     	
     	images_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(images_box), images_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(images_box), config_window->image_option_menu, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), images_box, FALSE, FALSE, FALSE);
	
	cookie_behavior = gtk_label_new(_("Cookie Behavior: "));
	config_window->cookie_behavior = gtk_option_menu_new();
	config_window->cookie_behavior_menu = gtk_menu_new();
	
	for (i = 0; i < 3; i++) {
		GtkWidget *menu_item;
		menu_item = gtk_menu_item_new_with_label(cookie_settings[i]);
		g_object_set_data(G_OBJECT(menu_item), "cookie_setting", GINT_TO_POINTER(i));
		gtk_menu_append(GTK_MENU(config_window->cookie_behavior_menu), menu_item);
	}
	
	gtk_menu_set_active(GTK_MENU(config_window->cookie_behavior_menu), config.cookie_behavior);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(config_window->cookie_behavior), config_window->cookie_behavior_menu);
	gtk_widget_set_usize(config_window->cookie_behavior,250,30);

	cookie_box = gtk_hbox_new(0,0);
	gtk_box_pack_start(GTK_BOX(cookie_box), cookie_behavior, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(cookie_box), config_window->cookie_behavior, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(page5_vbox), cookie_box, FALSE, FALSE, 0);	
	
     	/* cache */
     	disk_cache = gtk_label_new(_("Disk Cache (0 to disable) "));
     	config_window->disk_cache = gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(config_window->disk_cache), config.disk_cache);
       	
     	mem_cache = gtk_label_new(_("Memory Cache (0 to disable) "));
     	config_window->mem_cache = gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(config_window->mem_cache),config.mem_cache);
     	
     	cache_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(cache_box), disk_cache, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(cache_box), config_window->disk_cache, FALSE, FALSE, FALSE);
     	
     	cache_box2 = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(cache_box2), mem_cache, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(cache_box2), config_window->mem_cache, FALSE, FALSE, FALSE);
     	
     	gtk_box_pack_start(GTK_BOX(page5_vbox), cache_box, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), cache_box2, FALSE, FALSE, FALSE);
     
     	search_box = gtk_hbox_new(0,0);
     	search_label = gtk_label_new(_("Default KeyWord Search URL"));
     	config_window->default_search_engine=gtk_entry_new();
     	gtk_entry_set_text(GTK_ENTRY(config_window->default_search_engine), config.default_search_engine);
     
     	gtk_box_pack_start(GTK_BOX(search_box), search_label, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(search_box), config_window->default_search_engine, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(page5_vbox), search_box, FALSE, FALSE, 0);
     	D_RETURN;
}
  
static void init_proxy_node(CWindow *config_window)
{
	GtkWidget *ftp_proxy_label, *ftp_proxy_port_label, *ftp_proxy_box,
	          *ssl_proxy_label, *ssl_proxy_port_label, *ssl_proxy_box,
	          *proxy_page_box, *proxy_page_label, *no_proxy_for_label,
	          *no_proxy_box, *proxy_box, *proxy_port_label, *proxy_label;
	D_ENTER;
     
     	proxy_page_label = gtk_label_new(_("Proxy"));
     	proxy_page_box = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(proxy_page_box),5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),proxy_page_box,proxy_page_label);
  	
     	config_window->direct_connection = gtk_check_button_new_with_label(_("Direct Connection to the Internet?"));
     	proxy_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(proxy_box), config_window->direct_connection, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(proxy_page_box), proxy_box, FALSE, FALSE, 0);
     	
     
     	proxy_label = gtk_label_new(_("HTTP Proxy: "));
     	proxy_port_label = gtk_label_new(_("  Port: "));
     	config_window->http_proxy = gtk_entry_new();
     	config_window->http_proxy_port = gtk_entry_new();
	ftp_proxy_label = gtk_label_new(_("FTP Proxy: "));
	ftp_proxy_port_label = gtk_label_new(_("  Port: "));
	ssl_proxy_label = gtk_label_new(_("SSL Proxy: "));
     	ssl_proxy_port_label = gtk_label_new(_("  Port: ")); 
     	config_window->ssl_proxy_port = gtk_entry_new();
     	gtk_widget_set_usize(proxy_label, 70, 20);
     	gtk_widget_set_usize(ftp_proxy_label, 70, 20);
     	gtk_widget_set_usize(ssl_proxy_label, 70, 20);
     	config_window->ftp_proxy = gtk_entry_new();
	config_window->ftp_proxy_port = gtk_entry_new();
     	config_window->ssl_proxy = gtk_entry_new();
     	config_window->ssl_proxy_port = gtk_entry_new();
     	gtk_widget_set_usize(config_window->ssl_proxy_port,35,24);
     	gtk_widget_set_usize(config_window->http_proxy_port,35,24);
	gtk_widget_set_usize(config_window->ftp_proxy_port, 35, 24);
     	proxy_box = gtk_hbox_new(0,0);
     	ftp_proxy_box = gtk_hbox_new(0,0);
	ssl_proxy_box = gtk_hbox_new(0,0);
     
     	if (config.http_proxy && strlen(config.http_proxy) > 0) 
	     	gtk_entry_set_text(GTK_ENTRY(config_window->http_proxy), config.http_proxy);	
     	
     	if (config.http_proxy_port && strlen(config.http_proxy_port) > 0) 
	     	gtk_entry_set_text(GTK_ENTRY(config_window->http_proxy_port), config.http_proxy_port);
	
	if (config.ftp_proxy && strlen(config.ftp_proxy) > 0) 
	     	gtk_entry_set_text(GTK_ENTRY(config_window->ftp_proxy), config.ftp_proxy);	
     	
     	if (config.ftp_proxy_port && strlen(config.ftp_proxy_port) > 0) 
	     	gtk_entry_set_text(GTK_ENTRY(config_window->ftp_proxy_port), config.ftp_proxy_port);

     	if (config.ssl_proxy && strlen(config.ssl_proxy) > 0)
	     	gtk_entry_set_text(GTK_ENTRY(config_window->ssl_proxy), config.ssl_proxy);
     	
     	if (config.ssl_proxy_port && strlen(config.ssl_proxy_port) > 0)
	     	gtk_entry_set_text(GTK_ENTRY(config_window->ssl_proxy_port), config.ssl_proxy_port);

     	no_proxy_for_label = gtk_label_new(_("No proxy for: "));
     	config_window->no_proxy_for = gtk_entry_new();
     	if (config.no_proxy_for && strlen(config.no_proxy_for) > 0) 
       		gtk_entry_set_text(GTK_ENTRY(config_window->no_proxy_for), config.no_proxy_for);
     	
     	no_proxy_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(no_proxy_box), no_proxy_for_label,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(no_proxy_box), config_window->no_proxy_for, FALSE, FALSE, FALSE);
     	
     	gtk_box_pack_start(GTK_BOX(proxy_box), proxy_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(proxy_box), config_window->http_proxy, TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(proxy_box), proxy_port_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(proxy_box), config_window->http_proxy_port, FALSE, FALSE, FALSE);
	
	gtk_box_pack_start(GTK_BOX(ftp_proxy_box), ftp_proxy_label, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(ftp_proxy_box), config_window->ftp_proxy, TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(ftp_proxy_box), ftp_proxy_port_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(ftp_proxy_box), config_window->ftp_proxy_port, FALSE, FALSE, FALSE);

     	gtk_box_pack_start(GTK_BOX(ssl_proxy_box), ssl_proxy_label, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(ssl_proxy_box), config_window->ssl_proxy, TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(ssl_proxy_box), ssl_proxy_port_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(ssl_proxy_box), config_window->ssl_proxy_port, FALSE, FALSE, FALSE);

	gtk_box_pack_start(GTK_BOX(proxy_page_box), proxy_box, FALSE, FALSE, FALSE);
 	gtk_box_pack_start(GTK_BOX(proxy_page_box), ftp_proxy_box, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(proxy_page_box), ssl_proxy_box, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(proxy_page_box), no_proxy_box, FALSE, FALSE, FALSE);
     
     	g_signal_connect(G_OBJECT(config_window->direct_connection), 
			   "toggled", G_CALLBACK(on_connection_type_toggle),
			   config_window);
     
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->direct_connection), config.direct_connection);
     	D_RETURN;
}

static void init_appearance_node(CWindow *config_window)
{
	GtkWidget *vbox, *label;
     
     	D_ENTER;
     
     	label = gtk_label_new(_("Appearance"));
     	vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),vbox,label);

     	config_window->use_document_colors = gtk_check_button_new_with_label(_("Use WebPage Provided Colors?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->use_document_colors), config.use_document_colors);
     	gtk_box_pack_start(GTK_BOX(vbox), config_window->use_document_colors, FALSE, FALSE, 0);
     
     	config_window->underline_links = gtk_check_button_new_with_label(_("Always underline links?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->underline_links), config.underline_links);
     	gtk_box_pack_start(GTK_BOX(vbox), config_window->underline_links, FALSE, FALSE, 0);
     	D_RETURN;
}

static void init_fonts_node(CWindow *config_window)
{
	const gchar *lang_font_name[] = { _("Western"),
					  _("Central European"),
					  _("Japanese"),
					  _("Traditional Chinese"),
					  _("Simplified Chinese"),
					  _("Korean"),
					  _("Cyrillic"),
					  _("Baltic"),
					  _("Greek"),
					  _("Turkish"),
					  _("Unicode"),
					  _("User Defined"),
					  _("Thai"),
					  _("Hebrew"),
					  _("Arabic")
					};

	GtkWidget  *serif_label, *sansserif_label, *cursive_label, *fantasy_label, *monospace_label,
	           *serif_hbox, *sansserif_hbox, *cursive_hbox, *fantasy_hbox, *monospace_hbox,
	           *serif_change, *sansserif_change, *cursive_change, *fantasy_change, *monospace_change,
	           *page6_label, *page6_vbox, *var_hbox, *var_font_label,
	           *lang_font_label, *lang_font_box, *min_font_label, *min_hbox;
	gint i;
       		   
	D_ENTER;
     
     	page6_label = gtk_label_new(_("Fonts"));
     	page6_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page6_vbox),5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),page6_vbox,page6_label);

     	config_window->use_document_fonts = gtk_check_button_new_with_label(_("Use WebPage Provided Fonts?"));
     	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_window->use_document_fonts), config.use_document_fonts);
     	gtk_box_pack_start(GTK_BOX(page6_vbox), config_window->use_document_fonts, FALSE, FALSE, 0);

     	lang_font_label = gtk_label_new(_("Font for: "));
     	config_window->lang_font_option_menu = gtk_option_menu_new();
     	config_window->lang_font_menu = gtk_menu_new();
     	
	for (i = 0; i < LANG_FONT_NUM; i++) {
	     	GtkWidget *menu_item;
	     	menu_item = gtk_menu_item_new_with_label(lang_font_name[i]);
	     	g_object_set_data(G_OBJECT(menu_item),"lang_font_setting",GINT_TO_POINTER(i));
	     	gtk_menu_append(GTK_MENU(config_window->lang_font_menu), menu_item);
		g_signal_connect( G_OBJECT(menu_item), "activate",
				    G_CALLBACK(lang_font_changed), config_window);

		font_tmp[i].size = config.font_size[i];
	     	font_tmp[i].min_size = config.min_font_size[i];
		font_tmp[i].serif = g_strdup(config.serif_font[i]);
		font_tmp[i].sansserif = g_strdup(config.sansserif_font[i]);
		font_tmp[i].cursive = g_strdup(config.cursive_font[i]);
		font_tmp[i].fantasy = g_strdup(config.fantasy_font[i]);
		font_tmp[i].monospace = g_strdup(config.monospace_font[i]);
	}
     	
     	gtk_menu_set_active(GTK_MENU(config_window->lang_font_menu), config.lang_font);   	
     	gtk_option_menu_set_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu), config_window->lang_font_menu);
	gtk_widget_set_usize(config_window->lang_font_option_menu,155,30);
     	
     	lang_font_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(lang_font_box), lang_font_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(lang_font_box), config_window->lang_font_option_menu, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox), lang_font_box, FALSE, FALSE, FALSE);
     
     	serif_label = gtk_label_new(_("Serif Font: "));
     	config_window->serif_font = gtk_entry_new();
     	gtk_entry_set_editable(GTK_ENTRY(config_window->serif_font),FALSE);
     	gtk_entry_set_text(GTK_ENTRY(config_window->serif_font),font_tmp[config.lang_font].serif);
     	g_signal_connect(G_OBJECT(config_window->serif_font), "changed", G_CALLBACK(font_changed), config_window);
     	serif_change = gtk_button_new_with_label(_("Change"));
     	g_signal_connect(G_OBJECT(serif_change), "clicked", G_CALLBACK(change_font), config_window->serif_font);
     	
     	
     	serif_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(serif_hbox),serif_label,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(serif_hbox),config_window->serif_font,TRUE, TRUE, FALSE);     	
        gtk_box_pack_start(GTK_BOX(serif_hbox),serif_change, FALSE, FALSE, FALSE);

       	var_font_label = gtk_label_new(_("Variable Font Size: "));
     	config_window->font_size_adj = gtk_adjustment_new(font_tmp[config.lang_font].size,10,50,1,1,1);
     	config_window->font_size =  gtk_spin_button_new(GTK_ADJUSTMENT(config_window->font_size_adj),1,0);
	g_signal_connect(G_OBJECT(config_window->font_size_adj), "value_changed",
			   G_CALLBACK(fontsize_changed),config_window);

     	min_font_label = gtk_label_new(_("Minimum Font Size: "));
     	config_window->min_font_size_adj = gtk_adjustment_new(font_tmp[config.lang_font].min_size,10,50,1,1,1);
     	config_window->min_font_size =  gtk_spin_button_new(GTK_ADJUSTMENT(config_window->min_font_size_adj),1,0);
	g_signal_connect(G_OBJECT(config_window->min_font_size_adj), "value_changed",
			   G_CALLBACK(min_fontsize_changed),config_window);

     
     	var_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(var_hbox),var_font_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(var_hbox),config_window->font_size, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox), var_hbox, FALSE, FALSE, FALSE);

     	min_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(min_hbox),min_font_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(min_hbox),config_window->min_font_size, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox), min_hbox, FALSE, FALSE, FALSE);

       
     
	sansserif_label = gtk_label_new(_("Sans Serif Font: "));
     	config_window->sansserif_font = gtk_entry_new();
     	gtk_entry_set_editable(GTK_ENTRY(config_window->sansserif_font),FALSE);
     	gtk_entry_set_text(GTK_ENTRY(config_window->sansserif_font), font_tmp[config.lang_font].sansserif);
     	g_signal_connect(G_OBJECT(config_window->sansserif_font), "changed", G_CALLBACK(font_changed), config_window);
     	sansserif_change = gtk_button_new_with_label(_("Change"));
     	g_signal_connect(G_OBJECT(sansserif_change), "clicked", G_CALLBACK(change_font), config_window->sansserif_font);
     	sansserif_hbox = gtk_hbox_new(0,0);
	
     	gtk_box_pack_start(GTK_BOX(sansserif_hbox),sansserif_label,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(sansserif_hbox),config_window->sansserif_font,TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(sansserif_hbox),sansserif_change, FALSE, FALSE, FALSE);

	cursive_label = gtk_label_new(_("Cursive Font: "));
     	config_window->cursive_font = gtk_entry_new();
     	gtk_entry_set_editable(GTK_ENTRY(config_window->cursive_font),FALSE);
     	gtk_entry_set_text(GTK_ENTRY(config_window->cursive_font), font_tmp[config.lang_font].cursive);
     	g_signal_connect(G_OBJECT(config_window->cursive_font), "changed", G_CALLBACK(font_changed), config_window);
     	cursive_change = gtk_button_new_with_label(_("Change"));
     	g_signal_connect(G_OBJECT(cursive_change), "clicked", G_CALLBACK(change_font), config_window->cursive_font);
     	cursive_hbox = gtk_hbox_new(0,0);
	
     	gtk_box_pack_start(GTK_BOX(cursive_hbox),cursive_label,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(cursive_hbox),config_window->cursive_font,TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(cursive_hbox),cursive_change, FALSE, FALSE, FALSE);

	fantasy_label = gtk_label_new(_("Fantasy Font: "));
     	config_window->fantasy_font = gtk_entry_new();
     	gtk_entry_set_editable(GTK_ENTRY(config_window->fantasy_font),FALSE);
     	gtk_entry_set_text(GTK_ENTRY(config_window->fantasy_font), font_tmp[config.lang_font].fantasy);
     	g_signal_connect(G_OBJECT(config_window->fantasy_font), "changed", G_CALLBACK(font_changed), config_window);
     	fantasy_change = gtk_button_new_with_label(_("Change"));
     	g_signal_connect(G_OBJECT(fantasy_change), "clicked", G_CALLBACK(change_font), config_window->fantasy_font);
     	fantasy_hbox = gtk_hbox_new(0,0);
	
     	gtk_box_pack_start(GTK_BOX(fantasy_hbox),fantasy_label,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(fantasy_hbox),config_window->fantasy_font,TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(fantasy_hbox),fantasy_change, FALSE, FALSE, FALSE);
       
     	monospace_label = gtk_label_new(_("MonoSpace Font: "));
     	config_window->monospace_font = gtk_entry_new();
     	gtk_entry_set_editable(GTK_ENTRY(config_window->monospace_font), FALSE);
     	gtk_entry_set_text(GTK_ENTRY(config_window->monospace_font), font_tmp[config.lang_font].monospace);
     	g_signal_connect(G_OBJECT(config_window->monospace_font), "changed", G_CALLBACK(font_changed), config_window);
       	monospace_change = gtk_button_new_with_label(_("Change"));
     	g_signal_connect(G_OBJECT(monospace_change), "clicked", G_CALLBACK(change_font), config_window->monospace_font);
     	monospace_hbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(monospace_hbox), monospace_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(monospace_hbox), config_window->monospace_font, TRUE, TRUE, FALSE);
     	gtk_box_pack_start(GTK_BOX(monospace_hbox), monospace_change, FALSE, FALSE, FALSE);
     	
     	gtk_box_pack_start(GTK_BOX(page6_vbox),serif_hbox,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox),sansserif_hbox,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox),cursive_hbox,FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page6_vbox),fantasy_hbox,FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(page6_vbox),monospace_hbox, FALSE, FALSE, FALSE);
       	D_RETURN;
}

static void init_languages_node(CWindow *config_window)
{
	static GList *charset_items = NULL;
	static gboolean charset_list_done = 0;
	gint i;
	GtkWidget *language_box, *default_charset_box, *accept_languages_box,
	          *page7_label, *page7_vbox, *sw, *clist, *language_label,
	          *default_charset_label, *accept_languages_label;
	D_ENTER;
     	page7_label = gtk_label_new(_("Languages"));
     	page7_vbox = gtk_vbox_new(0,5);
     	gtk_container_set_border_width(GTK_CONTAINER(page7_vbox),5);
     	gtk_notebook_append_page(GTK_NOTEBOOK(config_window->notebook),page7_vbox,page7_label);

     	language_label = gtk_label_new(_("Auto-detect Languages: "));
     	config_window->language_option_menu = gtk_option_menu_new();
     	config_window->language_menu = gtk_menu_new();
     	
	for (i = 0; i < 9; i++) {
	     	GtkWidget *menu_item;
	     	menu_item = gtk_menu_item_new_with_label(_(language_settings[i]));
	     	g_object_set_data(G_OBJECT(menu_item),"language_setting",GINT_TO_POINTER(i));
	     	gtk_menu_append(GTK_MENU(config_window->language_menu), menu_item);
	}
     	
     	gtk_menu_set_active(GTK_MENU(config_window->language_menu), config.language);   	
     	gtk_option_menu_set_menu(GTK_OPTION_MENU(config_window->language_option_menu), config_window->language_menu);
	gtk_widget_set_usize(config_window->language_option_menu,155,30);
     	
     	language_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(language_box), language_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(language_box), config_window->language_option_menu, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page7_vbox), language_box, FALSE, FALSE, FALSE);

     	default_charset_label = gtk_label_new(_("Default Charset: "));
     	config_window->default_charset_combo = gtk_combo_new();


	if (!charset_list_done)
	{
		for (i = 0; default_charset_settings[i] != NULL ; i++) {
			charset_items = g_list_append (charset_items, _(default_charset_settings[i]));
		}
		charset_list_done = 1;
	}
     
  	gtk_combo_set_popdown_strings (GTK_COMBO (config_window->default_charset_combo), charset_items);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(config_window->default_charset_combo)->entry), config.default_charset);
	gtk_combo_disable_activate(GTK_COMBO(config_window->default_charset_combo));
	gtk_widget_set_usize(config_window->default_charset_combo,230,30);
     	
     	default_charset_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(default_charset_box), default_charset_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(default_charset_box), config_window->default_charset_combo, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page7_vbox), default_charset_box, FALSE, FALSE, FALSE);

     	accept_languages_label = gtk_label_new(_("Accept Languages: "));
     	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
     	clist = gtk_clist_new(1);
	accept_languages_setup_or_lookup(clist, 0);
     	g_signal_connect(G_OBJECT(clist), "select-row", G_CALLBACK(on_languages_select), config_window);
     	g_signal_connect(G_OBJECT(clist), "unselect-row", G_CALLBACK(on_languages_unselect), config_window);
     	
	gtk_container_add(GTK_CONTAINER(sw),clist);
	gtk_widget_set_usize(clist,210,100);
     	
     	accept_languages_box = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(accept_languages_box), accept_languages_label, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(accept_languages_box), sw, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(page7_vbox), accept_languages_box, FALSE, FALSE, FALSE);
	D_RETURN;
}

static void on_config_apply(GtkWidget *button, CWindow *config_window)
{
     	D_ENTER;
     	save_config(config_window,0);
     	D_RETURN;
}

static void on_config_ok(GtkWidget *button, CWindow *config_window)
{
     	D_ENTER;
     	save_config(config_window, 1);
     	D_RETURN;
}

static void on_tree_select(GtkWidget *ctree, GtkCTreeNode *node, gint column, CWindow *config_window)
{
     	gint page;
     	D_ENTER;
     	page = GPOINTER_TO_INT(gtk_ctree_node_get_row_data(GTK_CTREE(ctree), node));
     	gtk_notebook_set_page(GTK_NOTEBOOK(config_window->notebook), page);
     	D_RETURN;
}

static void destroy_config_window(GtkWidget *window,CWindow *config_window) 
{
	gint i;
	
     	D_ENTER;
	
     	for (i = 0; i < LANG_FONT_NUM; i++) {
		g_free(font_tmp[i].serif);
		g_free(font_tmp[i].sansserif);
		g_free(font_tmp[i].cursive);
		g_free(font_tmp[i].fantasy);
		g_free(font_tmp[i].monospace);
	}
	
     	g_free(config_window);
     	
     	if (plugin_widgets != NULL) {
	     GSList *l=NULL;
	     for (l = plugin_widgets; l ; l=l->next) {
		  	if (l->data) g_free(l->data);
	     }
	     g_slist_free(plugin_widgets);
	     plugin_widgets=NULL;	     	
	}
        
        if (plugin_enable_disable != NULL) {
	   g_slist_free(plugin_enable_disable);
	   plugin_enable_disable=NULL;
	}
   
   
     	config_is_opened = 0;
        	
     	D_RETURN;
}

static void close_config_window(GtkWidget* button, CWindow *config_window) {
     D_ENTER;     	
     gtk_widget_destroy(config_window->window);
     D_RETURN;
}


static void on_connection_type_toggle(GtkWidget *toggle_button, CWindow *config_window)
{
     gboolean tag = TRUE;
     D_ENTER;
     if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(toggle_button)))
	  	tag = FALSE;
     gtk_widget_set_sensitive(config_window->http_proxy, tag);
     gtk_widget_set_sensitive(config_window->http_proxy_port, tag);
     gtk_widget_set_sensitive(config_window->ftp_proxy, tag);
     gtk_widget_set_sensitive(config_window->ftp_proxy_port, tag);
     gtk_widget_set_sensitive(config_window->ssl_proxy, tag);
     gtk_widget_set_sensitive(config_window->ssl_proxy_port, tag);
     gtk_widget_set_sensitive(config_window->no_proxy_for, tag);
     D_RETURN;
}
	  
	  	

static void clear_popup_urls(void)
{
	GSList *l;
     	D_ENTER;
     	g_list_free(combo_urls);
     	combo_urls = NULL;
     	combo_urls = g_list_append(combo_urls,"");
     	for (l = window_count; l; l = l->next) {
		SkipStone *skipstone = l->data;
	     	gchar *text = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry)));
	     	gtk_combo_set_popdown_strings(GTK_COMBO(skipstone->combo), combo_urls);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), text);
		g_free(text);
	}
     	write_urls();
     	D_RETURN;
}

static void lang_font_changed (GtkWidget *widget, CWindow *config_window) {
	gint lang_font;
     	D_ENTER;
	lang_font = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu))))),"lang_font_setting"));
     	gtk_spin_button_set_value(GTK_SPIN_BUTTON(config_window->font_size), font_tmp[lang_font].size);
     	gtk_spin_button_set_value(GTK_SPIN_BUTTON(config_window->min_font_size), font_tmp[lang_font].min_size);
     	gtk_entry_set_text(GTK_ENTRY(config_window->serif_font),font_tmp[lang_font].serif);
     	gtk_entry_set_text(GTK_ENTRY(config_window->sansserif_font), font_tmp[lang_font].sansserif);
     	gtk_entry_set_text(GTK_ENTRY(config_window->cursive_font), font_tmp[lang_font].cursive);
     	gtk_entry_set_text(GTK_ENTRY(config_window->fantasy_font), font_tmp[lang_font].fantasy);
     	gtk_entry_set_text(GTK_ENTRY(config_window->monospace_font), font_tmp[lang_font].monospace);
	D_RETURN;
}

static void change_font(GtkWidget *button, GtkWidget *entry)
{
     GtkWidget *fs;
     D_ENTER;
     fs = gtk_font_selection_dialog_new(_("Select Font"));
     gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fs), gtk_entry_get_text(GTK_ENTRY(entry)));
     g_signal_connect(G_OBJECT(GTK_FONT_SELECTION_DIALOG(fs)->cancel_button), "clicked", G_CALLBACK(close_font_selection), fs);
     g_signal_connect(G_OBJECT(GTK_FONT_SELECTION_DIALOG(fs)->ok_button), "clicked", G_CALLBACK(set_font), fs);
     g_object_set_data(G_OBJECT(GTK_FONT_SELECTION_DIALOG(fs)->ok_button),"entry", entry);
     gtk_widget_hide(GTK_WIDGET(GTK_FONT_SELECTION_DIALOG(fs)->apply_button));     
     gtk_widget_show(fs);
     D_RETURN;
}

static void close_font_selection(GtkWidget *button, GtkWidget *fs)
{
     	D_ENTER;
     	gtk_widget_destroy(fs);
	D_RETURN;     
}

static void set_font(GtkWidget *button, GtkWidget *fs)
{
     	gchar *font;
     	D_ENTER;
     	font = gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(fs));
     	if (font) {
	     	GtkEntry *entry = g_object_get_data(G_OBJECT(button),"entry");
		gtk_entry_set_text(GTK_ENTRY(entry), font);
	     	gtk_widget_destroy(fs);
		g_free(font);
	}
	D_RETURN;
}

static void fontsize_changed (GtkWidget *widget, CWindow *config_window)
{
	gint lang_font;
	D_ENTER;
     
	lang_font = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu))))),"lang_font_setting"));

	font_tmp[lang_font].size = GTK_ADJUSTMENT(widget)->value;
     	D_RETURN;
}

static void min_fontsize_changed (GtkWidget *widget, CWindow *config_window)
{
	gint lang_font;
	D_ENTER;
     
	lang_font = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu))))),"lang_font_setting"));

	font_tmp[lang_font].min_size = GTK_ADJUSTMENT(widget)->value;
     	D_RETURN;
}

static void font_changed (GtkWidget *entry, CWindow *config_window)
{
	gint lang_font;
	
     	D_ENTER;
     
	lang_font = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu))))),"lang_font_setting"));

	if (entry == config_window->serif_font) {
		g_free (font_tmp[lang_font].serif);
		font_tmp[lang_font].serif = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->serif_font)));
	} else if (entry == config_window->sansserif_font) {
		g_free (font_tmp[lang_font].sansserif);
		font_tmp[lang_font].sansserif = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->sansserif_font)));
	} else if (entry == config_window->cursive_font) {
		g_free (font_tmp[lang_font].cursive);
		font_tmp[lang_font].cursive = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->cursive_font)));
	} else if (entry == config_window->fantasy_font) {
		g_free (font_tmp[lang_font].fantasy);
		font_tmp[lang_font].fantasy = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->fantasy_font)));
	} else if (entry == config_window->monospace_font) {
		g_free (font_tmp[lang_font].monospace);
		font_tmp[lang_font].monospace = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->monospace_font)));
	}
     	D_RETURN;
}

static void on_languages_select(GtkCList *clist, gint row, gint column, GdkEventButton *event)
{
     	D_ENTER;
	config.accept_languages_temp[row] = '1';
     	D_RETURN;
}

static void on_languages_unselect(GtkCList *clist, gint row, gint column, GdkEventButton *event)
{
     	D_ENTER;
	config.accept_languages_temp[row] = '0';
     	D_RETURN;
}

static void prefix_add_clicked(GtkWidget *button,GtkCList *clist)
{
     	D_ENTER;
	open_add_prefix_window(clist);
     	D_RETURN;
}

static void prefix_delete_clicked(GtkWidget *button,GtkCList *clist)
{
	GList *selected;
	gint row;
	SkipPrefix *prefix;
	
     	D_ENTER;
     
	selected  = clist->selection;	
	if (!selected || selected == NULL) D_RETURN;
	row = GPOINTER_TO_INT(selected->data);
	prefix = gtk_clist_get_row_data(clist,row);

	prefixes = g_slist_remove(prefixes,prefix);

	gtk_clist_remove(clist,row);

	g_free(prefix);

	D_RETURN;
}

static void open_add_prefix_window(GtkCList *clist)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox1;
	GtkWidget *prefix_label;
	GtkWidget *prefix_entry;
	GtkWidget *hbox2;
	GtkWidget *url_label;
	GtkWidget *url_entry;
	GtkWidget *hbox3;
	GtkWidget *add_button;
	GtkWidget *cancel_button;

     	D_ENTER;
     
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
     	setup_escape_key_handler(window);
     	gtk_window_set_title(GTK_WINDOW(window), _("SkipStone - Prefix Editor"));
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);	
	g_signal_connect(G_OBJECT(window),"delete_event",G_CALLBACK(prefix_window_delete_event),NULL);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);

	hbox1 = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox1,FALSE,FALSE,0);

	prefix_label = gtk_label_new(_("Prefix (ends with a colon):"));
	gtk_box_pack_start(GTK_BOX(hbox1),prefix_label,FALSE,FALSE,0);

	prefix_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox1),prefix_entry,TRUE,TRUE,0);
	g_object_set_data(G_OBJECT(window),"prefix",prefix_entry);

	hbox2 = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox2,FALSE,FALSE,0);
	
	url_label = gtk_label_new(_("Url (%s will be replaced with the entry):"));
	gtk_box_pack_start(GTK_BOX(hbox2),url_label,FALSE,FALSE,0);

	url_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox2),url_entry,TRUE,TRUE,0);
	g_object_set_data(G_OBJECT(window),"url",url_entry);

	hbox3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox3,FALSE,FALSE,0);

	add_button = gtk_button_new_with_label(_("Add"));
	gtk_box_pack_start(GTK_BOX(hbox3),add_button,TRUE,TRUE,0);
	g_signal_connect(G_OBJECT(add_button),"clicked",G_CALLBACK(real_prefix_add_clicked),window);

	cancel_button = gtk_button_new_with_label(_("Cancel"));
	gtk_box_pack_start(GTK_BOX(hbox3),cancel_button,TRUE,TRUE,0);
	g_signal_connect(G_OBJECT(cancel_button),"clicked",G_CALLBACK(cancel_prefix_add_clicked),window);

	g_object_set_data(G_OBJECT(window),"clist",clist);
	gtk_widget_show_all(window);

	D_RETURN;
}

static gboolean prefix_window_delete_event(GtkWidget *window,GdkEvent *event,gpointer user_data)
{
     	D_ENTER;
	gtk_widget_destroy(window);
	D_RETURN_ (TRUE);
}

static void real_prefix_add_clicked(GtkWidget *button,GtkWidget *window)
{
	SkipPrefix *prefix = g_new0(SkipPrefix,1);
	gchar *text[2] = {NULL};
	gint row;
	GtkCList *clist = GTK_CLIST(g_object_get_data(G_OBJECT(window),"clist"));
	gint i;
     	
     	D_ENTER;

	text[0] = prefix->prefix = g_strdup(gtk_entry_get_text(GTK_ENTRY(g_object_get_data(G_OBJECT(window),"prefix"))));

	for (i = 0; reserved_prefixes[i]; i++) {
		if (g_strcasecmp(text[0],reserved_prefixes[i]) == 0) {
			g_free(prefix);	
			g_free(text[0]);
			D_RETURN;
		}
	}

	
	text[1] = prefix->url = g_strdup(gtk_entry_get_text(GTK_ENTRY(g_object_get_data(G_OBJECT(window),"url"))));

	

	row = gtk_clist_append(clist,text);
	gtk_clist_set_row_data(clist,row,prefix);

	prefixes = g_slist_prepend(prefixes,prefix);

	gtk_widget_destroy(window);

	D_RETURN;
}

static void cancel_prefix_add_clicked(GtkWidget *button,GtkWidget *window)
{
     	D_ENTER;
	gtk_widget_destroy(window);
	D_RETURN;
}
	


#define ACCEPT_LANG_NUM 66
gchar *accept_languages_setup_or_lookup(GtkWidget *clist, gint lookup_only)
{
	gchar *accept_languages_settings[ACCEPT_LANG_NUM] =  { 	
					_("Afrikaans (af)"),
					_("Albanian (sq)"),
					_("Arabic (ar)"),
					_("Basque (eu)"),
					_("Bulgarian (bg)"),
					_("Byelorussian (be)"),
					_("Catalan (ca)"),
					_("Chinese (zh)"),
	     				_("Chinese/China (zh-cn)"),
	     				_("Chinese/Taiwan (zh-tw)"),	     
					_("Croatian (hr)"),
					_("Czech (cs)"),
					_("Danish (da)"),
					_("Dutch (nl)"),
	     				_("Dutch/Belgium (nl-be)"),
					_("English (en)"),
	     				_("English/Australia (en-au)"),
	     				_("English/United Kingdom (en-gb)"),
	     				_("English/United States (en-us)"),
	     				_("Esperanto (eo)"),
					_("Estonian (et)"),
					_("Faeroese (fo)"),
					_("Finnish (fi)"),
					_("French (fr)"),
	     				_("French/Belgium (fr-be)"),
	     				_("French/Canada (fr-ca)"),
	     				_("French/France (fr-fr)"),
	     				_("French/Switzerland (fr-ch)"),
					_("Galician (gl)"),
					_("German (de)"),
	     				_("German/Austria (de-at)"),
	     				_("German/Germany (de-de)"),
	     				_("German/Switzerland (de-ch)"),
					_("Greek (el)"),
	     				_("Hebrew (he)"),
					_("Hungarian (hu)"),
					_("Icelandic (is)"),
					_("Indonesian (id)"),
	     				_("Indonesian (in)"),
					_("Irish (ga)"),
	     				_("Italian (it)"),
	     				_("Japanese (ja)"),
					_("Korean (ko)"),
	     				_("Latvian (lv)"),
	     				_("Lithuanian (lt)"),
					_("Macedonian/F.Y.R. of Macedonia (mk-mk)"),
					_("Norwegian (no)"),
	     				_("Norwegian Bokmai (nb)"),
	     				_("Norwegian Nynorsk (nn)"),
					_("Polish (pl)"),
					_("Portoguese (pt)"),
	     				_("Portoguese (pt-br)"),
					_("Romanian (ro)"),
					_("Russian (ru)"),
	     				_("Scots Gaelic (gd)"),
					_("Serbian (sr)"),
					_("Slovak (sk)"),
					_("Slovenian (sl)"),
					_("Spanish (es)"),
	     				_("Spansih/Argentina (es-ar)"),
	     				_("Spanish/Colombia (es-co)"),
	     				_("Spanish/Mexico (es-mx)"),
	     				_("Spanish/Spain (es-es)"),
					_("Swedish (sv)"),
					_("Turkish (tr)"),
					_("Ukrainian (uk)"),
	};
	gint i, j, count=0, lbound;
	gchar buffer[128], lang[8], *language, **langs;

	D_ENTER;

	if (lookup_only)
	{
		buffer[0] = '\0';
		for(i=0;i<ACCEPT_LANG_NUM; i++)
		{
			if (config.accept_languages_temp[i] == '1')
			{
				language = get_bracketed_string(accept_languages_settings[i]);
				if (language)
				{
					strcat(buffer, language);
					strcat(buffer, ",");
					g_free(language);
					count++;
				}
			}
		}
		if (count > 0) {
		     	gchar *tmp = g_strndup(buffer, strlen(buffer) - 1);
			D_RETURN_(tmp);
		} else {
			D_RETURN_((gchar *) "");
		}
	}
	else
	{
		g_free(config.accept_languages_temp);
		config.accept_languages_temp = (gchar *) g_malloc(ACCEPT_LANG_NUM);
		for (i = 0; i<ACCEPT_LANG_NUM; i++) {
			gchar *clist_entry[1];
			clist_entry[0] = (gchar *)g_strdup(accept_languages_settings[i]);
			gtk_clist_append(GTK_CLIST(clist),  clist_entry);
			config.accept_languages_temp[i] = '0';
		}
		gtk_clist_set_selection_mode((GTK_CLIST(clist)), GTK_SELECTION_MULTIPLE);
		langs = g_strsplit(config.accept_languages, ",", 0);

		for (lbound = i = 0; langs[i] != NULL; i++)
		{
			g_snprintf(lang, sizeof(lang), "(%s)", langs[i]);
			for (j = lbound; j < ACCEPT_LANG_NUM; j++) {
				if (strstr(accept_languages_settings[j], lang))
				{
					config.accept_languages_temp[j] = '1';
					lbound = j;
					gtk_clist_select_row(GTK_CLIST(clist), j, 0);
					break;
				}
			}
			if (j == ACCEPT_LANG_NUM)
				lbound = 0;	/* Search from beginning */
		}
		g_strfreev(langs);

		D_RETURN_ ((gchar *) "");
	}
}


static void save_config(CWindow *config_window, gint close)
{
	gint i,x,o;
     	gchar *accept_languages; 
        G_CONST_RETURN gchar *tmp;
     	GSList *l = NULL;
	
     	D_ENTER;
     
     	g_free(config.home);
	g_free(config.mailer);
     	g_free(config.downloader);
     	g_free(config.http_proxy);
     	g_free(config.http_proxy_port);
	g_free(config.no_proxy_for);
     	g_free(config.disk_cache);
     	g_free(config.mem_cache);
	g_free(config.ftp_proxy);
	g_free(config.ftp_proxy_port);
	g_free(config.ssl_proxy);
     	g_free(config.ssl_proxy_port);
     	g_free(config.default_search_engine);
     	g_free(config.http_version);
     
     	x = config.navbar_buttons;		     
	o = config.show_tabs;
     
     	config.navbar_buttons = 0;

	for (i=0; i < LANG_FONT_NUM; i++) {
		g_free(config.serif_font[i]);
     		g_free(config.sansserif_font[i]);
     		g_free(config.cursive_font[i]);
     		g_free(config.fantasy_font[i]);
     		g_free(config.monospace_font[i]);

		config.font_size[i] = font_tmp[i].size;
	     	config.min_font_size[i] = font_tmp[i].min_size;
		config.serif_font[i] = g_strdup(font_tmp[i].serif);
		config.sansserif_font[i] = g_strdup(font_tmp[i].sansserif);
		config.cursive_font[i] = g_strdup(font_tmp[i].cursive);
		config.fantasy_font[i] = g_strdup(font_tmp[i].fantasy);
     		config.monospace_font[i] = g_strdup(font_tmp[i].monospace);
	}
	config.lang_font = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->lang_font_option_menu))))),"lang_font_setting"));
	config.home = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->home_entry)));
     	config.mailer = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->email_entry)));
	config.downloader = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->downloader_entry)));       
	config.maxpopupitems = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(config_window->maxpopups));
	config.max_go = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(config_window->max_go));
	config.java = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->java));
     	config.popup_in_new_window = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->popup_in_new_window));
     	config.javascript = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->javascript));
     	config.disable_popups = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->disable_popups));
     	config.show_tabs = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->show_tabs));
     	config.direct_connection = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->direct_connection));
     	config.warn_about_cookie = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->warn_about_cookie));
     	config.jump_to_new_tab = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->jump_to_new_tab));
     	config.red_while_loading = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->red_while_loading));
     	config.shorten_tabs =  gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->shorten_tabs)) ?
       			       1 : gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->fixed_tabs)) ? 
       			       2 : 0;
     	config.remember_signons = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->remember_signons));
        config.tabs_in_focus_order = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->tabs_in_focus_order));
     	config.use_document_fonts = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->use_document_fonts));
     	config.underline_links = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->underline_links));
     	config.use_document_colors = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->use_document_colors));
     	tmp = gtk_entry_get_text(GTK_ENTRY(config_window->tab_text_length));
     	if (tmp && strcmp(tmp,"") != 0)
       		config.tab_text_length = atoi (tmp);
     	else
       		config.tab_text_length = 50; /* safe default */
     	config.default_search_engine = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->default_search_engine)));
	config.http_proxy = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->http_proxy)));
     	config.http_proxy_port = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->http_proxy_port)));
     	config.ftp_proxy = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->ftp_proxy)));
	config.ftp_proxy_port = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->ftp_proxy_port)));
     	config.ssl_proxy = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->ssl_proxy)));
	config.ssl_proxy_port = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->ssl_proxy_port)));
     	config.no_proxy_for = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->no_proxy_for)));
     	config.images = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->image_option_menu))))),"image_setting"));
     	config.cookie_behavior = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->cookie_behavior))))),"cookie_setting"));
	config.language = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(config_window->language_option_menu))))),"language_setting"));
	config.default_charset = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(config_window->default_charset_combo)->entry)));

	accept_languages = accept_languages_setup_or_lookup(NULL, 1);
	g_free(config.accept_languages);
	config.accept_languages = g_strdup(accept_languages);
     	config.respect_sizeto = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->respect_sizeto));
	config.disk_cache = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->disk_cache)));
     	config.mem_cache = g_strdup(gtk_entry_get_text(GTK_ENTRY(config_window->mem_cache)));
     
     	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->http_version))) {
		config.http_version = g_strdup("1.0");
	} else {
	     	config.http_version = g_strdup("1.1");
	}
     
     	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->back))) {
		config.navbar_buttons += NAVBAR_BACK;
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->forw))) {
		config.navbar_buttons += NAVBAR_FOR;
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->reload))) {
		config.navbar_buttons += NAVBAR_RELOAD;
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->stop))) {
		config.navbar_buttons += NAVBAR_STOP;
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_window->home))) {
		config.navbar_buttons += NAVBAR_HOME;
	}

     	if (x != config.navbar_buttons) { /* have they changed, update if so */
	     	 for (l = window_count; l; l=l->next) {
	       		SkipStone *skipstone = (SkipStone *)l->data;	     
	     		if (skipstone)
	     			create_toolbar(skipstone,1);
		 }
	}
	
	if (o != config.show_tabs) {     
	     	gint length;
	     	length = g_slist_length(window_count);
	     	if (length == 1)
	       		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), config.show_tabs);
	}

     	if (plugin_widgets != NULL) {
	     for (l=plugin_widgets;l;l=l->next) {
		  PluginWidget *pw = (PluginWidget *)l->data;
		  if (pw && pw->call_save && pw->plugin->save_your_config != NULL) {
		       pw->plugin->save_your_config(pw->widget);
		  }
	     }
	}
   
   
   if (plugin_enable_disable != NULL) 
     {
	for (l = plugin_enable_disable; l ; l = l->next) 
	  {
	     gchar *name = (gchar *)g_object_get_data(G_OBJECT(l->data), "name");
	     gchar *key = g_strdup_printf("%s-Enabled",name);
	     gboolean enabled = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(l->data));
	     if (enabled == TRUE) skipstone_set_config_value_as_int("SkipStoneInternal",key,0);
	     else skipstone_set_config_value_as_int("SkipStoneInternal",key,1);
	     g_free(key);
	  }	
     }
   
   
   
     	write_skipstone_config();
	set_mozilla_prefs();       
     	
     	if (close) 
	     	gtk_widget_destroy(config_window->window);
	
     	
     	D_RETURN;
}
