#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <fcntl.h>


typedef struct {
          gchar *url;
          gchar *location;
          GtkWidget *fs;
	  gint type; /* 0 immediate download, 1 from ipc */
	  gboolean is_dir;
}
DownloadData;
        

typedef struct {
     	GtkWidget *dialog;
     	GtkWidget *entry;
     	GtkWidget *location;
	GtkWidget *fs;
}
InsertData;

static gchar *format_bps(gint n);
static gint find_string( gchar *haystack, gchar *needle );
static void select_location(gchar *url, gint type);
static void get_location(GtkWidget *button, DownloadData *data);
static void quit_download(void);
static void progress(GtkWidget *bar, GtkWidget *entry, GtkWidget *size_lbl, GtkWidget *bps_lbl, DownloadData *data);
static void handle_usr1_signal(int sig);
static void set_running(void);
static void check_running(gchar *url);
static void make_clist(void);
static void progress_window(DownloadData *data);
static void destroy_fs(GtkWidget *fs, DownloadData *data);
static void cancel_fs(GtkWidget *button, DownloadData *data);
static void refresh_list(void);  
static void remove_item_from_clist(void);
static void insert_in_clist(void);
static void on_insert_ok(GtkWidget *button, InsertData *idata);
static void on_insert_destroy(GtkWidget *dialog, InsertData *idata);
static void on_insert_cancel(GtkWidget *button, InsertData *idata);
static void on_select_clicked(GtkWidget *button, InsertData *idata);
static void close_fs_from_insert(GtkWidget *button, InsertData *idata);
static void ok_from_insert_fs(GtkWidget *button, InsertData *idata);
static void on_clist_window_destroy(GtkWidget *window);
