/* copyright	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org 	*
 *                                                      *
 *  released under the GPL                              */


#include "skipstone.h"

extern GSList *window_count;
extern gchar *home;

static gboolean skipstone_save_session(gchar *filename);
static gboolean skipstone_load_session(gchar *filename);
static gboolean path_is_dir(gchar *filename);
static void on_load_fileselect_ok(GtkWidget *button, GtkWidget *fs);
static void on_save_fileselect_ok(GtkWidget *button, GtkWidget *fs);
static void on_fileselect_cancel(GtkWidget *button, GtkWidget *fs);

void skipstone_load_a_session(void)
{
     	GtkWidget *fs;
     	D_ENTER;
     	fs = gtk_file_selection_new(_("Choose a session file to load"));
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->ok_button), "clicked",
			   G_CALLBACK(on_load_fileselect_ok), fs);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button), "clicked",
			   G_CALLBACK(on_fileselect_cancel), fs);	

     	gtk_widget_show(fs);
	D_RETURN;
}

void skipstone_save_a_session(void)
{
     	GtkWidget *fs;
     	D_ENTER;
     	fs = gtk_file_selection_new(_("Choose a session file to save to"));
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->ok_button), "clicked",
			   G_CALLBACK(on_save_fileselect_ok), fs);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button), "clicked",
			   G_CALLBACK(on_fileselect_cancel), fs);	
     	gtk_widget_show(fs);
	D_RETURN;
}

static void on_load_fileselect_ok(GtkWidget *button, GtkWidget *fs)
{
     	gboolean result = FALSE;
     	D_ENTER;
	result = skipstone_load_session((gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
     	if (result) gtk_widget_destroy(fs);
	D_RETURN;
}

static void on_save_fileselect_ok(GtkWidget *button, GtkWidget *fs)
{
     	gboolean result = FALSE;
     	D_ENTER;
     	result = skipstone_save_session((gchar *)gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
     	if (result) gtk_widget_destroy(fs);
	D_RETURN;
}

static void on_fileselect_cancel(GtkWidget *button, GtkWidget *fs)
{
     	D_ENTER;
     	gtk_widget_destroy(fs);
	D_RETURN;
}

static gboolean skipstone_save_session(gchar *filename)
{
	GSList *l;
     	FILE *out;
     	D_ENTER;
     	if (!filename || !strcmp("",filename)) {
	     	skipstone_error_dialog(_("Error!"), _("Couldn't save session!"), FALSE);
	     	D_RETURN_ ( FALSE );
	}
     	
     	if (path_is_dir(filename)) {
	     	gchar *error;
	     	error = g_strdup_printf(_("Given path %s is not a file!"),filename);
	     	skipstone_error_dialog(_("Error!"), error, FALSE);
	     	g_free(error);
	     	D_RETURN_ ( FALSE );
	}

     	out = fopen(filename,"w");

     	if (!out) {
	     	gchar *error;
	     	error = g_strdup_printf(_("Couldn't open session  file %s for writing\n"),filename);
		skipstone_error_dialog(_("Error!"), error, FALSE);
	     	g_free(error);
	     	D_RETURN_ ( FALSE );
	}
			
	for (l = window_count; l ; l=l->next) {
	     	SkipStone *skipstone = NULL;
	     	skipstone = (SkipStone *)l->data;
	     	if (skipstone && skipstone->embed != NULL) {
		     	gchar *location = NULL;
		     	location = gtk_moz_embed_get_location(skipstone->embed);
		     	if (location) {
			     fprintf(out,"url=%s\n",location);
			     g_free(location);
			}
		}
	}
     
     	fclose(out);
     	D_RETURN_ (TRUE);
}

static gboolean skipstone_load_session(gchar *filename) 
{
     	FILE *in;
     	gchar *line;
     	D_ENTER;
     	if (!filename || !strcmp("",filename)) {
	     	skipstone_error_dialog(_("Error"), _("Couldn't read session file!"), FALSE);
	     	D_RETURN_ ( FALSE );
	}
     
     	if (path_is_dir(filename)) {
	     	gchar *error;
	     	error = g_strdup_printf(_("Given path %s is not a file!"),filename);
	     	skipstone_error_dialog(_("Error!"), error, FALSE);
	     	g_free(error);
	     	D_RETURN_ ( FALSE );
	}

     	in = fopen(filename,"r");

     
     	if (!in) {
	     	gchar *error;
	     	error = g_strdup_printf(_("Couldn't open session file %s for reading\n"),filename);
		skipstone_error_dialog(_("Error!"), error, FALSE);
	     	g_free(error);
	     	D_RETURN_ ( FALSE );	     	
	}
     
     
     	line = (gchar *) g_malloc (1024);
     	while (fgets(line,1024,in) != NULL) {
	     	line[strlen(line)-1] = '\0';
	     	if (!g_strncasecmp(line,"url=",4)) make_window(line+4);
	}
     	fclose(in);
     	g_free(line);
     	D_RETURN_ ( TRUE );
}


static gboolean path_is_dir(gchar *filename)
{
     	struct stat st;   
     	D_ENTER;
     	if (stat(filename, &st) < 0) D_RETURN_ ( FALSE );
     	if (S_ISDIR(st.st_mode)) D_RETURN_ (TRUE);
     	D_RETURN_ ( FALSE );
}
