/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include <gtk/gtk.h>
#include <sys/types.h>
#include "mozilla-config.h"
#include "gtkmozembed.h"
#include "gtkmozembed_internal.h"
#include "nsIServiceManager.h"
#include "nsIPref.h"
#include "nsIDOMDocument.h"
#include "nsIDocShell.h"
#include "nsIDocShellTreeItem.h"
#include "nsIDocShellTreeOwner.h"
#include "nsIDocumentViewer.h"
#include "nsIWebBrowser.h"
#include "nsIDocument.h"
#include "nsIFile.h"
#include "nsILocalFile.h"
#include "nsCOMPtr.h"
#include "nsIWebNavigation.h"
#include "nsISHistory.h"
#include "nsISHEntry.h"
#include "nsITextServicesDocument.h"
#include "nsIPresShell.h"
#include "nsTextServicesCID.h"
#include "nsIContentViewer.h"
#include "nsIMarkupDocumentViewer.h"
#include "nsIContentViewerFile.h"
#include "nsITextScroll.h"
#include "nsIDOMMouseEvent.h"
#include "nsIDOMEventTarget.h"
#include "nsIDOMHTMLElement.h"
#include "nsIDOMNamedNodeMap.h"
#include "nsIDOMNSHTMLElement.h"  
#include "nsIDOMKeyEvent.h"
#include "nsDirectoryServiceDefs.h"
#include "nsIComponentManager.h"
#include "nsIGlobalHistory.h"
#include "nsIDocShellHistory.h"
#include "nsIURL.h"
#include "nsIDocShellTreeNode.h"
#include "nsString.h"
#include "nsXPIDLString.h"
#include "nsIWebBrowserPersist.h"
#include "nsNetUtil.h"
#include "nsIWebBrowserFind.h"
#include "nsIDOMNSDocument.h"
#include "nsIDOMNSEvent.h"


#include "nsIUnicodeEncoder.h"
#include "nsIUnicodeDecoder.h"
#include "nsIPlatformCharset.h"
#include "nsICharsetConverterManager.h"


#include "nsIChromeRegistry.h"
#include "nsILocaleService.h"


/*#include "PromptService.h"*/
#include "nsGfxCIID.h"
#include "nsIContentViewer.h"
#include "nsIContentViewerFile.h"
#include "nsIPrintOptions.h"
#include "nsIPrintSettings.h"
#include "nsIWebBrowserPrint.h"
#include "skipstone-print.h"
#include "debug.h"

#define ALT_KEY 1
#define CTRL_KEY 2
#define SHIFT_KEY 4
#define META_KEY 8

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256

static NS_DEFINE_CID(kCTextServicesDocumentCID, NS_TEXTSERVICESDOCUMENT_CID);
static NS_DEFINE_CID(kPrefCID, NS_PREF_CID);
static NS_DEFINE_CID(kStandardURLCID, NS_STANDARDURL_CID);
static NS_DEFINE_CID(kPrintOptionsCID, NS_PRINTOPTIONS_CID);
static NS_DEFINE_CID(kPlatformCharsetCID, NS_PLATFORMCHARSET_CID);

static nsIDocShell *mozilla_get_docshell (GtkMozEmbed *b);
static nsIPresShell *mozilla_get_presShell(nsIDocShell *docShell);
static nsIDOMDocument *mozilla_get_dom_document(nsIPresShell *presShell);
static gchar *mozilla_get_attribute (nsIDOMNode *node, gchar *attribute);
static nsresult getUILang (nsAString& aUILang);
    
extern "C"
{
gchar *mozilla_unicode_to_locale (const PRUnichar *uniStr);
PRUnichar *mozilla_locale_to_unicode (const gchar *locStr);
}

#define PREF_ID NS_PREF_CONTRACTID


extern "C" gboolean
mozilla_print (GtkMozEmbed *m, PrintInfo *info)
{

        D_ENTER;
        const static char *PaperSizeNames[] = { "Letter","Legal","Executive","A4" };	
     	nsresult result = FALSE;

     
     	nsCOMPtr<nsIPrintSettings> settings;
     	nsCOMPtr<nsIWebBrowser> mWebBrowser;     

        gtk_moz_embed_get_nsIWebBrowser (m, getter_AddRefs(mWebBrowser));
     	if (!mWebBrowser) D_RETURN_ (FALSE);
     
	nsCOMPtr<nsIWebBrowserPrint> print(do_GetInterface(mWebBrowser, &result));
     	if (NS_FAILED(result)) D_RETURN_ (FALSE);

     	result = print->GetGlobalPrintSettings(getter_AddRefs(settings));
     	if (NS_FAILED(result)) D_RETURN_ ( NS_ERROR_FAILURE );
	
        
	switch  (info->Pages)
	{
	 case 0:
	     	break;
	 case 2:
	     	settings->SetPrintRange (nsIPrintSettings::kRangeSpecifiedPageRange);
		settings->SetStartPageRange (info->From);
		settings->SetEndPageRange (info->To);
	     	break;
	 case 1:
	     	settings->SetPrintRange (nsIPrintSettings::kRangeSelection);
	     	break;
	}
        char *printer = g_strdup("PostScript/default");
        nsAutoString mPname;
        mPname.AssignWithConversion(printer);
        settings->SetPrinterName(ToNewUnicode(mPname));
	settings->SetMarginTop (info->TopMargin);
	settings->SetMarginBottom (info->BottomMargin);
	settings->SetMarginLeft (info->LeftMargin);
	settings->SetMarginRight (info->RightMargin);
	settings->SetPrintInColor(info->Color);
     
        nsAutoString mPrintToFile, mPrinter, mPaperName;
        mPrintToFile.AssignWithConversion (info->File);
        mPrinter.AssignWithConversion (info->Printer);



	settings->SetToFileName (ToNewUnicode(mPrintToFile));
	settings->SetPrintCommand (ToNewUnicode(mPrinter));


        settings->SetPrintToFile (info->PrintToFile);

	settings->SetPrintReversed (info->Reversed);
        settings->SetPaperSize (nsIPrintSettings::kPaperSizeNativeData);
        int paperTypeIndex = (info->Paper >= 0 ||  info->Paper < 4) ? info->Paper : 0;

        mPaperName.AssignWithConversion (PaperSizeNames[paperTypeIndex]);

        settings->SetPaperName (ToNewUnicode(mPaperName));

	settings->SetPrintSilent (PR_TRUE);


     	result = print->Print(settings, nsnull);
        g_free(printer);
	D_RETURN_ ( NS_SUCCEEDED (result) ? TRUE : FALSE );     
}


extern "C" void
mozilla_save_image(GtkMozEmbed *b,gchar *location, gchar *FullPath)
{
     	D_ENTER;
     	nsresult rv = NS_OK;
     	if (strlen(location) == 0 || !location) D_RETURN;
     	nsCOMPtr<nsIURI> linkURI;
     	rv = NS_NewURI(getter_AddRefs(linkURI), location);
     	if (NS_FAILED(rv)) D_RETURN;
     	nsIWebBrowser *wb = nsnull;
	gtk_moz_embed_get_nsIWebBrowser(b,&wb);
     	nsCOMPtr<nsIWebBrowserPersist> persist(do_QueryInterface(wb));
     	if (persist)  {
	     	nsCOMPtr<nsILocalFile> file;
	        nsAutoString s; s.AssignWithConversion(FullPath);
	        NS_NewLocalFile(s, PR_TRUE, getter_AddRefs(file));
	     	if (!file) D_RETURN;
		persist->SaveURI(linkURI, nsnull, nsnull, nsnull, nsnull, file);
	}
	D_RETURN;
}

extern "C" gboolean
mozilla_preference_set (const char *preference_name, const char *new_value)
{
     	D_ENTER;
	g_return_val_if_fail (preference_name != NULL, FALSE);
	g_return_val_if_fail (new_value != NULL, FALSE);

	nsCOMPtr<nsIPref> pref = do_CreateInstance(PREF_ID);
	
	if (pref)
	{
		nsresult rv = pref->SetCharPref (preference_name, new_value);
		D_RETURN_ ( NS_SUCCEEDED (rv) ? TRUE : FALSE );
	}

	D_RETURN_ ( FALSE );
}

extern "C" gboolean
mozilla_preference_set_boolean (const char	*preference_name, gboolean	new_boolean_value)
{
     	D_ENTER;
	g_return_val_if_fail (preference_name != NULL, FALSE);

	nsCOMPtr<nsIPref> pref = do_CreateInstance(PREF_ID);
	
	if (pref)
	{
		nsresult rv = pref->SetBoolPref (preference_name,  new_boolean_value ? PR_TRUE : PR_FALSE);
		D_RETURN_ ( NS_SUCCEEDED (rv) ? TRUE : FALSE );
	}

	D_RETURN_ ( FALSE );
}

extern "C" gboolean
mozilla_preference_set_int (const char	*preference_name,    gint  new_int_value)
{
     	D_ENTER;
	g_return_val_if_fail (preference_name != NULL, FALSE);

	nsCOMPtr<nsIPref> pref = do_CreateInstance(PREF_ID);
	
	if (pref)
	{
		nsresult rv = pref->SetIntPref (preference_name, new_int_value);
	     	D_RETURN_ ( NS_SUCCEEDED (rv) ? TRUE : FALSE );
	}

	D_RETURN_ ( FALSE );
}

extern "C" gint
mozilla_get_button (gpointer dom_event)
{
     D_ENTER;
     PRUint16 button;
     if (GPOINTER_TO_INT(dom_event) == 1 || GPOINTER_TO_INT(dom_event) == 2 || GPOINTER_TO_INT(dom_event) == 3) {
	  D_RETURN_ (  GPOINTER_TO_INT(dom_event) );
     }		  
     ((nsIDOMMouseEvent *)dom_event)->GetButton(&button);             
     D_RETURN_ (  button );
}

extern "C" gint
mozilla_get_key(gpointer dom_event, int *modifier)
{
     	D_ENTER;
     
     	PRUint32 key;
        nsIDOMKeyEvent *keyevent = ((nsIDOMKeyEvent *)dom_event);
     	PRBool mod_key;
     	*modifier = 0;
     	keyevent->GetCharCode(&key);
        
     	if (key==0) keyevent->GetKeyCode(&key);
        keyevent->GetAltKey(&mod_key);
     	
     	if (mod_key) *modifier |= ALT_KEY;
     	keyevent->GetShiftKey(&mod_key);
        
     	if (mod_key) *modifier |= SHIFT_KEY;  
     	keyevent->GetMetaKey(&mod_key);
     	
     	if (mod_key) *modifier |= META_KEY;
     	
     	keyevent->GetCtrlKey(&mod_key);
     	if (mod_key) *modifier |= CTRL_KEY;

     	D_RETURN_ (  key );
}
     
extern "C" gboolean
mozilla_save(GtkMozEmbed *b, gchar *file_name, gint all)
{
     	D_ENTER;
     	nsIWebBrowser *wb = nsnull;
     	gint i = 0;
     	gchar *relative_path = NULL;
     	gtk_moz_embed_get_nsIWebBrowser(b,&wb);
     	if (!wb) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIDocShell> docShell = mozilla_get_docshell(b);	
     	if (!docShell) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIPresShell> presShell = mozilla_get_presShell(docShell);
     	if (!presShell) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIDOMDocument> domDoc = mozilla_get_dom_document(presShell);
     	if (!domDoc) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIWebBrowserPersist> persist(do_QueryInterface(wb));
     	if (persist) {
	     	nsCOMPtr<nsILocalFile> file;
	     	nsCOMPtr<nsILocalFile> relative = nsnull;
	     	if (all) {
		     	relative_path = g_strdup(file_name);
		     	for (i=strlen(relative_path)-1 ; i >= 0; --i)
		       		if (relative_path[i] == '/') {
				     	relative_path[i] = '\0';
				     	break;
				}
		        nsAutoString s; s.AssignWithConversion(relative_path);
		     	NS_NewLocalFile(s, PR_TRUE, getter_AddRefs(relative));
		       
		} 
	        nsAutoString s; s.AssignWithConversion(file_name);
	     	NS_NewLocalFile(s,PR_TRUE,getter_AddRefs(file));

	     	if (file) persist->SaveDocument(domDoc,file,relative, nsnull, 0, 0);

	     	if (all) g_free(relative_path);
	     	D_RETURN_ ( TRUE );
	}
     	D_RETURN_ ( FALSE );
}

extern "C" gboolean
mozilla_find(GtkMozEmbed *b, const char *exp, PRBool IgnoreCase,
		PRBool SearchBackWards, PRBool DoWrapFind,
		PRBool SearchEntireWord, PRBool SearchInFrames,
		PRBool DidFind)
{
	PRUnichar *search_string;

	D_ENTER;
	g_return_val_if_fail(b != NULL, FALSE);
	nsIWebBrowser *wb = nsnull;
	gtk_moz_embed_get_nsIWebBrowser(b, &wb);
	nsCOMPtr<nsIWebBrowserFind> finder(do_GetInterface(wb));
	search_string = mozilla_locale_to_unicode(exp);
	finder->SetSearchString(search_string);
	finder->SetFindBackwards(SearchBackWards);
	finder->SetWrapFind(DoWrapFind);
	finder->SetEntireWord(SearchEntireWord);
	finder->SetSearchFrames(SearchInFrames);
	finder->SetMatchCase(IgnoreCase);
	finder->FindNext(&DidFind);
	g_free(search_string);

	D_RETURN_ ( DidFind );
}


static nsIDocShell *mozilla_get_docshell(GtkMozEmbed *b)
{
     	D_ENTER;
     	nsresult result ;	

	/* get nsIBrowser */
	nsIWebBrowser *wb = nsnull;
	gtk_moz_embed_get_nsIWebBrowser(b,&wb);
	nsCOMPtr<nsIDocShell> docShell;

        nsCOMPtr<nsIDocShellTreeItem> browserAsItem;
	browserAsItem = do_QueryInterface(wb);
     	if (!browserAsItem) D_RETURN_ (  NULL );
	// get the tree owner for that item
	nsCOMPtr<nsIDocShellTreeOwner> treeOwner;
	result = browserAsItem->GetTreeOwner(getter_AddRefs(treeOwner));
     	if (!NS_SUCCEEDED(result) || !treeOwner) D_RETURN_ (  NULL );
	// get the primary content shell as an item
	nsCOMPtr<nsIDocShellTreeItem> contentItem;
	result = treeOwner->GetPrimaryContentShell(getter_AddRefs(contentItem));
     	if (!NS_SUCCEEDED(result) || !contentItem) D_RETURN_ ( NULL );
	// QI that back to a docshell
	docShell = do_QueryInterface(contentItem);

     	D_RETURN_ ( docShell );
}

static nsIPresShell *mozilla_get_presShell(nsIDocShell *docShell)
{
     	D_ENTER;
     	nsresult result;
     
	nsCOMPtr<nsIPresShell> presShell;
	result = docShell->GetPresShell(getter_AddRefs(presShell));
     	if (!NS_SUCCEEDED(result) || !presShell) D_RETURN_ (  NULL );
     	D_RETURN_ ( presShell );
}

static nsIDOMDocument *mozilla_get_dom_document(nsIPresShell *presShell)
{
     	D_ENTER;
	nsCOMPtr<nsIDocument> document;
	presShell->GetDocument(getter_AddRefs(document));
	
	/* get nsIDOMDocument */
	nsCOMPtr<nsIDOMDocument> domDoc = do_QueryInterface(document);
     	if (!domDoc) D_RETURN_ ( NULL );
     	D_RETURN_ (  domDoc );
}
	
extern "C" glong
mozilla_get_context_menu_type(GtkMozEmbed *b, gpointer event,  gchar **img,  gchar **link, gchar **linktext)
{
       	D_ENTER;
	nsresult result;
	*img = *link = NULL;

	nsIDOMMouseEvent *aMouseEvent =  (nsIDOMMouseEvent*)event;
             
     	nsCOMPtr<nsIDOMEventTarget> OriginalTarget;

     	nsCOMPtr<nsIDOMNSEvent> aEvent = do_QueryInterface(aMouseEvent);
     	if (!aEvent) D_RETURN_(CONTEXT_NONE);	
     	result = aEvent->GetOriginalTarget(getter_AddRefs(OriginalTarget));

     	if (NS_FAILED(result) || !OriginalTarget) D_RETURN_ (  CONTEXT_NONE );
             
     	nsCOMPtr<nsIDOMNode> OriginalNode = do_QueryInterface(OriginalTarget);
     	if (!OriginalNode) D_RETURN_ ( CONTEXT_NONE );
             
     	nsString nodename;
     	OriginalNode->GetNodeName(nodename);
     
     	if (nodename.EqualsWithConversion ("xul:thumb") ||
	    nodename.EqualsWithConversion ("xul:slider"))
       		D_RETURN_ (  CONTEXT_NONE );

     	nsCOMPtr<nsIDOMEventTarget> EventTarget;
     	result = aMouseEvent->GetTarget(getter_AddRefs(EventTarget));
     	if (NS_FAILED(result) || !EventTarget) D_RETURN_ (  CONTEXT_NONE );
             
	nsCOMPtr<nsIDOMNode> node = do_QueryInterface(EventTarget);
	if (!node)    D_RETURN_ (  CONTEXT_NONE );
     
     	nsCOMPtr<nsIDOMDocument> domDoc;
     	result = node->GetOwnerDocument(getter_AddRefs(domDoc));
     	if (!NS_SUCCEEDED (result) || !domDoc) D_RETURN_ (  CONTEXT_NONE );
     
     	nsCOMPtr<nsIDocument> doc = do_QueryInterface(domDoc);
     	if(!doc) D_RETURN_ (  CONTEXT_NONE );
	
     	nsCOMPtr<nsIDOMNSDocument> nsDoc = do_QueryInterface(domDoc);
     	if (!nsDoc) D_RETURN_ (  CONTEXT_NONE );
     
     	nsIURI *baseURI;
#ifndef CVS_MOZILLA
     	baseURI = doc->GetBaseURL();
#else
        baseURI = doc->GetBaseURI ();
#endif     
     	if (!baseURI) D_RETURN_ (  CONTEXT_NONE );

     	nsString mime;
     	nsDoc->GetContentType(mime);
     	if (mime.EqualsWithConversion ("text/xul"))  D_RETURN_ (  CONTEXT_NONE );

	PRUint32 flags = CONTEXT_NONE;
	nsCOMPtr<nsIDOMHTMLElement> element;
	
     	do {
		PRUint16 type;
		node->GetNodeType(&type);

		element = do_QueryInterface(node);
		if (element)
		{
			nsAutoString tag;
			element->GetTagName(tag);

			if (tag.EqualsWithConversion("input", PR_TRUE))
			{
				flags |= CONTEXT_INPUT;
			}
			else if (tag.EqualsWithConversion("img", PR_TRUE))
			{
				flags |= CONTEXT_IMAGE;

				char *src = mozilla_get_attribute (node, "src");
				if (!src)  D_RETURN_ (  CONTEXT_NONE );

			     	nsAutoString srca;
			     	srca.AssignWithConversion(src);
			     
			     	nsCString srcc,imgc;
			     	srcc.AssignWithConversion(srca);
			   
			     	result = baseURI->Resolve(srcc, imgc);
			     	g_free(src);
			   

			     	*img = ToNewCString(imgc);
			   
			     	if (!img) D_RETURN_ (CONTEXT_NONE);
			
		   
			}
		   
			else
			     {
				
				flags |= CONTEXT_OTHER;
			}

			nsCOMPtr<nsIDOMNamedNodeMap> attributes;
			node->GetAttributes(getter_AddRefs(attributes));
			if (attributes)
			{
				nsCOMPtr<nsIDOMNode> hrefNode;
				nsAutoString href; 
			     	href.AssignWithConversion("href");
				attributes->GetNamedItem(href, getter_AddRefs(hrefNode));
				if (hrefNode)
				{
					flags |= CONTEXT_LINK;
				     	nsAutoString linkhtml;
				     	nsCOMPtr<nsIDOMNSHTMLElement> nsElement;
				     	
				     	nsElement = do_QueryInterface (element);				      
				     	
				     	if (nsElement)
				       	{
						result = nsElement->GetInnerHTML(linkhtml);
					     	if (NS_SUCCEEDED(result) && ToNewCString(linkhtml)) 
					       		*linktext = g_strdup(ToNewCString(linkhtml));
					}

					char *href =  mozilla_get_attribute (node, "href");
					if (!href)   D_RETURN_ (  CONTEXT_NONE );

				     	nsAutoString hrefa;
				     	hrefa.AssignWithConversion(href);
				     
				     	nsCString hrefc,linkc;
				     	hrefc.AssignWithConversion(hrefa);

				     	result = baseURI->Resolve(hrefc,linkc);
				     	g_free(href);

					*link = ToNewCString(linkc);
				     
					if (!link)  D_RETURN_ (  CONTEXT_NONE );

					break;
				}
			}
		}
		nsCOMPtr<nsIDOMNode> parentNode;
		node->GetParentNode(getter_AddRefs(parentNode));
		
		if (!parentNode)
		{
			node = nsnull;
			flags |= CONTEXT_DOCUMENT;
			break;
		}
		node = parentNode;
	} while (node);

       	D_RETURN_ (  flags );
  
}

/* Nautilus CREDITS here */
static gchar *
mozilla_get_attribute (nsIDOMNode *node, gchar *attribute)
{
	D_ENTER;
     	nsresult result;
	
	nsCOMPtr<nsIDOMNamedNodeMap> attributes;
	result = node->GetAttributes(getter_AddRefs (attributes));
	if (!NS_SUCCEEDED (result) || !attributes) D_RETURN_ ( NULL );

	nsAutoString attr; 

	attr.AssignWithConversion (attribute);
                                        
	nsCOMPtr<nsIDOMNode> attrNode;
	result = attributes->GetNamedItem (attr, getter_AddRefs (attrNode));
	if (!NS_SUCCEEDED (result) || !attrNode)  D_RETURN_ ( NULL );

	nsAutoString nodeValue;
			
	result = attrNode->GetNodeValue (nodeValue);
	if (!NS_SUCCEEDED (result))  D_RETURN_ ( NULL );
                                                
	char *cstr = ToNewCString(nodeValue);
	char *lifeSucks = g_strdup (cstr);
			
	nsMemory::Free (cstr);
	
	D_RETURN_ ( lifeSucks );
}


extern "C" gboolean
mozilla_init_prompt_service(void)
{
     	D_ENTER;
/*     
	nsresult rv  = NS_OK;
	# define NS_PROMPTSERVICE_CID \
	{0xa2112d6a, 0x0e28, 0x421f, {0xb4, 0x6a, 0x25, 0xc0, 0xb3, 0x8, 0xcb, 0xd0}}
     	static NS_DEFINE_CID(kPromptServiceCID, NS_PROMPTSERVICE_CID);
     
     	nsCOMPtr<nsIFactory> promptFactory;
     	rv = NS_NewPromptServiceFactory(getter_AddRefs(promptFactory));
     	if (NS_FAILED(rv)) D_RETURN_( FALSE );
     	rv = nsComponentManager::RegisterFactory(kPromptServiceCID,
						 "Prompt Service",
						 "@mozilla.org/embedcomp/prompt-service;1",
						 promptFactory,
						 PR_TRUE); // replace existing


     	D_RETURN_ (  NS_SUCCEEDED(rv) ? TRUE: FALSE );
 */
     D_RETURN_(TRUE);
}

extern "C" 
gboolean mozilla_set_offline (gboolean offline)
{
     	D_ENTER;
	nsresult result;     	
     	nsCOMPtr<nsIIOService> io = do_GetService(NS_IOSERVICE_CONTRACTID, &result);
     	if (NS_FAILED(result)) D_RETURN_ (  NS_ERROR_FAILURE );
     	result = io->SetOffline(offline);
     	D_RETURN_ ( NS_SUCCEEDED (result) ? TRUE : FALSE );
}

extern "C" 
gboolean mozilla_force_charset(GtkMozEmbed *aEmbed, gchar *aCharSet)
{

     	D_ENTER;
     	nsresult result;
     	nsCOMPtr<nsIDocShell> DocShell;
     	DocShell = mozilla_get_docshell(aEmbed);
     	if (!DocShell) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIContentViewer> contentViewer;
     	result = DocShell->GetContentViewer (getter_AddRefs(contentViewer));
     	if (!NS_SUCCEEDED (result) || !contentViewer) D_RETURN_ ( FALSE );
     	nsCOMPtr<nsIMarkupDocumentViewer> mdv = do_QueryInterface(contentViewer,&result);
	if (NS_FAILED(result) || !mdv) D_RETURN_ ( FALSE );
       	nsAutoString mCharset;
        mCharset.AssignWithConversion (aCharSet);
        result = mdv->SetForceCharacterSet(NS_LossyConvertUTF16toASCII(ToNewUnicode(mCharset)));
     	D_RETURN_ ( NS_SUCCEEDED(result) ? TRUE : FALSE );
}

     
/**
 * mozilla_get_document_title: get the document title in a locale specific
 * NULL terminated C string, using the private UniCode interface.
 */
extern "C" gchar * 
mozilla_get_document_title (GtkMozEmbed *embed)
{
      PRUnichar *unicode_title;
      gchar *title;

      /* get the title in unicode */
      unicode_title = gtk_moz_embed_get_title_unichar (embed);

      /* attempt conversion */
      title = mozilla_unicode_to_locale (unicode_title);

      /* free unicode version */
      g_free (unicode_title);

      /* return it */
      D_RETURN_( title );
}

/**
 * mozilla_unicode_to_locale: Encodes unicode string to something
 * valid for the current locale (which can then be used in GTK+ labels).
 * @uniStr: The unicode string to encode
 */
extern "C" gchar *
mozilla_unicode_to_locale (const PRUnichar *uniStr)
{


        if (uniStr == NULL)
        {
                D_RETURN_ ( NULL );
        }

	nsAutoString autoStr ( uniStr );

#ifdef MOZ_WIDGET_GTK
	gchar* locStr = ToNewCString(autoStr);
#endif

#ifdef MOZ_WIDGET_GTK2
	gchar* locStr = ToNewUTF8String(autoStr);
#endif

	D_RETURN_ ( locStr );
}

/**
 * mozilla_locale_to_unicode: Decodes a string encoded for the current
 * locale into unicode. Used for getting text entered in a GTK+ entry
 * into a form which mozilla can use.
 * @locStr: The unicode string to encode
 */
extern "C" PRUnichar *mozilla_locale_to_unicode (const gchar *locStr)
{

        if (locStr == NULL)
        {
                D_RETURN_ ( NULL );
        }
	nsAutoString autoStr;
	autoStr.AssignWithConversion (locStr);       
	PRUnichar *uniStr = ToNewUnicode(autoStr);
	D_RETURN_ ( uniStr );
}


extern "C" gboolean
mozilla_save_prefs (void)
{
        nsCOMPtr<nsIPrefService> prefService = 
                                do_GetService (PREF_ID);
        g_return_val_if_fail (prefService != nsnull, FALSE);

        nsresult rv = prefService->SavePrefFile (nsnull);
        return NS_SUCCEEDED (rv) ? TRUE : FALSE;
}

/* setting native scrollbar - credits galeon / epiphany with some changes by me*/

static nsresult
getUILang (nsAString& aUILang)
{
	nsresult result;

	nsCOMPtr<nsILocaleService> localeService = do_GetService (NS_LOCALESERVICE_CONTRACTID, &result);
	if (NS_FAILED (result) || !localeService)
	{
		g_warning ("Could not get locale service!\n");
		D_RETURN_( NS_ERROR_FAILURE );
	}


	result = localeService->GetLocaleComponentForUserAgent (aUILang);


	if (NS_FAILED (result))
	{
		g_warning ("Could not determine locale!\n");
		D_RETURN_( NS_ERROR_FAILURE );
	}

	D_RETURN_(NS_OK);
}

extern "C" gboolean
mozilla_init_chrome (void)
{
	nsresult result;
	nsAutoString uiLang;

	nsCOMPtr<nsIXULChromeRegistry> chromeRegistry = do_GetService (NS_CHROMEREGISTRY_CONTRACTID);
	NS_ENSURE_TRUE (chromeRegistry, NS_ERROR_FAILURE);

	// Set skin to 'classic' so we get native scrollbars.
	result = chromeRegistry->SelectSkin (NS_LITERAL_CSTRING("classic/1.0"), PR_FALSE);
	NS_ENSURE_SUCCESS (result, NS_ERROR_FAILURE);

	// set locale
	result = chromeRegistry->SetRuntimeProvider(PR_TRUE);
	NS_ENSURE_SUCCESS (result, NS_ERROR_FAILURE);

	result = getUILang(uiLang);
	NS_ENSURE_SUCCESS (result, NS_ERROR_FAILURE);

	D_RETURN_ ( chromeRegistry->SelectLocale (NS_ConvertUCS2toUTF8(uiLang), PR_FALSE) );
}
