/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"

#define ALT 1
#define CTRL 2
#define N_KEY 110
#define B_KEY 98
#define D_KEY 100
#define F_KEY 102
#define R_KEY 114
#define S_KEY 115
#define U_KEY 117
#define O_KEY 111
#define P_KEY 112
#define W_KEY 119
#define X_KEY 120
#define H_KEY 104
#define L_KEY 108
#define I_KEY 105
#define PLUS_KEY 61
#define MINUS_KEY 45
#define ESC_KEY 27

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256


extern GSList *window_count;
extern ConfigData config;
extern GList *combo_urls;
extern GtkWidget *main_notebook;
extern GtkWidget *main_window;
extern GoMenu *notebook_go_menu;
extern GtkStyle*loading_style;

static void retab(SkipStone *skipstone);
static gchar *format_bps(gint n);

static void retab(SkipStone *skipstone)
{
     	gchar *title;
	D_ENTER;
     	g_signal_handlers_destroy(GTK_OBJECT(skipstone->window));
     	title = GTK_WINDOW(skipstone->window)->title;

     	if (title)
     		skipstone->notebook_label = gtk_label_new(title);
     	else
       		skipstone->notebook_label = gtk_label_new("SkipStone -");
     	
     	skipstone->is_notebook = 1;

     	g_object_ref(G_OBJECT(skipstone->vbox));
	gtk_container_remove(GTK_CONTAINER(skipstone->window), skipstone->vbox);
     	
     	if (skipstone->menuhandlebox && GTK_IS_WIDGET(skipstone->menuhandlebox)) gtk_widget_destroy(skipstone->menuhandlebox);
     	if (skipstone->bmarkhandlebox && GTK_IS_WIDGET(skipstone->bmarkhandlebox)) gtk_widget_destroy(skipstone->bmarkhandlebox);
	
     	skipstone->menuhandlebox = NULL;
     	skipstone->bmarkhandlebox = NULL;
     
     	if (skipstone->bookmark_toolbar_widgets) {
	     	g_slist_free(skipstone->bookmark_toolbar_widgets);
	     	skipstone->bookmark_toolbar_widgets = NULL;
	}      
     	
     	if (skipstone->go_menu && skipstone->go_menu->items) {
	     	g_slist_free(skipstone->go_menu->items); 
	     	g_free(skipstone->go_menu);
	}
     	skipstone_append_tab(skipstone);
     	gtk_widget_destroy(skipstone->window);
	D_RETURN;
}

void start_load(GtkMozEmbed *embed,SkipStone *skipstone) 
{
        gchar *message;
	D_ENTER;
     	
     	if (skipstone->stop) {
	     	gtk_widget_set_sensitive(skipstone->stop, TRUE);
	}
     	
     	if (skipstone->reload) {
     		gtk_widget_set_sensitive(skipstone->reload, FALSE);
	}

	if (skipstone->is_notebook && config.red_while_loading) 
		gtk_widget_set_style(GTK_WIDGET(skipstone->notebook_label), loading_style);

     	g_return_if_fail(skipstone->progressbar != NULL);
     	gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar), 1);
     	gtk_progress_configure(GTK_PROGRESS(skipstone->progressbar), 0, 0, 100);
     	skipstone->timer = g_timeout_add (100, (GSourceFunc)progress, skipstone);
     	skipstone->is_loading = TRUE;
	
	message = g_strdup(_("Loading ..."));
	gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
			  skipstone->sbar_status_msg_id);
	gtk_statusbar_push(GTK_STATUSBAR(skipstone->statusbar),
			   skipstone->sbar_status_msg_id,
			   message);
	g_free(message);
	
	D_RETURN;
}



void link_message(GtkMozEmbed *embed, SkipStone *skipstone)
{
	gchar *message;
	D_ENTER;
	message = gtk_moz_embed_get_link_message(skipstone->embed);
     	
     	gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
			  skipstone->sbar_temp_msg_id);
	if (!message) D_RETURN;
	if (strlen(message) > 0) {
	  gtk_statusbar_push(GTK_STATUSBAR(skipstone->statusbar),
			     skipstone->sbar_temp_msg_id,
			     message);
	}
	g_free(message);
	D_RETURN;
}


void title_changed(GtkMozEmbed *embed, SkipStone *skipstone)
{
	gchar *doc_title=NULL;
	GSList *l;
     	D_ENTER;
     	if (skipstone->title) g_free(skipstone->title);
     	skipstone->title = NULL;
//     	skipstone->title = gtk_moz_embed_get_title(skipstone->embed);
        skipstone->title = mozilla_get_document_title(skipstone->embed);
     	if (!skipstone->title || !strcmp(skipstone->title,"")) skipstone->title = g_strdup(_("Untitled Document"));
		
     	if (skipstone->is_notebook) {
	     	
	     	if (get_current_browser_from_notebook() == skipstone) {
		     gchar *t = g_strdup_printf(_("SkipStone - %s"), skipstone->title);
		     gtk_window_set_title(GTK_WINDOW(main_window), t);
		     g_free(t);

		}
	     	gtk_notebook_set_menu_label_text(GTK_NOTEBOOK(main_notebook), skipstone->vbox, skipstone->title);
	     	
	     	if (config.shorten_tabs == 1 && strlen(skipstone->title) > config.tab_text_length) {
		     	gchar *label_title = g_strndup(skipstone->title, config.tab_text_length);
		     	gtk_label_set_text(GTK_LABEL(skipstone->notebook_label), label_title);
			g_free(label_title);
		} else {
		     	gtk_label_set_text(GTK_LABEL(skipstone->notebook_label), skipstone->title);
		}

	     	if (config.shorten_tabs == 2)
	       		gtk_widget_set_usize(GTK_WIDGET(skipstone->notebook_label), config.tab_text_length, -2);
	     	else
	       		gtk_widget_set_usize(GTK_WIDGET(skipstone->notebook_label), -1, -2);
	     
		gtk_widget_queue_resize(skipstone->notebook_label->parent);
		update_navigation_buttons(skipstone);	     	
	     	D_RETURN;
	}
     	doc_title = g_strdup_printf(_("SkipStone - %s"), skipstone->title);
     	gtk_window_set_title(GTK_WINDOW(skipstone->window), doc_title);
     	g_free(doc_title);

	for (l = window_count; l ; l = l->next) {
		SkipStone *skipstone = l->data;
		if (!skipstone->is_notebook && skipstone->menubar)
	     		make_window_menu(skipstone);
	}
     	update_navigation_buttons(skipstone);
	D_RETURN;
}


void url_clicked(GtkMozEmbed *embed, SkipStone *skipstone)
{
	gchar *location;
	D_ENTER;
     	g_return_if_fail (skipstone->embed !=NULL);

	location = gtk_moz_embed_get_location(skipstone->embed);
     	if (location && strcmp(location, "about:blank")) gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry),location);
     	g_free(location);
	D_RETURN;
}



void stop_load(GtkMozEmbed *embed,SkipStone *skipstone)
{
	gchar *location;
	D_ENTER;
	g_return_if_fail(skipstone->embed !=NULL);
     	g_return_if_fail(skipstone->progressbar != NULL);
        
        if (!skipstone->initilized) {
	   gchar *first_url = NULL;
	   skipstone->initilized = 1;
	   first_url = g_object_get_data(G_OBJECT(skipstone->embed), "first_url");
	   if (first_url) { 
		_skipstone_load_url(skipstone, first_url);
		g_free(first_url);
		g_object_set_data(G_OBJECT(skipstone->embed), "first_url", NULL);
		D_RETURN;
	   } else {
		gtk_widget_grab_focus(GTK_BIN(skipstone->embed)->child);
	   }
	     
	}
   
     	location = gtk_moz_embed_get_location(skipstone->embed);

	if (location) add_to_history(location);
	
	if (skipstone->is_notebook) {
	  go_menu_append(notebook_go_menu, location, skipstone);
	      if (config.red_while_loading)
	       gtk_widget_set_rc_style(GTK_WIDGET(skipstone->notebook_label));	     
	} else
	  go_menu_append(skipstone->go_menu, location, skipstone);
	
     	if (skipstone->stop) {
     		gtk_widget_set_sensitive(skipstone->stop, FALSE);
	}
     	
	if (skipstone->reload) {
     		gtk_widget_set_sensitive(skipstone->reload, TRUE);
	}
     
	if (skipstone->timer) {
	     	gtk_timeout_remove(skipstone->timer);
	     	skipstone->timer = 0;
	}
     	gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar), FALSE);	
	gtk_progress_set_format_string(GTK_PROGRESS(skipstone->progressbar), ""); 
     	if (GTK_IS_PROGRESS(skipstone->progressbar)) gtk_progress_set_value(GTK_PROGRESS(skipstone->progressbar), 0);
	skipstone->is_loading = FALSE;
     	skipstone->prev_bytes=0;
     	skipstone->prev_seconds=0;
     	skipstone->prev_useconds=0;
	gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
			  skipstone->sbar_temp_msg_id);
     	if (location) g_free(location);
	D_RETURN;
}

void handle_progress(GtkMozEmbed *embed, const char *aURI, gint cur, gint max, SkipStone *skipstone)
{
	/* Future, maybe download time remaining? */
	gchar *msg = NULL, *buf = NULL;
     	gint t, bps, p;
     	struct timeval tv;
     	struct timezone tz;
     	D_ENTER;
	if (max < 1)   D_RETURN;	/* We can't draw anything useful */
	if (cur > max) D_RETURN;;
	
     	g_return_if_fail(skipstone->progressbar != NULL);
     	g_return_if_fail(GTK_IS_PROGRESS(skipstone->progressbar));
     
     	gtk_progress_set_format_string(GTK_PROGRESS(skipstone->progressbar), "%p%%");

	if (skipstone->timer) {
	     	gtk_timeout_remove(skipstone->timer);
	     	skipstone->timer = 0;
	}
     	
     	gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar), FALSE);
     	gtk_progress_configure(GTK_PROGRESS(skipstone->progressbar), cur, 0, max);

     	p = gtk_progress_get_current_percentage(GTK_PROGRESS(skipstone->progressbar)) * 100;

	if (p < 7) {
	     gettimeofday(&tv,&tz);
	     skipstone->prev_seconds = tv.tv_sec;
	     skipstone->prev_useconds = tv.tv_usec;
	     skipstone->prev_bytes = cur;
	}
     	if (p >=8) {
	     gettimeofday(&tv,&tz);
	     t = 1000000 * (tv.tv_sec - skipstone->prev_seconds);
	     t += tv.tv_usec - skipstone->prev_useconds;
	     t /= 10000;
	     if (t > 0 && skipstone->prev_bytes >= 0) {
		  bps = 100 * (cur - skipstone->prev_bytes) / t;
		  buf = format_bps(bps);

	     }
/*	     skipstone->prev_bytes = cur;
	     skipstone->prev_seconds = tv.tv_sec;
	     skipstone->prev_useconds = tv.tv_usec;*/
	}
     	if (buf == NULL) {
	     	msg = g_strdup_printf("%s (%dKB of %dKB)", aURI, cur/1024, max/1024);
	} else {
	     	msg = g_strdup_printf("%s (%dKB of %dKB) at (%s)", aURI, cur/1024, max/1024, buf);
	     	g_free(buf);
	}

     	gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
			  skipstone->sbar_temp_msg_id);
     	gtk_statusbar_push(GTK_STATUSBAR(skipstone->statusbar),
			   skipstone->sbar_temp_msg_id,
			   msg);
     	g_free(msg);
	D_RETURN;
}

gint handle_open_uri(GtkMozEmbed *embed,const gchar *uri,SkipStone *skipstone)
{
       	gboolean status;
     	D_ENTER;
     	status = open_uri (uri);
     	D_RETURN_(status);
}


void moz_new_window_cb(GtkMozEmbed *embed, GtkMozEmbed **retval, guint chromemask)
{
     	
	SkipStone *skipstone = NULL;
     	D_ENTER;

     	if (config.notebook && !config.popup_in_new_window) {
		gint length;
		length = g_slist_length(window_count);
	     
	     	if (!config.show_tabs && length + 1 > 1)
	       		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), TRUE);
	     
	     	skipstone = new_skipstone_tab(FALSE);
	
      	        g_object_set_data(G_OBJECT(skipstone->vbox), "skipstone", skipstone);
		skipstone_append_tab(skipstone);
	     	gtk_widget_show_all(skipstone->vbox);
	     	gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), config.layout);
	     	gtk_widget_queue_resize(GTK_WIDGET(skipstone->handlebox));
	     	
	     	*retval = GTK_MOZ_EMBED(skipstone->embed);
	} else {
     		skipstone = new_skipstone_window (FALSE, TRUE); /* most of the time this is passed size also so no need to set gtk_size */
       		if (!(chromemask & GTK_MOZ_EMBED_FLAG_MENUBARON))
	       		gtk_widget_hide(skipstone->menubar);
	     	if (!(chromemask & GTK_MOZ_EMBED_FLAG_TOOLBARON)) {
	       		gtk_widget_hide(skipstone->handlebox);
		     	gtk_widget_hide(skipstone->bmarkhandlebox);
		}
	     	if (!(chromemask & GTK_MOZ_EMBED_FLAG_STATUSBARON))
	       		gtk_widget_hide(skipstone->statusbox);	       
	     	*retval = GTK_MOZ_EMBED (skipstone->embed);
	}
     	if (!config.navtbar) 
       		gtk_widget_hide(skipstone->handlebox);
     	if (!config.bmarktbar) {
	     if (!skipstone->is_notebook)
       		gtk_widget_hide(skipstone->bmarkhandlebox);
	     else
	       	hide_bmark_toolbar_nb();
	}

	D_RETURN;
}


void new_window_orphan_cb(GtkMozEmbedSingle *embed, GtkMozEmbed **retval, guint chromemask, gpointer data)
{
	SkipStone *skipstone;
     	D_ENTER;

     	skipstone = new_skipstone_window (FALSE, FALSE);
     	if (!(chromemask & GTK_MOZ_EMBED_FLAG_MENUBARON)) {
       		gtk_widget_hide(skipstone->menubar);
	}
     	if (!(chromemask & GTK_MOZ_EMBED_FLAG_TOOLBARON)) {
	     	gtk_widget_hide(skipstone->handlebox);
	     	gtk_widget_hide(skipstone->bmarkhandlebox);
	}
     	if (!(chromemask & GTK_MOZ_EMBED_FLAG_STATUSBARON)) {
       		gtk_widget_hide(skipstone->statusbox);
	}
     	*retval = GTK_MOZ_EMBED (skipstone->embed);
     	D_RETURN;
}



void net_state_cb (GtkMozEmbed *embed, gint state, guint status, SkipStone *skipstone)
{
	gchar *message = NULL;
	gint msg_id = 0;
     	D_ENTER;
	if (state & GTK_MOZ_EMBED_FLAG_IS_REQUEST) {
		if (state & GTK_MOZ_EMBED_FLAG_REDIRECTING)
			msg_id = 1 ;
		else if (state & GTK_MOZ_EMBED_FLAG_TRANSFERRING) 
			msg_id = 2 ;
		else if (state & GTK_MOZ_EMBED_FLAG_NEGOTIATING)
			msg_id = 3 ;
			 
	}

	if (state & GTK_MOZ_EMBED_FLAG_IS_DOCUMENT) {
		if (state & GTK_MOZ_EMBED_FLAG_START)
			msg_id = 4 ;
		else if (state & GTK_MOZ_EMBED_FLAG_STOP)
			msg_id = 5 ;
	}

	if (status == GTK_MOZ_EMBED_STATUS_FAILED_DNS)
		 msg_id = 6 ;
	else if (status == GTK_MOZ_EMBED_STATUS_FAILED_CONNECT)
		 msg_id = 7 ;
	else if (status == GTK_MOZ_EMBED_STATUS_FAILED_TIMEOUT)
		 msg_id = 8 ;
	else if (status == GTK_MOZ_EMBED_STATUS_FAILED_USERCANCELED)
		 msg_id = 9 ;

	if (!msg_id) D_RETURN;

	/* DBMK done with switch so g_strdup/g_free is only called once */
	switch (msg_id)
	{
	case 1 :
		message = g_strdup(_("Redirecting ..."));
		break;
	case 2 :
		message = g_strdup(_("Transferring ..."));
		break;
	case 3 :
		message = g_strdup(_("Authorizing ..."));
		break;
	case 4 :
		message = g_strdup(_("Loading ..."));
		break;
	case 5 :
		message = g_strdup(_("Done ..."));
		break;
	case 6 :
		message = g_strdup(_("Could not find site ..."));
		break;
	case 7 :
		message = g_strdup(_("Could not connect to site ..."));
		break;
	case 8 :
		message = g_strdup(_("Connection timeout ..."));
		break;
	case 9 :
		message = g_strdup(_("Transfer interrupted ..."));
		break;
	default :
		break;
	}

     	if (message !=NULL) {     	

	        gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
				  skipstone->sbar_status_msg_id);
     		gtk_statusbar_push(GTK_STATUSBAR(skipstone->statusbar),
				   skipstone->sbar_status_msg_id,
				   message);
	        g_free(message);
	}

	D_RETURN;
}

gint on_mouse_click(GtkMozEmbed *embed, gpointer dom_event, SkipStone *skipstone)
{
  	
   	gint button;
     	glong type;
     	gchar *img=NULL, *href=NULL, *linktext=NULL;
     	type = mozilla_get_context_menu_type(embed, dom_event, &img, &href, &linktext);
    	button = mozilla_get_button(dom_event);
	D_ENTER;
       	button++;

     	switch(button) {
	 case 3:
	     if ((type & CONTEXT_IMAGE) && (type & CONTEXT_LINK)) {
		  GtkWidget *menu = get_link_image_popup_menu(skipstone,img,href);
		  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, GDK_BUTTON3_MASK, gtk_get_current_event_time ());
	     } else if (type & CONTEXT_IMAGE) {
		  gtk_menu_popup(GTK_MENU(get_image_popup_menu(skipstone,img)), NULL, NULL, NULL, NULL, GDK_BUTTON3_MASK, gtk_get_current_event_time());
	     } else if (type & CONTEXT_LINK) {
		  gtk_menu_popup(GTK_MENU(get_link_popup_menu(skipstone,href,linktext)), NULL, NULL, NULL, NULL, GDK_BUTTON3_MASK, gtk_get_current_event_time());
	     } else if (type & CONTEXT_DOCUMENT) {
		  gtk_menu_popup(GTK_MENU(get_doc_popup_menu(skipstone,href)), NULL, NULL, NULL, NULL, GDK_BUTTON3_MASK, gtk_get_current_event_time ());
	     } else if (type & CONTEXT_OTHER) {
		  g_print(_("clicked on some other components\n"));
	     }
	     break;
	 case 2:
	     if ((type & CONTEXT_LINK) && href) {
			make_window(href);
	     } else {
		  	if (!skipstone->is_notebook)
		    		gtk_selection_convert(skipstone->window,
						      GDK_SELECTION_PRIMARY,
						      GDK_SELECTION_TYPE_STRING,
						      GDK_CURRENT_TIME);
		  	else
		    		gtk_selection_convert(main_window,
						      GDK_SELECTION_PRIMARY,
						      GDK_SELECTION_TYPE_STRING,
						      GDK_CURRENT_TIME);
	     }
	     break;
	 case 1:
	     if ((type & CONTEXT_LINK) && href) {
		  D_RETURN_(FALSE);
	     }
	     break;
	 default:
	     break;
	}
     D_RETURN_(FALSE);
}
   
gint on_key_press(GtkMozEmbed *embed, gpointer event, SkipStone *skipstone)
{
     	int modifier;
     	long key;     	
     	key = mozilla_get_key(event,&modifier);
     	D_ENTER;
     	if (!modifier && key == ESC_KEY) {
	     	on_stop(NULL,skipstone);
	     	D_RETURN_(TRUE);
	}
     	if (modifier & ALT) {
	     	switch(key) {
		 case N_KEY:
		     	blank_new_window(NULL,NULL);
		     	D_RETURN_(TRUE);
		 case L_KEY:
		     	open_in_current_window(NULL,skipstone);
		     	D_RETURN_(TRUE);
			break;	 
	      	case O_KEY:
		     	open_in_new_window(NULL,NULL);
		     	D_RETURN_(TRUE);
		 case X_KEY:
		     	exit_app(NULL,NULL);
		       D_RETURN_(TRUE);
		 case W_KEY:
		     	close_window(NULL,skipstone);
		     	D_RETURN_(TRUE);
		 case B_KEY:
		     	on_back(NULL,skipstone);
		     	D_RETURN_(TRUE);
		 case D_KEY:
		     	if (config.notebook && skipstone->is_notebook)
		       		detab();
		     	D_RETURN_(TRUE);
		 case F_KEY:
		     	on_forward(NULL,skipstone);
		     	D_RETURN_(TRUE);
		 case R_KEY:
		     	on_reload(NULL,skipstone);
		     	D_RETURN_(TRUE);
		 case H_KEY:
		     	go_home(NULL,skipstone);
		       	D_RETURN_(TRUE);
		 case I_KEY:
		     	find_dialog(NULL, skipstone);
		 	D_RETURN_(TRUE);
		 case PLUS_KEY:
		     	if (skipstone->is_notebook) {
			     	gtk_notebook_next_page(GTK_NOTEBOOK(main_notebook));
			}
		     	D_RETURN_(TRUE);
		 case MINUS_KEY:
		     	if (skipstone->is_notebook) {
			     	gtk_notebook_prev_page(GTK_NOTEBOOK(main_notebook));
			}
		     	D_RETURN_(TRUE);
		     
		 default:
		     	break;
		}
	} else if (modifier & CTRL) {
	     	switch (key) {
		 case O_KEY:
		     open_config_dialog(NULL,NULL);
		     D_RETURN_(TRUE);
		 case I_KEY:
		     on_view_history(NULL,skipstone);
		     D_RETURN_(TRUE);
		 case R_KEY:
		     if (config.notebook && !skipstone->is_notebook)
	      		retab(skipstone);
		     D_RETURN_(TRUE);
		 case S_KEY:
		     save_document(NULL,skipstone);
		     D_RETURN_(TRUE);
		 case U_KEY:
		     on_view_source(NULL, skipstone);
		     D_RETURN_(TRUE);
		 case P_KEY:
		     on_print(NULL, skipstone);
		     D_RETURN_(TRUE);
		 default:
		     break;
		}
	}
	       
     	return FALSE;
}

	       
void destroy_browser(GtkMozEmbed *embed, SkipStone *skipstone)
{
     	D_ENTER;
	if (skipstone->is_notebook) {
     		close_window(NULL, skipstone);
	} else {
	     	gtk_widget_destroy(skipstone->window);
	}
     	D_RETURN;
}

void update_navigation_buttons(SkipStone *skipstone)
{
     	gboolean can_go_back;
     	gboolean can_go_forward;
     	D_ENTER;
     	can_go_back = gtk_moz_embed_can_go_back(GTK_MOZ_EMBED(skipstone->embed));
     	can_go_forward = gtk_moz_embed_can_go_forward(GTK_MOZ_EMBED(skipstone->embed));
     	if (skipstone->back) {
	     if (can_go_back)
	     	gtk_widget_set_sensitive(skipstone->back, TRUE);
	     else
	       	gtk_widget_set_sensitive(skipstone->back, FALSE);
	}
     	if (skipstone->forward) {
	     if (can_go_forward)
	       	gtk_widget_set_sensitive(skipstone->forward, TRUE);
	     else
	       	gtk_widget_set_sensitive(skipstone->forward, FALSE);
	}
     	D_RETURN;
}
	
void size_to_cb(GtkMozEmbed *embed, gint width, gint height, SkipStone *skipstone)
{
	D_ENTER;
     	if (config.respect_sizeto == 1 && !skipstone->is_notebook) {
	     gtk_widget_set_usize(GTK_WIDGET(embed), width, height);
//	     gtk_widget_queue_resize(GTK_WIDGET(skipstone->window));
	}
        D_RETURN;
}

void js_status_cb(GtkMozEmbed *embed, SkipStone *skipstone)
{
     	gchar *message;
     	D_ENTER;
     	message = gtk_moz_embed_get_js_status(embed);

     	gtk_statusbar_pop(GTK_STATUSBAR(skipstone->statusbar),
			  skipstone->sbar_temp_msg_id);
	if (!message) D_RETURN;
	
     	if (strlen(message) > 0) 
	  gtk_statusbar_push(GTK_STATUSBAR(skipstone->statusbar),
			     skipstone->sbar_temp_msg_id,
			     message);
	
	g_free(message);
	D_RETURN;
}


static gchar *format_bps(gint n)
{
         gchar   *buf;
     D_ENTER;
         if (n < 1000)
       		buf = g_strdup_printf("%d Bps", n);
         else if (n < 19950)
       {
	    	n += 50;
	    	buf = g_strdup_printf("%d.%d KBps", n / 1000, (n % 1000) / 100);
       }
         else if (n < 999500)
       {
	    	n += 500;
	    	buf = g_strdup_printf("%d KBps", n / 1000);
       }
         else
       {
	    	n += 50000;
	    	buf = g_strdup_printf("%d.%d MBps",
      		      		    n / 1000000, (n % 1000000) / 100000);
       }
         D_RETURN_( buf );
}
