/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"
#include <sys/param.h>


GSList *window_count = NULL; /* open windows count, starts at 1 logically */
GSList *prefixes = NULL;
GList *combo_urls = NULL;
GNode *bookmarks = NULL;
ConfigData config;
gchar *app_path = NULL;
G_CONST_RETURN gchar *home = NULL;
GtkStyle*loading_style = NULL;

static void skipstone_read_configs(void);
static void skipstone_init_mozembed(void);
static void skipstone_initialize_color (void);  
static gboolean skipstone_get_single_embed_object(void);

static void skipstone_initialize_color (void)
{
     GtkWidget *label;
     GtkStyle  *rcstyle;
       
     /* create a dummy label so we can fetch the associated rc style */
     label = gtk_label_new ("");
     rcstyle = gtk_rc_get_style (label);
       
     /* this is needed for some (broken?) themes */
     if (rcstyle == NULL)
       rcstyle = gtk_style_new ();
     else
       gtk_style_ref (rcstyle);
       
     /* make styles */
     loading_style = gtk_style_copy (rcstyle);
     loading_style->fg[0].red = 0xFFFF;
     loading_style->fg[0].green = 0x1000;
     loading_style->fg[0].blue = 0x0010;
       
     /* free */
     gtk_widget_destroy (label);
     gtk_style_unref (rcstyle);       
}



static gboolean skipstone_get_single_embed_object(void)
{       
     	GtkMozEmbedSingle *single = NULL;
     	D_ENTER;
     	single = gtk_moz_embed_single_get();
     	if (!single) D_RETURN_(FALSE);
     	g_signal_connect(G_OBJECT(single), "new_window_orphan",
			   G_CALLBACK(new_window_orphan_cb),
			   NULL);
     	D_RETURN_(TRUE);
}
     	
static void skipstone_init_mozembed(void)
{
	gchar *profile;
     	D_ENTER;
     	profile = g_strconcat(home,"/.skipstone/mozilla",NULL);
     	gtk_moz_embed_set_profile_path(profile,"skipstone");
     	g_free(profile);
     	gtk_moz_embed_push_startup();
        mozilla_init_chrome ();
     	D_RETURN;
}

static void skipstone_read_configs(void)
{
     	D_ENTER;
     	read_urls();
	read_skipstone_config();
	read_bookmarks();
	read_history();
	read_prefixes();
	D_RETURN;
}

gint
main (gint argc,gchar *argv[]) 
{
	gchar *dir;
	gint crashed=0;
     	D_ENTER;
     	D("Starting SkipStone\n");
	if (!getenv("MOZILLA_FIVE_HOME")) { /* avoid mozilla's components crashing */
		g_print(_("MOZILLA_FIVE_HOME is not set !, bailing out .. set it like this\nexport MOZILLA_FIVE_HOME=/path/to/mozilla \nthen retry.\n"));
		return 0;
	}
     
     	app_path = argv[0];
     	home = g_get_home_dir();
	dir = g_strconcat(home,"/.skipstone",NULL);
     	/* this is fine, as it will silently error if it already exists*/
     	mkdir(dir,0755);
     	g_free(dir);     	
     	check_running(argc,argv); /* do we have another process - check if its alive */
	set_running();   /* if we are back here means we are starting a new one */
	
	
     	signal(SIGUSR1, handle_usr1_signal); /* connect the signal to launch new windows if running */
	signal(SIGSEGV, handle_segv_signal);/*connect to signal if a SIGSEGV crash happens*/

	skipstone_read_configs();
     
#ifdef ENABLE_NLS
    gtk_set_locale();
#   ifdef PACKAGE
#       ifdef LOCALEDIR
            bindtextdomain(PACKAGE, LOCALEDIR);
#       endif   /* LOCALEDIR */
        textdomain(PACKAGE);
#   else
        textdomain("skipstone");
#   endif   /* PACKAGE */
#endif  /* ENABLE_NLS */

#if 0
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);

	gtk_set_locale();
#endif

	gtk_init(&argc,&argv);
	skipstone_initialize_color();     	
	if((crashed = check_crash_file()) !=0) {
	     g_print(_("Recovering from crash\n"));
	     argc = 0;
	}

     	skipstone_init_mozembed();

     	if (argc > 1) { /* there is an argument, pass it as a loaded url */
	     gchar pathname[MAXPATHLEN];
	     gint i;
	     for (i = 1; i < argc; ++i) {
		if(realpath(argv[i], pathname) != NULL)
	       	    make_window(pathname);
		else
	       	    make_window(argv[i]);
	     }
	     
	} else {
	     if (!crashed)
		     make_window(NULL);
	}
	

     	if (!skipstone_get_single_embed_object())
       		g_error(_("Failed to get single embed object, please check your Embed!"));

	D("Entering main loop\n");     
	gtk_main();
     	D("Left main loop\n");
	D_RETURN_(0);
}
