/* copyright    Maher Awamy <muhri@muhri.net>           *
 *              Charlie Schmidt <ishamael@themes.org>   *
 *                                                      *
 *  released under the GPL                              */

#include "skipstone.h"

extern GSList *window_count;
extern gchar *home;

void handle_usr1_signal(gint sig)
{
     
     FILE *url_file;
     gchar *file;
     gchar *line;
     SkipStone *skipstone = NULL;

     D_ENTER;
     
     file = g_strconcat(home,"/.skipstone/sig_url",NULL);
     
     url_file = fopen(file,"r");
     if (url_file == NULL) { /* No argument was passed .. */
     		make_window(NULL);
     } else {
		line = (gchar *)g_malloc(1024);
	  	while(fgets(line,1024,url_file) != NULL) {
		     line[strlen(line)-1] = '\0';
		     if (!g_strncasecmp(line,"url=",4)) {
			  	make_window(line+4);
		     }
		     if (!g_strncasecmp(line,"urlx=",5)) {
			  	if (skipstone == NULL) {
				     skipstone = g_slist_nth_data(window_count,0);
				}
			  	if (skipstone)
				  	skipstone_load_url(skipstone,line+5);
		     }
		}
	  	fclose(url_file);
  		unlink(file);
     		g_free(line);
     }
     g_free(file);
     D_RETURN;
}

void set_running(void)
{
     	FILE *pidfile;
     	gchar *file;
     	gint  my_pid;
     	D_ENTER;
     	my_pid = getpid();
     	file = g_strconcat(home,"/.skipstone/running",NULL);
     	pidfile = fopen(file,"w");
     	if (pidfile == NULL) {
	     	printf("could not open pid file\n");
	     	g_free(file);
	     	D_RETURN;
	}
     	fprintf(pidfile,"pid=%d\n",my_pid);
     	fclose(pidfile);
     	g_free(file);
	D_RETURN;
}

void check_running(gint argc, gchar *argv[])
{
     	FILE *pidfile;
     	FILE *url_file;
     	gchar *file;
     	gchar *line;
     	gchar *arg;
     	gint  pid = 0;
     
     	D_ENTER;
     	
     	file = g_strconcat(home,"/.skipstone/running",NULL);
     	
     	pidfile = fopen(file, "r");
     	if (pidfile == NULL) {
	     	g_free(file);
	  	D_RETURN; /* no file means we want to start a new process immediately */
     	}
     	line = (gchar *)g_malloc(1024);
     	while(fgets(line,1024,pidfile) != NULL) {
	  	line[strlen(line)-1] = '\0';
	  	if (g_strncasecmp(line,"pid=",4) == 0) {
	       		pid = atoi(line+4);
	  	}
	}
     	fclose(pidfile);
     	if ((pid > 0) && (kill(pid,0) == 0)) { /* its alive */
		if (argc < 2) { /* No args, just a new window */
		     	kill(pid,SIGUSR1);
		} else { /* Url, print it to file so we can read it when we launch the new window */
		    	arg = g_strconcat(home,"/.skipstone/sig_url",NULL);
      		     	url_file = fopen(arg,"w");
		     	if (url_file == NULL) {
			     	g_print(_("Could not open the url arg file for some reason\n"));
			     	kill(pid,SIGUSR1);
			     	g_free(arg);
			} else {
			     	gint i;
			     	for (i=1;i < argc; ++i) {
				     	if (!argv[i] || !strcmp(argv[i],"")) continue;
				     	if (!strcmp(argv[i],"-x")) {
					     	i++;
					     	fprintf(url_file,"urlx=%s\n",argv[i]);
					     	continue;
					}
				     	fprintf(url_file,"url=%s\n",argv[i]);					     
				}
				fclose(url_file);			     	
			     	kill(pid,SIGUSR1);
			     	g_free(arg);
			}
		 
		}

		g_free(line); /* clean up after yourself before you exit this processs */	
		g_free(file);
		exit(0);
	}
     	g_free(line); /* other wise clean up those only */
     	g_free(file);
	D_RETURN;
}
