/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"

typedef struct {
          gint back_is_sensitive;
          gint forward_is_sensitive;
          gint stop_is_sensitive;
          gint reload_is_sensitive;
}TbarSen;

static TbarSen *get_sensitive_buttons(SkipStone *skipstone);
static void set_sensitive_buttons(SkipStone *skipstone, TbarSen *tbarsen);
static void theme_menu_destroyed(GtkWidget *menu, gchar *theme);

extern GSList *window_count;
extern ConfigData config;
extern GList *combo_urls;
gint Mozilla_Prefs = 0;


/* make the menu here, so its easier to change/update */
void make_menu(SkipStone *skipstone)
{
	GtkWidget *file, *filemenu, *help, *helpmenu, *about, *find, *save;
	GtkWidget *close, *new_window, *open, *openc, *sep1, *close_win;
	GtkWidget *nav,*navmenu,*back,*forw,*reload,*stop,*home;
	GtkWidget *pref, *prefmenu;
	GtkWidget *toolbar, *toolbarmenu, *themes, *themes_menu;
	GtkWidget *options,*pixmap,*text,*both, *sep2;
     	GtkWidget *cb_bmarktoolbar;
	GtkWidget *cb_navtoolbar, *switch_notebook, *go_menu, *offline;
	GSList *radio_buttons = NULL;
     	GtkWidget *print, *save_session, *load_session, *encoding;
	
     	D_ENTER;
	
	file = gtk_menu_item_new_with_label(_("File"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar), file);

	filemenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(file),filemenu);

	new_window = gtk_menu_item_new_with_label(_("New Window"));
	g_signal_connect(G_OBJECT(new_window), "activate", G_CALLBACK(blank_new_window), NULL);
	gtk_widget_add_accelerator(new_window,"activate",skipstone->accelgroup,GDK_n,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), new_window);
	
	open = gtk_menu_item_new_with_label(_("Open in a New Window"));
	g_signal_connect(G_OBJECT(open), "activate", G_CALLBACK(open_in_new_window), NULL);
	gtk_widget_add_accelerator(open,"activate",skipstone->accelgroup,GDK_o,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), open);     

	openc = gtk_menu_item_new_with_label(_("Open in Current Window"));
	g_signal_connect(G_OBJECT(openc),"activate",G_CALLBACK(open_in_current_window),skipstone);
	gtk_widget_add_accelerator(openc,"activate",skipstone->accelgroup,GDK_l,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu),openc);

	close_win = gtk_menu_item_new_with_label(_("Close..."));
	g_signal_connect(G_OBJECT(close_win), "activate", G_CALLBACK(close_window), skipstone);
	gtk_widget_add_accelerator(close_win,"activate",skipstone->accelgroup,GDK_w,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), close_win);

	sep1 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(filemenu), sep1);
	
     	save = gtk_menu_item_new_with_label(_("Save"));
     	g_signal_connect(G_OBJECT(save), "activate", G_CALLBACK(save_document), skipstone);
     	gtk_widget_add_accelerator(save,"activate",skipstone->accelgroup,GDK_s,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(filemenu), save);
     
	find = gtk_menu_item_new_with_label(_("Find..."));
     	g_signal_connect(G_OBJECT(find), "activate", G_CALLBACK(find_dialog), skipstone);
	gtk_widget_add_accelerator(find, "activate", skipstone->accelgroup, GDK_i, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), find);

	sep1 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(filemenu), sep1);
	
     	save_session = gtk_menu_item_new_with_label(_("Save Session"));
     	g_signal_connect(G_OBJECT(save_session), "activate", G_CALLBACK(skipstone_save_a_session), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), save_session);
     
     	load_session = gtk_menu_item_new_with_label(_("Load Session"));
     	g_signal_connect(G_OBJECT(load_session), "activate", G_CALLBACK(skipstone_load_a_session), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), load_session);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);
     
     	offline = gtk_check_menu_item_new_with_label(_("Work Offline"));
     	g_signal_connect(G_OBJECT(offline), "toggled", G_CALLBACK(on_offline_toggle_cb), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), offline);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);
     

     	print = gtk_menu_item_new_with_label(_("Print"));
     	g_signal_connect(G_OBJECT(print), "activate", G_CALLBACK(on_print), skipstone);
     	gtk_widget_add_accelerator(print,"activate",skipstone->accelgroup,GDK_p,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(filemenu), print);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);

     	
	close = gtk_menu_item_new_with_label(_("Exit..."));
	g_signal_connect(G_OBJECT(close), "activate", G_CALLBACK(exit_app), NULL);
	gtk_widget_add_accelerator(close,"activate",skipstone->accelgroup,GDK_x,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), close);
	
	skipstone->window_menuitem = gtk_menu_item_new_with_label(_("Windows"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar),skipstone->window_menuitem);

	make_window_menu(skipstone);

	nav = gtk_menu_item_new_with_label(_("Navigation"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar),nav);

	navmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(nav),navmenu);

	skipstone->go_menu = go_menu_init();
	go_menu = gtk_menu_item_new_with_label(_("Go"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar), go_menu);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(go_menu), skipstone->go_menu->menu);
	
	
	back = gtk_menu_item_new_with_label(_("Back"));
	g_signal_connect(G_OBJECT(back),"activate",G_CALLBACK(on_back),skipstone);
	gtk_widget_add_accelerator(back,"activate",skipstone->accelgroup,GDK_b,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),back);

	forw = gtk_menu_item_new_with_label(_("Forward"));
	g_signal_connect(G_OBJECT(forw),"activate",G_CALLBACK(on_forward),skipstone);
	gtk_widget_add_accelerator(forw,"activate",skipstone->accelgroup,GDK_f,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),forw);

	reload = gtk_menu_item_new_with_label(_("Reload Page"));
	g_signal_connect(G_OBJECT(reload),"activate",G_CALLBACK(on_reload),skipstone);
	gtk_widget_add_accelerator(reload,"activate",skipstone->accelgroup,GDK_r,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),reload);

	stop = gtk_menu_item_new_with_label(_("Stop Loading"));
	g_signal_connect(G_OBJECT(stop),"activate",G_CALLBACK(on_stop),skipstone);
	gtk_widget_add_accelerator(stop,"activate",skipstone->accelgroup,GDK_Escape,GDK_RELEASE_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),stop);

	home = gtk_menu_item_new_with_label(_("Home"));
	g_signal_connect(G_OBJECT(home),"activate",G_CALLBACK(go_home),skipstone);
	gtk_widget_add_accelerator(home,"activate",skipstone->accelgroup,GDK_h,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),home);

	pref = gtk_menu_item_new_with_label(_("Preferences"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar),pref);
	
	prefmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(pref),prefmenu);

	options = gtk_menu_item_new_with_label(_("Options"));
	g_signal_connect(G_OBJECT(options),"activate",G_CALLBACK(open_config_dialog),NULL);
	gtk_widget_add_accelerator(options,"activate",skipstone->accelgroup,GDK_o,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(prefmenu),options);

     	switch_notebook = gtk_menu_item_new_with_label(_("Switch to Tabbed view"));
     	g_signal_connect(G_OBJECT(switch_notebook), "activate", G_CALLBACK(switch_layouts), NULL);
     	gtk_menu_append(GTK_MENU(prefmenu), switch_notebook);
	
	skipstone->use_skipstone_mime = gtk_check_menu_item_new_with_label(_("Use SkipStone MIME?"));
	if (config.use_skipstone_mime)
	  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(skipstone->use_skipstone_mime),TRUE);
	g_signal_connect(G_OBJECT(skipstone->use_skipstone_mime), "toggled", G_CALLBACK(toggle_mime_handling), NULL);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(skipstone->use_skipstone_mime), TRUE);
	gtk_menu_append(GTK_MENU(prefmenu), skipstone->use_skipstone_mime);
			
	sep2 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(prefmenu), sep2);
	
	toolbar = gtk_menu_item_new_with_label(_("Toolbar"));
	gtk_menu_append(GTK_MENU(prefmenu),toolbar);

	toolbarmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(toolbar),toolbarmenu);

	pixmap = gtk_radio_menu_item_new_with_label(radio_buttons,_("Pixmaps"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(pixmap));
	g_signal_connect(G_OBJECT(pixmap),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(0));
	gtk_menu_append(GTK_MENU(toolbarmenu),pixmap);

	text = gtk_radio_menu_item_new_with_label(radio_buttons, _("Text"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(text));
	g_signal_connect(G_OBJECT(text),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(1));
	gtk_menu_append(GTK_MENU(toolbarmenu),text);

	both = gtk_radio_menu_item_new_with_label(radio_buttons, _("Both"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(both));
	g_signal_connect(G_OBJECT(both),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(2));
	gtk_menu_append(GTK_MENU(toolbarmenu),both);
	
     	themes = gtk_menu_item_new_with_label(_("Themes"));
     	gtk_menu_append(GTK_MENU(prefmenu), themes);
     	
     	themes_menu = gtk_menu_new();
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(themes), themes_menu);
     
     	make_themes_menu(themes_menu);
	
     	encoding = gtk_menu_item_new_with_label(_("Encoding"));
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(encoding), skipstone_get_encoding_menu(skipstone));
     	gtk_menu_append(GTK_MENU(prefmenu), encoding);
     
	cb_bmarktoolbar = gtk_check_menu_item_new_with_label(_("Hide Bookmark toolbar"));
     	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(cb_bmarktoolbar), TRUE);
     	g_signal_connect(G_OBJECT(cb_bmarktoolbar), "toggled", G_CALLBACK(hide_bookmark_toolbar), skipstone);
     	gtk_menu_append(GTK_MENU(prefmenu), cb_bmarktoolbar);

    	cb_navtoolbar = gtk_check_menu_item_new_with_label(_("Hide Navigation toolbar"));
     	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(cb_navtoolbar), TRUE);
     	g_signal_connect(G_OBJECT(cb_navtoolbar), "toggled", G_CALLBACK(hide_navigation_toolbar), skipstone);
     	gtk_menu_append(GTK_MENU(prefmenu), cb_navtoolbar);



     	skipstone->bookmark_menubar_item = gtk_menu_item_new_with_label(_("Bookmarks"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar),skipstone->bookmark_menubar_item);

	skipstone->bookmark_toolbar_widgets = NULL;

	generate_bookmark_ui(skipstone);

     	help = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_bar_append(GTK_MENU_BAR(skipstone->menubar), help);

	helpmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(help),helpmenu);
	
	about = gtk_menu_item_new_with_label(_("About SkipStone"));
     	g_signal_connect(G_OBJECT(about), "activate", G_CALLBACK(about_skipstone), NULL);
	gtk_menu_append(GTK_MENU(helpmenu), about);
     
	if (config.layout == 0) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(pixmap),TRUE);
	} else if (config.layout == 1) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(text),TRUE);
	} else {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(both),TRUE);
	}
       	if (config.bmarktbar == 0) {
	     	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(cb_bmarktoolbar),TRUE);
	}
	if (config.navtbar == 0) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(cb_navtoolbar),TRUE);
	}

	gtk_widget_show_all(skipstone->menubar);
	D_RETURN;
}

void make_window_menu(SkipStone *skipstone) {
	GtkWidget *view_source;
	GtkWidget *history;
	GtkWidget *sep;
	GSList *l;
     	
     	D_ENTER;
	
     	if (skipstone->windowmenu) {
		gtk_widget_destroy(skipstone->windowmenu);
	}

     	skipstone->windowmenu = gtk_menu_new();
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(skipstone->window_menuitem), skipstone->windowmenu);

	view_source = gtk_menu_item_new_with_label(_("View Source"));
     	g_signal_connect(G_OBJECT(view_source), "activate", G_CALLBACK(on_view_source), skipstone);
     	gtk_menu_append(GTK_MENU(skipstone->windowmenu), view_source);
	gtk_widget_add_accelerator(view_source,"activate",skipstone->accelgroup,GDK_u,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
				   
	history = gtk_menu_item_new_with_label(_("History"));
	g_signal_connect(G_OBJECT(history),"activate",G_CALLBACK(on_view_history),skipstone);
	gtk_menu_append(GTK_MENU(skipstone->windowmenu),history);
	gtk_widget_add_accelerator(history,"activate",skipstone->accelgroup,GDK_i,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);	
     
       	sep = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(skipstone->windowmenu),sep);

	for (l = window_count; l ; l = l->next) {
		
	     	SkipStone *window_skipstone = l->data;
	     
		if (window_skipstone->embed != NULL && !window_skipstone->is_notebook) {
		     	GtkWidget *menuitem;
		     	if (!window_skipstone->title) 
			     continue;			
		     	menuitem = gtk_menu_item_new_with_label(window_skipstone->title);
			gtk_menu_append(GTK_MENU(skipstone->windowmenu),menuitem);
			g_signal_connect(G_OBJECT(menuitem),"activate",G_CALLBACK(on_windowmenu_item_clicked),window_skipstone->window);
		}
	}


	gtk_widget_show_all(skipstone->windowmenu);
	D_RETURN;
}

void make_notebook_tab(const gchar *url) {
     	D_ENTER;
     	add_to_notebook(url);
     	D_RETURN;
}

void make_window(const gchar *url)
{
     	D_ENTER;
     	if (config.notebook) { /* user pref is notebook view */
		make_notebook_tab(url);
	     	D_RETURN;
	}
     
     	make_real_window(url);
     	D_RETURN;
}

void make_real_window(const gchar *url)
{
	SkipStone *skipstone;
     	D_ENTER;
     	skipstone = new_skipstone_window(TRUE, TRUE);

     	if (url) { /* do I have an url to load */
     	  	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), url);
	     	on_entry(GTK_WIDGET(GTK_COMBO(skipstone->combo)->entry), skipstone);
     	} else {
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry),config.home);
     		on_entry(GTK_WIDGET(GTK_COMBO(skipstone->combo)->entry), skipstone);
	}

/*     	skipstone->SkipNsHistory = mozilla_history_init(skipstone->embed); */


	D_RETURN;
}

SkipStone * new_skipstone_window(gboolean with_plugins, gboolean set_size)
{
     	SkipStone *skipstone; /* the browser struct */
	gchar *win_title;
     	D_ENTER;

     	win_title = g_strdup_printf ("SkipStone %d.%d.%d",SKIPSTONE_MAJOR,SKIPSTONE_MINOR,SKIPSTONE_MICRO);

    	skipstone = g_new0(SkipStone,1);
	
     	skipstone->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
     	gtk_window_set_title(GTK_WINDOW(skipstone->window), win_title);
        skipstone_window_set_icon(skipstone->window);
     	g_free(win_title);

        if (set_size) {
	     gtk_window_set_default_size(GTK_WINDOW(skipstone->window),config.xsize,config.ysize);
	     gtk_window_set_policy(GTK_WINDOW(skipstone->window), TRUE, TRUE, FALSE);
	}
          	
     	gtk_widget_realize(skipstone->window);

     	skipstone->accelgroup = gtk_accel_group_new();
     	gtk_window_add_accel_group(GTK_WINDOW(skipstone->window), skipstone->accelgroup);

	/* DBMK moved to here so skipstone->embed is available for plugins to connect to */
     	skipstone->embed = GTK_MOZ_EMBED (gtk_moz_embed_new());

	skipstone->embedbox = gtk_hbox_new(0,0);
	gtk_box_pack_start(GTK_BOX(skipstone->embedbox), GTK_WIDGET(skipstone->embed),TRUE, TRUE, 0);
	/* --------------------------------------- */
     	skipstone->vbox = gtk_vbox_new(0,0);
     	gtk_container_add(GTK_CONTAINER(skipstone->window), skipstone->vbox);

     	skipstone->menubar = gtk_menu_bar_new();
     	skipstone->handlebox = gtk_handle_box_new();

	skipstone->bookmark_toolbar = gtk_toolbar_new();

        gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->bookmark_toolbar), GTK_TOOLBAR_SPACE_EMPTY);
/*     	gtk_container_set_border_width(GTK_CONTAINER(skipstone->bookmark_toolbar),2);*/
     	
     	skipstone->bmarkhandlebox = gtk_handle_box_new();
     	
     	make_menu(skipstone);
	

	gtk_container_add(GTK_CONTAINER(skipstone->bmarkhandlebox),skipstone->bookmark_toolbar);

     	skipstone->menuhandlebox = gtk_handle_box_new ();
     	gtk_container_add(GTK_CONTAINER(skipstone->menuhandlebox), skipstone->menubar);
     	
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->menuhandlebox, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->handlebox, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->bmarkhandlebox,FALSE,FALSE,0);

     	/* toolbar and pixmaps */
     	create_toolbar(skipstone,0);
     	/* ------------------- */
     
     	/* do we have any plugins to pack after the toolbar, do that now */
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_TOOLBAR);
	
	skipstone->right_of_embed_box = gtk_hbox_new(0,0);
	/* any plugins right of mozembed? */
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_RIGHT_OF_MOZEMBED);
	
	skipstone->left_of_embed_box = gtk_hbox_new(0,0);
	/* any left of it ? */
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_LEFT_OF_MOZEMBED);
	
	skipstone->main_hbox = gtk_hbox_new(0,0);
	
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->left_of_embed_box, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->embedbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->right_of_embed_box, FALSE, FALSE, 0);
	
     	if (!Mozilla_Prefs) {
	     	set_mozilla_prefs();
/*	     	mozilla_init_prompt_service();*/
		Mozilla_Prefs = 1;
	}
     
	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->main_hbox, TRUE, TRUE, 0);
	/* plugins after mozembed */
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_MOZEMBED);
     	
	skipstone->statusbox = gtk_hbox_new(0,0);
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->statusbox, FALSE, FALSE, FALSE);

	/*plugins after the statusbar */
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_STATUSBAR);
	
     	skipstone->statusbar = gtk_statusbar_new();
     	skipstone->sbar_temp_msg_id =
	  gtk_statusbar_get_context_id(GTK_STATUSBAR(skipstone->statusbar), "statusbar temp message");
     	skipstone->sbar_status_msg_id =
	     gtk_statusbar_get_context_id(GTK_STATUSBAR(skipstone->statusbar), "statusbar persist message");
     	gtk_box_pack_start(GTK_BOX(skipstone->statusbox), skipstone->statusbar, TRUE, TRUE, FALSE);

     	skipstone->progressbar = gtk_progress_bar_new();
	/* below line is to force expand now */
     	gtk_progress_set_show_text(GTK_PROGRESS(skipstone->progressbar), 1);
     	gtk_box_pack_end(GTK_BOX(skipstone->statusbox), skipstone->progressbar, FALSE,FALSE,FALSE);
     	gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar), 1);
	
     	/* connect signals */
	connect_embed_signals(skipstone);
     	g_signal_connect(G_OBJECT(skipstone->window), "destroy", G_CALLBACK(destroy_window_callback), skipstone);
	set_selection_targets(skipstone->window, skipstone);	
     
    	skipstone->is_notebook = 0;
	
     	gtk_widget_show_all(skipstone->window);
     	if (set_size) g_signal_connect(G_OBJECT(skipstone->window), "size_request", G_CALLBACK(on_window_size_request), skipstone);
     	gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), config.layout);
        gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), GTK_TOOLBAR_SPACE_EMPTY);
     	gtk_widget_queue_resize(GTK_WIDGET(skipstone->handlebox));	
     	
     	if (config.bmarktbar == 0) 
	     	gtk_widget_hide(skipstone->bmarkhandlebox);
	
	if (config.navtbar == 0) 
		gtk_widget_hide(skipstone->handlebox);

     	window_count = g_slist_append(window_count,skipstone);

	D_RETURN_(skipstone);
}


void connect_embed_signals(SkipStone *skipstone)
{
     	D_ENTER;
     	g_signal_connect(G_OBJECT(skipstone->embed), "net_start", G_CALLBACK(start_load), skipstone);
     	g_signal_connect(G_OBJECT(skipstone->embed), "link_message", G_CALLBACK(link_message), skipstone);
     	g_signal_connect(G_OBJECT(skipstone->embed), "title", G_CALLBACK(title_changed), skipstone);
     	g_signal_connect(G_OBJECT(skipstone->embed), "location", G_CALLBACK(url_clicked), skipstone);
     	g_signal_connect(G_OBJECT(skipstone->embed), "net_stop", G_CALLBACK(stop_load), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "new_window", G_CALLBACK(moz_new_window_cb), skipstone);
        g_signal_connect(G_OBJECT(skipstone->embed), "open_uri", G_CALLBACK(handle_open_uri), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "net_state", G_CALLBACK(net_state_cb), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "destroy_browser", G_CALLBACK(destroy_browser), skipstone);
     	g_signal_connect(G_OBJECT(skipstone->embed), "dom_mouse_click", G_CALLBACK(on_mouse_click), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "dom_key_press", G_CALLBACK(on_key_press), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "size_to", G_CALLBACK(size_to_cb), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "js_status", G_CALLBACK(js_status_cb), skipstone);
	g_signal_connect(G_OBJECT(skipstone->embed), "progress_all", G_CALLBACK(handle_progress), skipstone);
	D_RETURN;
}


static TbarSen * get_sensitive_buttons(SkipStone *skipstone)
{
     	TbarSen *tbarsen;
     	tbarsen = g_new0(TbarSen,1);
     	D_ENTER;
     	if (skipstone->back)
       		tbarsen->back_is_sensitive = GTK_WIDGET_IS_SENSITIVE(skipstone->back);
     	if (skipstone->forward)
       		tbarsen->forward_is_sensitive = GTK_WIDGET_IS_SENSITIVE(skipstone->forward);
     	if (skipstone->stop)
       		tbarsen->stop_is_sensitive = GTK_WIDGET_IS_SENSITIVE(skipstone->stop);
	if (skipstone->reload)
       		tbarsen->reload_is_sensitive = GTK_WIDGET_IS_SENSITIVE(skipstone->reload);
     	D_RETURN_(tbarsen);
}

void create_toolbar(SkipStone *skipstone, gint i)
{
     	GtkWidget *back, *forward, *stop, *home, *reload;
     	gint entry_length = config.xsize - 150;
        gint loaded;
     	gchar *text_in_combo = NULL;
     	TbarSen *tbarsen = NULL;
     	D_ENTER;
     	if (i) {     
	     	tbarsen = get_sensitive_buttons(skipstone);
	     	text_in_combo = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry)));	     	
	     	gtk_widget_destroy(skipstone->toolbar);
			
	}
	     
     	skipstone->toolbar = gtk_toolbar_new();


/*     	gtk_container_set_border_width(GTK_CONTAINER(skipstone->toolbar),2);*/

     	gtk_container_add(GTK_CONTAINER(skipstone->handlebox), skipstone->toolbar);

     	skipstone_plugin_check(skipstone, PLUGIN_IN_TOOLBAR_START);

	if (config.navbar_buttons & NAVBAR_BACK) {
	     	back = create_pixmap(skipstone->toolbar,"back.png",&loaded);
	     	skipstone->back = gtk_toolbar_append_item(GTK_TOOLBAR(skipstone->toolbar), _("Back"),_("Go back to previous page"),"back func", back, G_CALLBACK(on_back),skipstone);
		entry_length -= 50;
	}

	if (config.navbar_buttons & NAVBAR_FOR) {
     		forward = create_pixmap(skipstone->toolbar,"forward.png",&loaded);
	     	skipstone->forward = gtk_toolbar_append_item(GTK_TOOLBAR(skipstone->toolbar), _("Forward"), _("Go Forward"),"forward func", forward, G_CALLBACK(on_forward), skipstone);
		entry_length -= 50;
	}

	if (config.navbar_buttons & NAVBAR_RELOAD) {
 	    	reload = create_pixmap(skipstone->toolbar,"reload.png",&loaded);
		skipstone->reload = gtk_toolbar_append_item(GTK_TOOLBAR(skipstone->toolbar), _("Reload"),_("Reloads current Page, shift-click to by pass cache or right click for more options"),"reload func", reload, NULL, NULL);
	     	g_signal_connect(G_OBJECT(skipstone->reload), "button_press_event", G_CALLBACK(on_reload_button_press), skipstone);
		entry_length -= 50;
	}

	if (config.navbar_buttons & NAVBAR_STOP) {
	     	stop = create_pixmap(skipstone->toolbar,"stop.png",&loaded);
	     	skipstone->stop = gtk_toolbar_append_item(GTK_TOOLBAR(skipstone->toolbar), _("Stop"),_("Stops Loading"),"stop func", stop, G_CALLBACK(on_stop), skipstone);
		entry_length -= 50;
	}

     	skipstone->combo = gtk_combo_new();
	
     	if (combo_urls !=NULL) 
     		gtk_combo_set_popdown_strings(GTK_COMBO(skipstone->combo),combo_urls);
	
	gtk_combo_disable_activate(GTK_COMBO(skipstone->combo));
        skipstone_plugin_check(skipstone, PLUGIN_IN_TOOLBAR_BEFORE_ENTRY);
     	gtk_toolbar_append_widget(GTK_TOOLBAR(skipstone->toolbar), skipstone->combo, _("Enter a URL here"),NULL);

	if (config.navbar_buttons & NAVBAR_HOME) {
	     	home = create_pixmap(skipstone->toolbar,"home.png",&loaded);
	     	skipstone->home = gtk_toolbar_append_item(GTK_TOOLBAR(skipstone->toolbar), _("Home"),_("Go to Homepage"),"home func", home, G_CALLBACK(go_home), skipstone);
		entry_length -= 50;
	}

     	gtk_widget_set_usize(GTK_WIDGET(skipstone->combo),entry_length,30);
     	g_signal_connect(G_OBJECT(GTK_COMBO(skipstone->combo)->entry), "activate", G_CALLBACK(on_entry),  skipstone);
	g_signal_connect(G_OBJECT(GTK_COMBO(skipstone->combo)->popwin),"hide",G_CALLBACK(on_list_select),skipstone);
	g_signal_connect_after(G_OBJECT(GTK_COMBO(skipstone->combo)->entry), "button_press_event", G_CALLBACK(on_entry_button_press), skipstone);
     	
	if (i) {
	     	gtk_widget_show_all(skipstone->toolbar);
	     	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), text_in_combo);
	     	gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), config.layout);
	        gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), GTK_TOOLBAR_SPACE_EMPTY);
     		gtk_widget_queue_resize(GTK_WIDGET(skipstone->handlebox));	
	     	g_free(text_in_combo);
		set_sensitive_buttons(skipstone,tbarsen);
	}
     	/* if any plugins would like to be in the toolbar, now is the time */
	skipstone_plugin_check(skipstone, PLUGIN_IN_TOOLBAR);
	D_RETURN;
}

static void set_sensitive_buttons(SkipStone *skipstone, TbarSen *tbarsen) 
{
	D_ENTER;
     	if (skipstone->back) 
       		gtk_widget_set_sensitive(skipstone->back, tbarsen->back_is_sensitive);
     	if (skipstone->forward)
       		gtk_widget_set_sensitive(skipstone->forward, tbarsen->forward_is_sensitive);
     	if (skipstone->stop)
       		gtk_widget_set_sensitive(skipstone->stop, tbarsen->stop_is_sensitive);
     	if (skipstone->reload)
       		gtk_widget_set_sensitive(skipstone->reload, tbarsen->reload_is_sensitive);
     	g_free(tbarsen);
	D_RETURN;
}

void make_themes_menu(GtkWidget *menu)
{
	gint i, count;
     	gchar *dirs[] = { 0,
	                  SKIPSTONE_LOCAL_THEME_DIR, 
	       		  SKIPSTONE_SYSTEM_THEME_DIR, 
			  0
	       	       	};
	D_ENTER;
     
     	dirs[0] = g_strconcat(g_get_home_dir(),"/.skipstone/pixmaps",NULL);
	count = 0;
     	for (i = 0; dirs[i] != NULL ; i++) {
	     	gchar *dirname = dirs[i];
	     	DIR *dir;
	     	struct dirent *dent;
	     	struct stat stats;
	     	dir = opendir (dirname);
	     	if (dir) {
		     	GtkWidget *menu_item;
		     	GtkWidget *icon;
		     	GtkWidget *lbl;
		     	GtkWidget *hbox;
			gchar *theme = NULL;
		     	while ((dent = readdir(dir))) {
			     	gchar *temp = g_strconcat(dirname,"/",dent->d_name,NULL);
			     	stat(temp,&stats);
			     	if (!S_ISDIR(stats.st_mode)) {
				     	g_free(temp); 
				     	continue;
				}
			     	if (!strcmp(dent->d_name,".")) {
				     	continue;
				     	g_free(temp);
				}
			     	if (!strcmp(dent->d_name,"..")) {
				     	g_free(temp);
				     	continue;
				}
			     	menu_item = gtk_menu_item_new();
			     	lbl = gtk_label_new(dent->d_name);
			     	icon = create_pixmap_from_path(dirname,dent->d_name,menu_item);
			     	hbox = gtk_hbox_new(0,8);
			     	gtk_box_pack_start(GTK_BOX(hbox), lbl, FALSE, FALSE, 0);
			     	gtk_box_pack_start(GTK_BOX(hbox), icon, FALSE, FALSE, 0);
			     	gtk_container_add(GTK_CONTAINER(menu_item), hbox);
			     	theme = g_strdup(dent->d_name);
				g_signal_connect(G_OBJECT(menu_item), "activate", G_CALLBACK(switch_theme), theme);
				g_signal_connect(G_OBJECT(menu_item), "destroy", G_CALLBACK(theme_menu_destroyed), theme);
			     	gtk_menu_append(GTK_MENU(menu), menu_item);
				g_free(temp);
			     	count++;
			     	if (count == 9) {
				     GtkWidget *newmenu;
				     newmenu = gtk_menu_new();
				     menu_item = gtk_menu_item_new_with_label(_("More ..."));
				     gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), newmenu);
				     gtk_menu_append(GTK_MENU(menu), menu_item);
				     menu = newmenu;
				     count=0;
				}

			}
		closedir(dir);
		}

	}

	g_free(dirs[0]);
	
	D_RETURN;
}

static void theme_menu_destroyed(GtkWidget *menu_item, gchar *theme)
{
	D_ENTER;
     	if (theme != NULL)
	  g_free(theme);
     	D_RETURN;
}
