/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

/* Its easier to make those seperate <muhri> */


#include "skipstone.h"

extern GSList *window_count;
extern gint Mozilla_Prefs;
extern ConfigData config;

GtkWidget *main_window = NULL;
GtkWidget *main_notebook = NULL;
GtkAccelGroup *accelgroup = NULL;
GtkWidget *menubar= NULL;
GtkWidget *bmark_toolbar_widget = NULL;
GtkWidget *bmark_toolbar_handlebox = NULL;
GtkWidget *bmark_menu_item = NULL;
GoMenu *notebook_go_menu = NULL;

/*static guint current_page = 0;*/
static SkipStone *skipstone = NULL;

static void update_window_title(SkipStone *skipstone);
static void make_main_menu(GtkWidget *vbox);
static void destroy_main_window(GtkWidget *main_window);
static void hide_bookmark_toolbar_notebook(GtkCheckMenuItem *cb_menuitem,GtkWidget *handlebox);
static void change_tab_pos(GtkWidget *menu_item, gpointer data);
static void on_notebook_switch_page(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num); 
static void skipstone_tab_destroy_cb(GtkWidget *w, SkipStone *skipstone);
/* menu functions that psass the browser, they call regular ones
 * but get the browser first */
static void open_in_current_window_nb(void);
static void go_home_nb(void);
static void on_back_nb(void);
static void on_forward_nb(void);
static void on_stop_nb(void);
static void on_reload_nb(void);
static void find_dialog_nb(void);
static void close_window_nb(void);
static void on_view_history_nb(void);
static void on_view_source_nb(void);
static void notebook_next(void);
static void notebook_prev(void);
static void save_document_nb(void);
static void on_print_nb(void);
/* */

/* XPM */
static char * small_close[] = {
"8 9 17 1",
" 	c None",
".	c #020302",
"+	c #22262A",
"@	c #626466",
"#	c #828486",
"$	c #A6A2AE",
"%	c #AEAAB6",
"&	c #B6B2BE",
"*	c #BEBAC6",
"=	c #EEEEF2",
"-	c #424242",
";	c #121212",
">	c #4E5052",
",	c #FEFEFE",
"'	c #72767A",
")	c #6A6E72",
"!	c #1A1A1A",
"        ",
" &  *%  ",
" >#=+;$ ",
"  .>.@  ",
"  @.-   ",
"  -..'  ",
" &;#!.) ",
" >$ %;> ",
"        "};




static void on_notebook_switch_page(GtkNotebook *notebook, GtkNotebookPage *page, guint page_num)
{
     	GtkWidget *vbox=NULL;
     	SkipStone *current_skipstone=NULL;
     	D_ENTER;
     
     	vbox = gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), page_num);
	g_return_if_fail(vbox != NULL);     
     	current_skipstone = g_object_get_data(G_OBJECT(vbox), "skipstone");
	g_return_if_fail(current_skipstone != NULL);
     
     	update_window_title(current_skipstone);
        if (current_skipstone->embed && GTK_BIN(current_skipstone->embed)->child != NULL) gtk_widget_grab_focus(GTK_BIN(current_skipstone->embed)->child);
	if (config.tabs_in_focus_order) {
	  /*this will keep window_count in focus order (oldest at start (0))*/
	  window_count = g_slist_remove(window_count,current_skipstone);
	  window_count = g_slist_append(window_count,current_skipstone);
	}
	D_RETURN;
}

static void update_window_title(SkipStone *skipstone)
{
	gchar *t=NULL;
     	D_ENTER;
     	if (!skipstone->title || skipstone->title==NULL) D_RETURN;
     	t = g_strdup_printf("SkipStone - %s", skipstone->title);
     	gtk_window_set_title(GTK_WINDOW(main_window), t);
     	g_free(t);
     	D_RETURN;
}


static void open_in_current_window_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		open_in_current_window(NULL, skipstone);
	D_RETURN;
}

static void on_print_nb(void)
{
     SkipStone *skipstone = get_current_browser_from_notebook();
     D_ENTER;     	
     if (skipstone)
       	on_print(NULL, skipstone);
     D_RETURN;
}

static void go_home_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		go_home(NULL, skipstone);
     	D_RETURN;
}

static void on_reload_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		on_reload(NULL, skipstone);
     	D_RETURN;
}

static void on_back_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		on_back(NULL, skipstone);
	D_RETURN;
}

static void on_forward_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
	     	on_forward(NULL,skipstone);
	D_RETURN;
}

static void on_stop_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
	D_ENTER;
     	if (skipstone)
     		on_stop(NULL,skipstone);
	D_RETURN;
}

static void find_dialog_nb(void)
{
	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		find_dialog(NULL,skipstone);
	D_RETURN;
}

static void save_document_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		save_document(NULL,skipstone);
     	D_RETURN;
}

static void close_window_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
	     	close_window(NULL,skipstone);
	D_RETURN;
}

static void on_view_history_nb(void)
{
     	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)	
     		on_view_history(NULL,skipstone);
	D_RETURN;
}

static void on_view_source_nb(void)
{
	SkipStone *skipstone = get_current_browser_from_notebook();
     	D_ENTER;
     	if (skipstone)
     		on_view_source(NULL, skipstone);
     	D_RETURN;

}


void clear_variables(void)
{
     	main_window = NULL;
	main_notebook = NULL;
	accelgroup = NULL;
     	D_ENTER;	
     	if (menubar && GTK_IS_WIDGET(menubar)) 
	     	gtk_widget_destroy(menubar);
	 menubar = NULL;	
	if (bmark_toolbar_widget && GTK_IS_WIDGET(bmark_toolbar_widget))
		gtk_widget_destroy(bmark_toolbar_widget);
     	bmark_toolbar_widget = NULL;
	if (bmark_toolbar_handlebox && GTK_IS_WIDGET(bmark_toolbar_handlebox))
		gtk_widget_destroy(bmark_toolbar_handlebox);
     	bmark_toolbar_handlebox = NULL;
	if (bmark_menu_item && GTK_IS_WIDGET(bmark_menu_item)) 
		gtk_widget_destroy(bmark_menu_item);
     	bmark_menu_item = NULL;
     	g_free(skipstone);
     	skipstone = NULL;
     	if (notebook_go_menu) {
	     	if (notebook_go_menu->items) g_slist_free(notebook_go_menu->items);
	     	g_free(notebook_go_menu);
	     	notebook_go_menu = NULL;
	}
	D_RETURN;
}

SkipStone *get_current_browser_from_notebook(void)
{
     	GtkWidget *vbox;
     	SkipStone *skipstone;
     	D_ENTER;
     	vbox = gtk_notebook_get_nth_page(GTK_NOTEBOOK(main_notebook),
					      gtk_notebook_get_current_page(GTK_NOTEBOOK(main_notebook)));
	if (!vbox) D_RETURN_( NULL );
	
     	skipstone = g_object_get_data(G_OBJECT(vbox), "skipstone");
     	D_RETURN_(skipstone);
}

void detab(void)
{
     	SkipStone *skipstone;
     	gchar *title;
     	D_ENTER;
     	if (g_list_length(GTK_NOTEBOOK(main_notebook)->children) < 2) D_RETURN;
     
     	skipstone = get_current_browser_from_notebook();
     	if (!skipstone) D_RETURN;
     
	gtk_widget_hide(skipstone->vbox);
     
	title = g_strdup_printf(_("SkipStone - %s"), skipstone->title);
     	skipstone->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        skipstone_window_set_icon(skipstone->window);				  
     	gtk_window_set_policy(GTK_WINDOW(skipstone->window), TRUE, TRUE, FALSE);
     	gtk_window_set_title(GTK_WINDOW(skipstone->window), title);
	g_free(title);
     	gtk_window_set_default_size(GTK_WINDOW(skipstone->window), config.xsize, config.ysize);     	
     	g_signal_connect(G_OBJECT(skipstone->window), "destroy", G_CALLBACK(destroy_window_callback), skipstone);
     	set_selection_targets(skipstone->window, skipstone);
	
     	skipstone->menubar = gtk_menu_bar_new();
     	skipstone->menuhandlebox = gtk_handle_box_new ();
     	skipstone->accelgroup = gtk_accel_group_new ();
     	skipstone->bmarkhandlebox = gtk_handle_box_new();
     	skipstone->bookmark_toolbar = gtk_toolbar_new();
     

/*     	gtk_container_set_border_width(GTK_CONTAINER(skipstone->bookmark_toolbar),2);*/
     	gtk_window_add_accel_group(GTK_WINDOW(skipstone->window), skipstone->accelgroup);
     	
     	skipstone->is_notebook = 0;
     	make_menu(skipstone);

     
     
     	gtk_container_add(GTK_CONTAINER(skipstone->menuhandlebox), skipstone->menubar);
     	gtk_container_add(GTK_CONTAINER(skipstone->bmarkhandlebox),skipstone->bookmark_toolbar);
     	
     	gtk_widget_show_all(skipstone->menuhandlebox);
     	gtk_widget_show_all(skipstone->bmarkhandlebox);
     
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->menuhandlebox, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->bmarkhandlebox, FALSE, FALSE, 0);
     	gtk_box_reorder_child(GTK_BOX(skipstone->vbox), skipstone->menuhandlebox, 0);
     	gtk_box_reorder_child(GTK_BOX(skipstone->vbox), skipstone->bmarkhandlebox, 1);
     	gtk_widget_reparent(skipstone->vbox,skipstone->window);
     	
     	g_signal_handlers_disconnect_by_func(G_OBJECT(skipstone->vbox),
				      G_CALLBACK(skipstone_tab_destroy_cb),
				      skipstone);
     
     	gtk_widget_show(skipstone->vbox);
     	gtk_widget_show(skipstone->window);
     	skipstone->visible=1;
	g_signal_connect(G_OBJECT(skipstone->window), "size_request", G_CALLBACK(on_window_size_request), skipstone);
	D_RETURN;
}
     	
void make_notebook_window(void)
{
     	GtkWidget *vbox, *hb;
     	gchar *win_title;
     	D_ENTER;
     	win_title = g_strdup_printf ("SkipStone %d.%d.%d",SKIPSTONE_MAJOR,SKIPSTONE_MINOR, SKIPSTONE_MICRO);
     	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        skipstone_window_set_icon(main_window);
     	vbox = gtk_vbox_new(0,0);

     	gtk_window_set_policy(GTK_WINDOW(main_window), TRUE, TRUE, FALSE);
     	g_signal_connect(G_OBJECT(main_window), "destroy", G_CALLBACK(destroy_main_window), NULL);
     	set_selection_targets(main_window, NULL);
     	gtk_window_set_title(GTK_WINDOW(main_window), win_title);       
     	gtk_window_set_default_size(GTK_WINDOW(main_window), config.xsize, config.ysize);

     	accelgroup = gtk_accel_group_new();
     	gtk_window_add_accel_group(GTK_WINDOW(main_window), accelgroup);
	
     	hb = gtk_handle_box_new();
     	gtk_box_pack_start(GTK_BOX(vbox), hb, FALSE, FALSE, 0);
     	main_notebook = gtk_notebook_new();

     	gtk_notebook_set_show_border(GTK_NOTEBOOK(main_notebook), FALSE);
      	gtk_notebook_popup_enable (GTK_NOTEBOOK(main_notebook));
     	g_signal_connect(G_OBJECT(main_notebook), "switch_page", G_CALLBACK(on_notebook_switch_page), NULL); 
     	make_main_menu(vbox);     	
     	     	     	
     	gtk_container_add(GTK_CONTAINER(hb), menubar);
  
     	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(main_notebook), config.notebook_tabs_pos);
     	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), config.show_tabs);
     	gtk_notebook_set_scrollable(GTK_NOTEBOOK(main_notebook), TRUE);
     
     	gtk_box_pack_start(GTK_BOX(vbox), main_notebook, TRUE, TRUE, FALSE);
     	gtk_container_add(GTK_CONTAINER(main_window), vbox);     	
	     	   
	
     	g_free(win_title);
	D_RETURN;
}

static void destroy_main_window(GtkWidget *main_window) {
     	D_ENTER;
     	gtk_widget_destroy(main_window);	
     	quit_skipstone();
	D_RETURN;
}


GtkWidget *make_notebook_tab_widget(SkipStone *skipstone)
{
	GtkWidget *hbox, *pixmap, *button;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	D_ENTER;
     	hbox = gtk_hbox_new(0,0);
	
	button = gtk_button_new();
	gtk_button_set_relief((GtkButton *) button, GTK_RELIEF_NONE);
	
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(main_window->window,gtk_widget_get_colormap(hbox),&mask,NULL,small_close);
	if (gdkpixmap == NULL)
	    return create_dummy_pixmap(skipstone->window);
	pixmap = gtk_pixmap_new(gdkpixmap,mask);
	gdk_pixmap_unref(gdkpixmap);
	gdk_bitmap_unref(mask);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(close_window), skipstone);
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	gtk_box_pack_start(GTK_BOX(hbox), skipstone->notebook_label, TRUE, TRUE, 2);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 2);
	gtk_widget_show_all(hbox);
	D_RETURN_(hbox);
}
	  
void add_to_notebook(const gchar *url)
{


	SkipStone *skipstone;	
	static gint show = 0;
     	gint length;
     	
     	D_ENTER;
     	
	if (!main_window) {
       		make_notebook_window();
		show = 1;
	}
	
     	skipstone = new_skipstone_tab(TRUE);
	
     	g_object_set_data(G_OBJECT(skipstone->vbox), "skipstone", skipstone);

     	length = g_slist_length(window_count);

     	if (!config.show_tabs && length > 1)
       		gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), TRUE);
     
	skipstone_append_tab(skipstone);

	
	if (show) {
		gtk_widget_show_all(main_window);
		g_signal_connect(G_OBJECT(main_window), "size_request", G_CALLBACK(on_window_size_request), NULL);     
		show = 0;
	}
	
     	
	gtk_toolbar_set_style(GTK_TOOLBAR(skipstone->toolbar), config.layout);
     	gtk_widget_queue_resize(GTK_WIDGET(skipstone->handlebox));


     	
     	if (!config.navtbar) 
	     	gtk_widget_hide(skipstone->handlebox);
	
     	if (!config.bmarktbar) 
		hide_bmark_toolbar_nb();
	
     	if (!url) {
       		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), config.home);
       		on_entry(GTK_WIDGET(GTK_COMBO(skipstone->combo)->entry), skipstone);
	} else {
       	      	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), url);
              	on_entry(GTK_WIDGET(GTK_COMBO(skipstone->combo)->entry), skipstone);
	}


	D_RETURN;
}

void skipstone_append_tab(SkipStone *skipstone)
{
     	g_return_if_fail(skipstone != NULL);
     	g_return_if_fail(main_notebook != NULL);
     	g_return_if_fail(skipstone->vbox != NULL);
     	D_ENTER;
        gtk_widget_show(GTK_WIDGET(skipstone->embed));
        gtk_widget_show_all(skipstone->vbox);
     	gtk_notebook_append_page(GTK_NOTEBOOK(main_notebook), skipstone->vbox, make_notebook_tab_widget(skipstone));
     	g_signal_connect(G_OBJECT(skipstone->vbox), "destroy",
			   G_CALLBACK(skipstone_tab_destroy_cb),
			   skipstone);

     
	if (config.jump_to_new_tab) {	     	
	     	gint page_number;
	     	page_number = gtk_notebook_page_num(GTK_NOTEBOOK(main_notebook), skipstone->vbox);
	     	gtk_notebook_set_page(GTK_NOTEBOOK(main_notebook), page_number);
	}
     
	D_RETURN;
}

SkipStone *new_skipstone_tab(gboolean with_plugins)
{
     	SkipStone *skipstone;
     	GtkWidget *hbox;
     	D_ENTER;
     	skipstone = g_new0(SkipStone,1);     	
     	skipstone->handlebox = gtk_handle_box_new();
     	skipstone->vbox = gtk_vbox_new(0,0);
	skipstone->embed = GTK_MOZ_EMBED (gtk_moz_embed_new());
	/*g_object_ref(G_OBJECT(skipstone->embed));
	g_object_set_data_full(G_OBJECT(skipstone->embed),
				 "Embed",
				 GTK_WIDGET(skipstone->embed),
				 (GtkDestroyNotify)g_object_unref);*/
     	create_toolbar(skipstone,0);
     	skipstone->statusbar = gtk_statusbar_new();
     	skipstone->sbar_temp_msg_id =
	  gtk_statusbar_get_context_id(GTK_STATUSBAR(skipstone->statusbar), "statusbar temp message");
     	skipstone->sbar_status_msg_id =
	     gtk_statusbar_get_context_id(GTK_STATUSBAR(skipstone->statusbar), "statusbar persist message");
     	skipstone->progressbar = gtk_progress_bar_new();
	/* below line is to force expand now */
     	gtk_progress_set_show_text(GTK_PROGRESS(skipstone->progressbar), 1);
     	gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar), 1);

     	
	hbox = gtk_hbox_new(0,0);
     	skipstone->notebook_label = gtk_label_new("SkipStone");
     	gtk_misc_set_alignment (GTK_MISC (skipstone->notebook_label), 0.00, 0.5);
	skipstone->bookmark_toolbar = bmark_toolbar_widget;
	skipstone->bookmark_menubar_item = bmark_menu_item;

     	if (!Mozilla_Prefs) {
       		set_mozilla_prefs();
/*	     	mozilla_init_prompt_service();*/
     		Mozilla_Prefs = 1;
	}
   
     	connect_embed_signals(skipstone);
        
     	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->handlebox, FALSE, FALSE, 0);
     	
     	/* any plugins ? */
     	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_TOOLBAR);
	
	skipstone->right_of_embed_box = gtk_hbox_new(0,0);
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_RIGHT_OF_MOZEMBED);
	
	skipstone->left_of_embed_box = gtk_hbox_new(0,0);
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_LEFT_OF_MOZEMBED);
	
	skipstone->embedbox = gtk_hbox_new(0,0);
	skipstone->main_hbox = gtk_hbox_new(0,0);
	
     	gtk_box_pack_start(GTK_BOX(skipstone->embedbox), GTK_WIDGET(skipstone->embed), TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->left_of_embed_box, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->embedbox, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->main_hbox), skipstone->right_of_embed_box, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(skipstone->vbox), skipstone->main_hbox, TRUE, TRUE, 0);
	
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_MOZEMBED);
	
	gtk_box_pack_start(GTK_BOX(skipstone->vbox), hbox, FALSE, FALSE, FALSE);
     	gtk_box_pack_start(GTK_BOX(hbox), skipstone->statusbar, TRUE, TRUE, FALSE);
     	gtk_box_pack_end(GTK_BOX(hbox), skipstone->progressbar, FALSE,FALSE,FALSE);
	
	if (with_plugins) skipstone_plugin_check(skipstone, PLUGIN_AFTER_STATUSBAR);
	
     	skipstone->is_notebook = 1;
     	skipstone->visible = 1;
	skipstone->title = g_strdup(_("Untitled Document"));
     
     	window_count = g_slist_append(window_count, skipstone);

       	D_RETURN_(skipstone);
}

static void make_main_menu(GtkWidget *vbox)
{
	GtkWidget *file, *filemenu, *help, *helpmenu, *about, *find, *window_menuitem, *window_menu;
	GtkWidget *close, *new_window, *open, *openc, *sep1, *close_win, *history, *view_source;
	GtkWidget *nav,*navmenu,*back,*forw,*reload,*stop,*home;
	GtkWidget *pref, *prefmenu, *save;
	GtkWidget *toolbar, *toolbarmenu, *themes, *themes_menu;
	GtkWidget *options,*pixmap,*text,*both, *sep2, *tab, *tabmenu, *top, *buttom, *left, *right;
     	GtkWidget *cb_bmarktoolbar;
	GtkWidget *cb_navtoolbar, *switch_regular, *next, *prev, *de_tab;
	GtkWidget *use_skipstone_mime, *go_menu, *offline;
	GSList *radio_buttons = NULL;
	GSList *tab_positions = NULL;
     	GtkWidget *print, *save_session, *load_session, *encoding;
	D_ENTER;
	skipstone = g_new0(SkipStone,1);
	skipstone->is_notebook = 2;
     	menubar = gtk_menu_bar_new();
     	skipstone->accelgroup = accelgroup;
	file = gtk_menu_item_new_with_label(_("File"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), file);

	filemenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(file),filemenu);

	new_window = gtk_menu_item_new_with_label(_("New Tab"));
	g_signal_connect(G_OBJECT(new_window), "activate", G_CALLBACK(blank_new_window), NULL);
	gtk_widget_add_accelerator(new_window,"activate",accelgroup,GDK_n,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), new_window);
	
     	de_tab = gtk_menu_item_new_with_label(_("De-Tab"));
     	g_signal_connect(G_OBJECT(de_tab), "activate", G_CALLBACK(detab), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), de_tab);
	gtk_widget_add_accelerator(de_tab, "activate", accelgroup, GDK_d, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
     
     	open = gtk_menu_item_new_with_label(_("Open in a New Tab"));
	g_signal_connect(G_OBJECT(open), "activate", G_CALLBACK(open_in_new_window), NULL);
	gtk_widget_add_accelerator(open,"activate",accelgroup,GDK_o,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), open);     

	openc = gtk_menu_item_new_with_label(_("Open in Current Tab"));
	g_signal_connect(G_OBJECT(openc),"activate",G_CALLBACK(open_in_current_window_nb), NULL);
	gtk_widget_add_accelerator(openc,"activate",accelgroup,GDK_l,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu),openc);

	close_win = gtk_menu_item_new_with_label(_("Close..."));
	g_signal_connect(G_OBJECT(close_win), "activate", G_CALLBACK(close_window_nb), NULL);
	gtk_widget_add_accelerator(close_win,"activate",accelgroup,GDK_w,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), close_win);

	sep1 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(filemenu), sep1);

	save = gtk_menu_item_new_with_label(_("Save"));
     	g_signal_connect(G_OBJECT(save), "activate", G_CALLBACK(save_document_nb), NULL);
     	gtk_widget_add_accelerator(save,"activate",accelgroup,GDK_s,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(filemenu), save);
     
     	find = gtk_menu_item_new_with_label(_("Find..."));     
	g_signal_connect(G_OBJECT(find), "activate", G_CALLBACK(find_dialog_nb), NULL);
	gtk_widget_add_accelerator(find, "activate", accelgroup, GDK_i, GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), find);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);

     	save_session = gtk_menu_item_new_with_label(_("Save Session"));
     	g_signal_connect(G_OBJECT(save_session), "activate", G_CALLBACK(skipstone_save_a_session), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), save_session);
     
     	load_session = gtk_menu_item_new_with_label(_("Load Session"));
     	g_signal_connect(G_OBJECT(load_session), "activate", G_CALLBACK(skipstone_load_a_session), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), load_session);
     
	sep1 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(filemenu), sep1);

     	offline = gtk_check_menu_item_new_with_label(_("Work Offline"));
     	g_signal_connect(G_OBJECT(offline), "toggled", G_CALLBACK(on_offline_toggle_cb), NULL);
     	gtk_menu_append(GTK_MENU(filemenu), offline);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);


     	print = gtk_menu_item_new_with_label(_("Print"));
     	g_signal_connect(G_OBJECT(print), "activate", G_CALLBACK(on_print_nb), NULL);
     	gtk_widget_add_accelerator(print,"activate",accelgroup,GDK_p,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(filemenu), print);
     
     	sep1 = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(filemenu), sep1);


	close = gtk_menu_item_new_with_label(_("Exit..."));
	g_signal_connect(G_OBJECT(close), "activate", G_CALLBACK(exit_app), NULL);
	gtk_widget_add_accelerator(close,"activate",accelgroup,GDK_x,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(filemenu), close);
	
     		
	window_menuitem = gtk_menu_item_new_with_label(_("Windows"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),window_menuitem);
	window_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(window_menuitem), window_menu);
     	
     
     	view_source = gtk_menu_item_new_with_label(_("View Source"));
     	g_signal_connect(G_OBJECT(view_source), "activate", G_CALLBACK(on_view_source_nb), NULL);
     	gtk_menu_append(GTK_MENU(window_menu), view_source);
     	gtk_widget_add_accelerator(view_source,"activate",accelgroup,GDK_u,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     
     
     	history = gtk_menu_item_new_with_label(_("History"));
     	g_signal_connect(G_OBJECT(history),"activate",G_CALLBACK(on_view_history_nb),NULL);
     	gtk_menu_append(GTK_MENU(window_menu),history);
     	gtk_widget_add_accelerator(history,"activate",accelgroup,GDK_i,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	
     	next = gtk_menu_item_new_with_label(_("Next tab"));
     	g_signal_connect(G_OBJECT(next), "activate", G_CALLBACK(notebook_next), NULL);
     	gtk_widget_add_accelerator(next, "activate", accelgroup, GDK_equal,GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(window_menu), next);
     
     	prev = gtk_menu_item_new_with_label(_("Previous tab"));
     	g_signal_connect(G_OBJECT(prev), "activate", G_CALLBACK(notebook_prev), NULL);
     	gtk_widget_add_accelerator(prev, "activate", accelgroup, GDK_minus,GDK_MOD1_MASK, GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(window_menu), prev);
     
	nav = gtk_menu_item_new_with_label(_("Navigation"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),nav);

	navmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(nav),navmenu);
	
	go_menu = gtk_menu_item_new_with_label(_("Go"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), go_menu);
	notebook_go_menu = go_menu_init();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(go_menu), notebook_go_menu->menu);
	
	back = gtk_menu_item_new_with_label(_("Back"));
	g_signal_connect(G_OBJECT(back),"activate",G_CALLBACK(on_back_nb),NULL);
	gtk_widget_add_accelerator(back,"activate",accelgroup,GDK_b,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),back);

	forw = gtk_menu_item_new_with_label(_("Forward"));
	g_signal_connect(G_OBJECT(forw),"activate",G_CALLBACK(on_forward_nb),NULL);
	gtk_widget_add_accelerator(forw,"activate",accelgroup,GDK_f,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),forw);

	reload = gtk_menu_item_new_with_label(_("Reload Page"));
	g_signal_connect(G_OBJECT(reload),"activate",G_CALLBACK(on_reload_nb),NULL);
	gtk_widget_add_accelerator(reload,"activate",accelgroup,GDK_r,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),reload);

	stop = gtk_menu_item_new_with_label(_("Stop Loading"));
	g_signal_connect(G_OBJECT(stop),"activate",G_CALLBACK(on_stop_nb),NULL);
     	gtk_widget_add_accelerator(stop,"activate",accelgroup,GDK_Escape,GDK_RELEASE_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),stop);

	home = gtk_menu_item_new_with_label(_("Home"));
	g_signal_connect(G_OBJECT(home),"activate",G_CALLBACK(go_home_nb),NULL);
	gtk_widget_add_accelerator(home,"activate",accelgroup,GDK_h,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE);
	gtk_menu_append(GTK_MENU(navmenu),home);

	pref = gtk_menu_item_new_with_label(_("Preferences"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),pref);
	
	prefmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(pref),prefmenu);

	options = gtk_menu_item_new_with_label(_("Options"));	
     	g_signal_connect(G_OBJECT(options),"activate",G_CALLBACK(open_config_dialog),NULL);
	gtk_widget_add_accelerator(options,"activate",accelgroup,GDK_o,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
     	gtk_menu_append(GTK_MENU(prefmenu),options);

     	switch_regular = gtk_menu_item_new_with_label(_("Switch to windowed view"));
     	g_signal_connect(G_OBJECT(switch_regular), "activate", G_CALLBACK(switch_layouts), NULL);
     	gtk_menu_append(GTK_MENU(prefmenu), switch_regular);

	use_skipstone_mime = gtk_check_menu_item_new_with_label(_("Use SkipStone MIME?"));
	if (config.use_skipstone_mime)
	  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(use_skipstone_mime),TRUE);
	g_signal_connect(G_OBJECT(use_skipstone_mime), "toggled", G_CALLBACK(toggle_mime_handling), NULL);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(use_skipstone_mime), TRUE);
	gtk_menu_append(GTK_MENU(prefmenu), use_skipstone_mime);	
	
	sep2 = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(prefmenu), sep2);
	
	toolbar = gtk_menu_item_new_with_label(_("Toolbar"));
	gtk_menu_append(GTK_MENU(prefmenu),toolbar);

	toolbarmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(toolbar),toolbarmenu);

	pixmap = gtk_radio_menu_item_new_with_label(radio_buttons,_("Pixmaps"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(pixmap));
	g_signal_connect(G_OBJECT(pixmap),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(0));
	gtk_menu_append(GTK_MENU(toolbarmenu),pixmap);

	text = gtk_radio_menu_item_new_with_label(radio_buttons, _("Text"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(text));
	g_signal_connect(G_OBJECT(text),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(1));
	gtk_menu_append(GTK_MENU(toolbarmenu),text);

	both = gtk_radio_menu_item_new_with_label(radio_buttons, _("Both"));
	radio_buttons = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(both));
	g_signal_connect(G_OBJECT(both),"toggled",G_CALLBACK(change_layout),GINT_TO_POINTER(2));
	gtk_menu_append(GTK_MENU(toolbarmenu),both);
	
     	themes = gtk_menu_item_new_with_label(_("Themes"));
     	gtk_menu_append(GTK_MENU(prefmenu), themes);
     	
     	themes_menu = gtk_menu_new();
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(themes), themes_menu);
     
     	make_themes_menu(themes_menu);
	
     	tab = gtk_menu_item_new_with_label(_("Notebook tabs"));
     	gtk_menu_append(GTK_MENU(prefmenu), tab);
     
     	tabmenu = gtk_menu_new();
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(tab), tabmenu);
     	
     	top = gtk_radio_menu_item_new_with_label(tab_positions, _("Top"));
     	tab_positions = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(top));
     	g_signal_connect(G_OBJECT(top), "toggled", G_CALLBACK(change_tab_pos), GINT_TO_POINTER(2));
     	gtk_menu_append(GTK_MENU(tabmenu), top);
     
     	buttom = gtk_radio_menu_item_new_with_label(tab_positions, _("Bottom"));
     	tab_positions = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(buttom));
     	g_signal_connect(G_OBJECT(buttom), "toggled", G_CALLBACK(change_tab_pos), GINT_TO_POINTER(3));
     	gtk_menu_append(GTK_MENU(tabmenu), buttom);
     	
     	left = gtk_radio_menu_item_new_with_label(tab_positions, _("Left"));
     	tab_positions = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(left));
     	g_signal_connect(G_OBJECT(left), "toggled", G_CALLBACK(change_tab_pos), GINT_TO_POINTER(4));
     	gtk_menu_append(GTK_MENU(tabmenu), left);
     	
     	right = gtk_radio_menu_item_new_with_label(tab_positions, _("Right"));
     	tab_positions = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(right));
     	g_signal_connect(G_OBJECT(right), "toggled", G_CALLBACK(change_tab_pos), GINT_TO_POINTER(1));
     	gtk_menu_append(GTK_MENU(tabmenu), right);

     	encoding = gtk_menu_item_new_with_label(_("Encoding"));
     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(encoding), skipstone_get_encoding_menu(NULL));
     	gtk_menu_append(GTK_MENU(prefmenu), encoding);         
     

	cb_bmarktoolbar = gtk_check_menu_item_new_with_label(_("Hide Bookmark toolbar"));
     	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(cb_bmarktoolbar), TRUE);
     	gtk_menu_append(GTK_MENU(prefmenu), cb_bmarktoolbar);

    	cb_navtoolbar = gtk_check_menu_item_new_with_label(_("Hide Navigation toolbar"));
     	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(cb_navtoolbar), TRUE);
     	g_signal_connect(G_OBJECT(cb_navtoolbar), "toggled", G_CALLBACK(hide_navigation_toolbar), NULL);
     	gtk_menu_append(GTK_MENU(prefmenu), cb_navtoolbar);


	skipstone->bookmark_toolbar = bmark_toolbar_widget =gtk_toolbar_new();

/*     	gtk_container_set_border_width(GTK_CONTAINER(skipstone->bookmark_toolbar),2);*/
     	
     	skipstone->bmarkhandlebox = gtk_handle_box_new();
	gtk_container_add(GTK_CONTAINER(skipstone->bmarkhandlebox),skipstone->bookmark_toolbar);
     	gtk_widget_show(skipstone->bookmark_toolbar);
	gtk_box_pack_start(GTK_BOX(vbox), skipstone->bmarkhandlebox,FALSE,FALSE,0);
	g_signal_connect(G_OBJECT(cb_bmarktoolbar), "toggled", G_CALLBACK(hide_bookmark_toolbar_notebook),skipstone->bmarkhandlebox);
	bmark_toolbar_handlebox = skipstone->bmarkhandlebox;

    	skipstone->bookmark_menubar_item = bmark_menu_item = gtk_menu_item_new_with_label(_("Bookmarks"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar),skipstone->bookmark_menubar_item);

	generate_bookmark_ui(skipstone);

     	help = gtk_menu_item_new_with_label(_("Help"));
	gtk_menu_bar_append(GTK_MENU_BAR(menubar), help);

	helpmenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(help),helpmenu);
	
	about = gtk_menu_item_new_with_label(_("About SkipStone"));
     	g_signal_connect(G_OBJECT(about), "activate", G_CALLBACK(about_skipstone), NULL);
	gtk_menu_append(GTK_MENU(helpmenu), about);

	gtk_widget_show_all(menubar);
     
	if (config.layout == 0) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(pixmap),TRUE);
	} else if (config.layout == 1) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(text),TRUE);
	} else {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(both),TRUE);
	}
       	if (config.bmarktbar == 0) {
	     	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(cb_bmarktoolbar),TRUE);
	} 

	if (config.navtbar == 0) {
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(cb_navtoolbar),TRUE);
	}
	
     	switch(config.notebook_tabs_pos) {
	 	case 1:
	     		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(right), TRUE);
	 		break;
	 	case 2:
	     		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(top), TRUE);
	     		break;
	 	case 3:
	     		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(buttom), TRUE);
	     		break;
	 	case 4:
	     		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(left), TRUE);
	     		break;
	 	default:
	     	break;
	}
	D_RETURN;
}

void hide_bmark_toolbar_nb(void)
{
     D_ENTER;
     gtk_widget_hide(bmark_toolbar_handlebox);
     D_RETURN;
}

static void hide_bookmark_toolbar_notebook(GtkCheckMenuItem *cb_menuitem,GtkWidget *handlebox) {
	D_ENTER;
     	if (cb_menuitem->active) {
	     	gtk_widget_hide(handlebox);
		config.bmarktbar = 0;
     	} else {
		gtk_widget_show(handlebox);
		config.bmarktbar = 1;
	}

	D_RETURN;
}

static void change_tab_pos(GtkWidget *menu_item, gpointer data)
{
     	D_ENTER;
     	config.notebook_tabs_pos = GPOINTER_TO_INT(data);
     	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(main_notebook), config.notebook_tabs_pos);
	D_RETURN;
}

static void notebook_prev(void)
{
     	D_ENTER;
     	gtk_notebook_prev_page(GTK_NOTEBOOK(main_notebook));
	D_RETURN;
}

static void notebook_next(void)
{
     	D_ENTER;
     	gtk_notebook_next_page(GTK_NOTEBOOK(main_notebook));
	D_RETURN;
}

static void skipstone_tab_destroy_cb(GtkWidget *widget, SkipStone *skipstone)
{

     	gint length;
     	D_ENTER;
     	g_return_if_fail(skipstone != NULL);

     
     	window_count = g_slist_remove(window_count, skipstone);

     	if (skipstone->title) g_free(skipstone->title);
     	g_free(skipstone);
     	length = g_slist_length(window_count);

     	if (length == 0) {
	     	quit_skipstone();
	} else if (!config.show_tabs && length == 1) {
	     	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), FALSE);
	}

	D_RETURN;
}
