/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"

static void clear_history(GtkWidget *b, GtkWidget *clist);
static void close_history_win(GtkWidget *button, GtkWidget *window);
static void on_history_clist_button_press_event(GtkWidget *clist,GdkEventButton *event,SkipStone *skipstone);
static void remove_from_history(GtkWidget *button, GtkWidget *clist);
static void remove_from_list(gchar *text);
static void load_from_popup(GtkWidget *w, SkipStone *skipstone);
static void on_history_destroy(GtkWidget *window);
static void on_search_entry_activate(GtkWidget *entry, GtkWidget *clist);
static GtkWidget *popup_menu(GtkWidget *clist, SkipStone *skipstone, gchar *location);

static gint prot = 0;
static gint search_pos = 0;
GSList *history = NULL;
static GtkWidget *history_window=NULL;

void add_to_history(gchar *url) {
	GSList *list;
	D_ENTER;
     	if (!url || url == NULL) D_RETURN;
	if (!g_strncasecmp(url,"about:",6) || !g_strcasecmp(url,"")) D_RETURN;
       
	while (prot == 1) {
	}	

	prot = 1;

	for (list = history; list ; list = list->next) {
		if (g_strcasecmp(list->data,url) == 0) {
			prot = 0;
			D_RETURN;
		}
	}
	history = g_slist_prepend(history,g_strdup(url));
	prot = 0;
	write_history();
	D_RETURN;
}

void on_view_history(GtkWidget *widget,SkipStone *skipstone) {
	GtkWidget *window;
	GtkWidget *scrolled_window;
	GtkWidget *clist;
	GtkWidget *vbox;
	GtkWidget *remove, *close, *btnbox, *clear;
     	GtkWidget *search_label, *search_entry, *search_box;
     	GSList *list;
	gchar *title;
     
     	D_ENTER;
        if (history_window) {
	     gdk_window_raise(history_window->window);
	     D_RETURN;
	}
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        skipstone_window_set_icon(window);
     	setup_escape_key_handler(window);
     	g_signal_connect(G_OBJECT(window),"destroy", 
			   G_CALLBACK(on_history_destroy), NULL);
	title = g_strdup_printf(_("SkipStone - History (%d) items"), g_slist_length(history));
     	gtk_window_set_title(GTK_WINDOW(window),title);
     	gtk_window_set_default_size(GTK_WINDOW(window),300,300);
	g_free(title);
     
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(window),vbox);

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,TRUE,TRUE,0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	
     	
	clist = gtk_clist_new(1);

	gtk_container_add(GTK_CONTAINER(scrolled_window),clist);
	g_signal_connect(G_OBJECT(clist),"button_press_event",G_CALLBACK(on_history_clist_button_press_event),skipstone);
	
     	search_label = gtk_label_new(_("Search: "));
     	search_entry = gtk_entry_new();
     	search_box = gtk_hbox_new(0,0);
     
     	g_signal_connect(G_OBJECT(search_entry), "activate", 
			   G_CALLBACK(on_search_entry_activate),
			   clist);
     
     	gtk_box_pack_start(GTK_BOX(search_box), search_label, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(search_box), search_entry, TRUE, TRUE, 0);
       
     
     	remove = gtk_button_new_with_label(_("Remove"));
     	g_signal_connect(G_OBJECT(remove), "clicked", G_CALLBACK(remove_from_history), clist);
 	
     	clear = gtk_button_new_with_label(_("Clear All"));
     	g_signal_connect(G_OBJECT(clear), "clicked", G_CALLBACK(clear_history), clist);
     	
     	close = gtk_button_new_with_label(_("Close"));
     	g_signal_connect(G_OBJECT(close), "clicked", G_CALLBACK(close_history_win), window);
     	btnbox = gtk_hbox_new(0,0);
	
     	gtk_box_pack_start(GTK_BOX(vbox), search_box, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(vbox), btnbox, FALSE, FALSE, 0);
     	gtk_box_pack_start(GTK_BOX(btnbox), remove, TRUE, TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(btnbox), clear, TRUE, TRUE, 0);
     	gtk_box_pack_start(GTK_BOX(btnbox), close, TRUE, TRUE, 0);

     
	while (prot == 1) {
	}	

	prot = 1;
	for (list = history; list ; list = list->next) {
		gchar *clist_entry[1];
		clist_entry[0] = (gchar *)list->data;
		gtk_clist_append(GTK_CLIST(clist),clist_entry);
	}
	prot = 0;
        history_window=window;
	gtk_widget_show_all(window);
	D_RETURN;
}


static void on_history_clist_button_press_event(GtkWidget *clist,GdkEventButton *event,SkipStone *skipstone) {
	GList *selection;
	D_ENTER;
	selection = GTK_CLIST(clist)->selection;

	if (g_list_length(selection) == 0)  D_RETURN;
	

	if (event->type == GDK_2BUTTON_PRESS) {
		gchar *location;
		gint row;

		row = (gint)g_list_nth_data(selection,0);
		
		gtk_clist_get_text(GTK_CLIST(clist),row,0,&location);

		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry),location);
		_skipstone_load_url(skipstone,location);

	} else if (event->button == 3) {
		gchar *location;
		gint row;

		row = (gint)g_list_nth_data(selection,0);
		
		gtk_clist_get_text(GTK_CLIST(clist),row,0,&location);
	     	
	     	gtk_menu_popup(GTK_MENU(popup_menu(clist,skipstone,location)), NULL, NULL,NULL,NULL,GDK_BUTTON3_MASK,gtk_get_current_event_time());
	}
	D_RETURN;
}


static void close_history_win(GtkWidget *button, GtkWidget *window)
{
     	D_ENTER;
     	gtk_widget_destroy(window);
     	D_RETURN;
}

static void remove_from_history(GtkWidget *button, GtkWidget *clist)
{
     	GList *selection = GTK_CLIST(clist)->selection;
	gchar *text;
     	gint row;

     	D_ENTER;
     	
     	if (selection == NULL) D_RETURN;
		     	
     	gtk_clist_freeze(GTK_CLIST(clist));
     	row = (gint) g_list_nth_data(selection,0);
        gtk_clist_get_text(GTK_CLIST(clist), row, 0, &text);
     	remove_from_list(text);
     	gtk_clist_remove(GTK_CLIST(clist), row);	
		  
      	gtk_clist_thaw(GTK_CLIST(clist));
     	D_RETURN;
}
	     
     	
static void remove_from_list(gchar *text)
{
     	GSList *l;
     	D_ENTER;
     	for (l = history; l ; l = l->next) {
	     	gchar *data = l->data;
	     	if (!strcmp(text,data)) {
		     	history = g_slist_remove(history,data);
		     	write_history();
		     	D_RETURN;
		}
	}
     	D_RETURN;
}
	      
static void clear_history(GtkWidget *b, GtkWidget *clist)
{
     	D_ENTER;
     	gtk_clist_clear(GTK_CLIST(clist));
     	g_slist_free(history);
     	history = NULL;
     	write_history();
     	D_RETURN;
}

static GtkWidget *popup_menu(GtkWidget *clist, SkipStone *skipstone, gchar *location) {
     	GtkWidget *menu, *m1, *m2, *m3, *m4;
     	D_ENTER;
     	menu = gtk_menu_new();
     	m1 = gtk_menu_item_new_with_label(_("Open ..."));
     	g_object_set_data(G_OBJECT(m1), "location", location);
     	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(load_from_popup), skipstone);
     	m2 = gtk_menu_item_new_with_label(_("Open in a new window ..."));
     	g_object_set_data(G_OBJECT(m2), "location", location);
     	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(load_from_popup), NULL);
     	m3 = gtk_menu_item_new_with_label(_("Copy link location ..."));
     	g_object_set_data(G_OBJECT(m3), "link", location);
     	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(copy_link_from_popup), skipstone);     	
     	m4 = gtk_menu_item_new_with_label(_("Remove"));
     	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(remove_from_history), clist);
     	gtk_menu_append(GTK_MENU(menu), m1);
     	gtk_menu_append(GTK_MENU(menu), m2);
     	gtk_menu_append(GTK_MENU(menu), m3);
     	gtk_menu_append(GTK_MENU(menu), m4);
     	gtk_widget_show_all(menu);
     	D_RETURN_ ( menu );
}
					  
static void load_from_popup(GtkWidget *w, SkipStone *skipstone) 
{
     	gchar *url;
     	D_ENTER;
     	url= g_object_get_data(G_OBJECT(w), "location");
     	if (skipstone) 
	     	_skipstone_load_url(skipstone, url);
	else
       		make_window(url);
     	D_RETURN;
}

static void on_search_entry_activate(GtkWidget *entry, GtkWidget *clist)
{
     	gint rows, i;
      	G_CONST_RETURN gchar *search_text;
     	D_ENTER;
     	rows = GTK_CLIST(clist)->rows;
     	if (!rows) D_RETURN;
     	search_text = gtk_entry_get_text(GTK_ENTRY(entry));
     	if (!search_text || !strcmp(search_text,"")) D_RETURN;
     	if (search_pos >= rows) search_pos = 0;
     	if (search_pos) search_pos++;
     	for (i = search_pos; i < rows ; i++) {
	     	gchar *tmp, *tmp2 = NULL;
	     	gtk_clist_get_text(GTK_CLIST(clist),
				   i,
				   0,
				   &tmp);
	     	g_return_if_fail(tmp != NULL);
	     	tmp2 = strstr(tmp,search_text);
	     	if (tmp2 != NULL) {
		     	gtk_clist_moveto(GTK_CLIST(clist),
					 i,
					 0,
					 0.0,
					 0.0);
		     	gtk_clist_select_row(GTK_CLIST(clist), i, 0);
		     	GTK_CLIST(clist)->focus_row = i;
		     	search_pos = i;
		     	D_RETURN;
		}	       		     	

	}
	D_RETURN;				   
}

static void on_history_destroy(GtkWidget *window)
{
     D_ENTER;
     search_pos = 0;
     history_window=NULL;
     D_RETURN;
}
