/* copyright    Maher Awamy <muhri@muhri.net>           *
 *              Charlie Schmidt <ishamael@themes.org>   *
 *                                                      *
 *  released under the GPL                              */

#include "encoding.h"

static void skipstone_force_charset(GtkWidget *menuitem,SkipStone *skipstone);

GtkWidget *skipstone_get_encoding_menu(SkipStone *skipstone)
{
     	GtkWidget *retmenu, *item, *real_return = NULL;
     	gint i,j;

     	D_ENTER;
     	
     	j=0;
     	retmenu = gtk_menu_new();
	real_return = retmenu;
     	for (i = 0; default_charset_settings[i] != NULL; ++i) {
	     	item = gtk_menu_item_new_with_label(_(default_charset_settings[i]));
	     	g_object_set_data(G_OBJECT(item), "charset", default_charset_names[i]);
	     	g_signal_connect(G_OBJECT(item), "activate",
				   G_CALLBACK(skipstone_force_charset), skipstone);
	     	gtk_menu_append(GTK_MENU(retmenu),item);
	     	j++;
	     	if (j == 14) {
		     	GtkWidget *new_retmenu = gtk_menu_new();
		     	item = gtk_menu_item_new_with_label(_("More ..."));
		     	gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), new_retmenu);
		     	gtk_menu_append(GTK_MENU(retmenu), item);
		     	retmenu = new_retmenu;
		     	j=0;
		}	  
	}
     	gtk_widget_show_all(real_return);
     	D_RETURN_( real_return );
}

static void skipstone_force_charset(GtkWidget *item, SkipStone *skipstone)
{
	gchar *charset=NULL;
	gboolean result = FALSE;
	D_ENTER;
     	charset = g_object_get_data(G_OBJECT(item), "charset");
     	g_return_if_fail(charset != NULL);
     	if (!skipstone) skipstone = get_current_browser_from_notebook();
     	g_return_if_fail(skipstone != NULL);
     	result = mozilla_force_charset(skipstone->embed,charset);
     	if (!result) {
	     	skipstone_error_dialog(_("Error!"),_("Failed to set Charset"),FALSE);
	     	D_RETURN;
	}
     	on_reload(NULL,skipstone);
     	D_RETURN;
}
