/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/

#include "skipstone.h"

static void on_menu_destroy(GtkWidget *menu, gchar *name);

static void on_menu_destroy(GtkWidget *menu, gchar *name)
{
     gchar *free_href, *free_img, *free_linktext, *free_name;
     D_ENTER;
     free_href = g_object_get_data(G_OBJECT(menu), "freehref");
     if (free_href) g_free(free_href);
     free_img = g_object_get_data(G_OBJECT(menu), "freeimg");
     if (free_img) g_free(free_img);
     free_linktext = g_object_get_data(G_OBJECT(menu), "freelinktext");
     if (free_linktext) g_free(free_linktext);
     free_name = g_object_get_data(G_OBJECT(menu), "freename");
     if (free_name) g_free(free_name);
     D_RETURN;
}


GtkWidget * get_link_popup_menu(SkipStone *skipstone, gchar *href, gchar *linktext)
{
     	GtkWidget *menu, *m1,*m2,*m3, *m4, *m5;
     	D_ENTER;
     	if (skipstone->link_menu) gtk_widget_destroy(skipstone->link_menu);
     	menu = gtk_menu_new();
     	g_object_set_data(G_OBJECT(menu), "freehref", href);
     	g_object_set_data(G_OBJECT(menu), "freelinktext", linktext);
     	g_signal_connect(G_OBJECT(menu), "destroy", G_CALLBACK(on_menu_destroy), (gpointer)"link menu");
     	m1 = gtk_menu_item_new_with_label(_("Open in this Window"));
     	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(browse_in_window_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m1), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m1);
     	m2 = gtk_menu_item_new_with_label(_("Open in a new Window"));
     	gtk_menu_append(GTK_MENU(menu), m2);
     	g_object_set_data(G_OBJECT(m2), "link", href);
     	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(make_window_from_popup), skipstone);
     	m3  = gtk_menu_item_new_with_label(_("Download Link..."));
     	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(download_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m3), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m3);
     	m4 = gtk_menu_item_new_with_label(_("Copy Link location"));
     	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(copy_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m4), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m4);
     	m5 = gtk_menu_item_new_with_label(_("Add bookmark for link"));
     	g_object_set_data(G_OBJECT(m5), "link", href);
     	g_object_set_data(G_OBJECT(m5), "linktext", linktext);
     	g_signal_connect(G_OBJECT(m5), "activate", G_CALLBACK(add_link_from_popup), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m5);
     	gtk_widget_show_all(menu);
     	skipstone->link_menu = menu;
     	D_RETURN_ (menu);
             
}

GtkWidget * get_image_popup_menu(SkipStone *skipstone, gchar *img)
{
     	GtkWidget *menu, *m1,*m2,*m3, *m4;
     	gchar *lbl, *name;
        G_CONST_RETURN gchar *img_basename;
     
     	D_ENTER;
        if (skipstone->image_menu) gtk_widget_destroy(skipstone->image_menu);
     	img_basename = g_basename(img);
        name = g_strdup(img_basename);
     	menu = gtk_menu_new();
     	g_object_set_data(G_OBJECT(menu), "freeimg", img);
        g_object_set_data(G_OBJECT(menu), "freename", name);
     	g_signal_connect(G_OBJECT(menu), "destroy", G_CALLBACK(on_menu_destroy), "image menu");
     	m1 = gtk_menu_item_new_with_label(_("Open Image in this Window"));
     	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(browse_in_window_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m1), "link", img);
     	gtk_menu_append(GTK_MENU(menu), m1);
     	m2 = gtk_menu_item_new_with_label(_("Open Image in a new Window"));
     	gtk_menu_append(GTK_MENU(menu), m2);
     	g_object_set_data(G_OBJECT(m2), "link", img);
     	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(make_window_from_popup), skipstone);
     	lbl = g_strdup_printf("%s... (%s)",_("Save Image"),img_basename);
     	m3  = gtk_menu_item_new_with_label(lbl);
     	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(save_image_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m3), "link", img);
     	g_object_set_data(G_OBJECT(m3), "name", name);
     	gtk_menu_append(GTK_MENU(menu), m3);
     	m4 = gtk_menu_item_new_with_label(_("Copy Image location"));	
     	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(copy_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m4), "link", img);
     	gtk_menu_append(GTK_MENU(menu), m4);
     	gtk_widget_show_all(menu);
     	g_free(lbl);
     	skipstone->image_menu = menu;
     	D_RETURN_(menu);
}


GtkWidget * get_doc_popup_menu(SkipStone *skipstone, gchar *href)
{
     	GtkWidget *menu, *m1,*m2,*m3, *m4, *m5, *m6, *m7;
     	D_ENTER;

     	if (skipstone->doc_menu) gtk_widget_destroy(skipstone->doc_menu);
     	menu = gtk_menu_new();
     	g_object_set_data(G_OBJECT(menu), "freehref", href);
     	g_signal_connect(G_OBJECT(menu), "destroy", G_CALLBACK(on_menu_destroy), "doc menu"									   );
     	m1 = gtk_menu_item_new_with_label(_("Back"));
     	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(on_back), skipstone);
     	gtk_widget_set_sensitive(m1, gtk_moz_embed_can_go_back(skipstone->embed));
     
     	gtk_menu_append(GTK_MENU(menu), m1);
     	m2 = gtk_menu_item_new_with_label(_("Forward"));	
     	gtk_menu_append(GTK_MENU(menu), m2);
     	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(on_forward), skipstone);
     	gtk_widget_set_sensitive(m2, gtk_moz_embed_can_go_forward(skipstone->embed));
          	          		     	
     	m3  = gtk_menu_item_new_with_label(_("Reload"));	
     	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(on_reload), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m3);

     	m4 = gtk_menu_item_new_with_label(_("Stop"));
     	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(on_stop), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m4);
     
     	m5 = gtk_menu_item_new_with_label(_("Find"));
     	g_signal_connect(G_OBJECT(m5), "activate", G_CALLBACK(find_dialog), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m5);
     
     	m6 = gtk_menu_item_new_with_label(_("Add Bookmark"));
     	g_signal_connect(G_OBJECT(m6), "activate", G_CALLBACK(add_bookmark), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m6);
     
     	m7 = gtk_menu_item_new_with_label(_("View Source"));	
     	g_signal_connect(G_OBJECT(m7), "activate", G_CALLBACK(on_view_source), skipstone);
     	gtk_menu_append(GTK_MENU(menu), m7);     
     
     	gtk_widget_show_all(menu);
     	skipstone->doc_menu = menu;
     	D_RETURN_ ( menu );
             
}

GtkWidget * get_link_image_popup_menu(SkipStone *skipstone, gchar *img, gchar *href)
{
     	GtkWidget *menu, *m1,*m2,*m3, *m4, *sep, *m5, *m6, *m7, *m8;
     	gchar *lbl, *name;
        G_CONST_RETURN gchar *img_basename;
     	D_ENTER;

     	if (skipstone->image_link_menu) gtk_widget_destroy(skipstone->image_link_menu);
     	img_basename = g_basename(img);
     	menu = gtk_menu_new();
        name = g_strdup(img_basename);
     	g_object_set_data(G_OBJECT(menu), "freehref", href);
     	g_object_set_data(G_OBJECT(menu), "freeimg", img);
        g_object_set_data(G_OBJECT(menu), "freename", name);
     	g_signal_connect(G_OBJECT(menu), "destroy", G_CALLBACK(on_menu_destroy), "link image menu");
     	m1 = gtk_menu_item_new_with_label(_("Open Image in this Window"));
     	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(browse_in_window_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m1), "link", img);	     
     	gtk_menu_append(GTK_MENU(menu), m1);
             
     	m2 = gtk_menu_item_new_with_label(_("Open Image in a new Window"));
     	gtk_menu_append(GTK_MENU(menu), m2);
     	g_object_set_data(G_OBJECT(m2), "link", img);
     	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(make_window_from_popup), skipstone);
     	
     	lbl = g_strdup_printf("%s... (%s)",_("Save Image"),img_basename);
     	m3  = gtk_menu_item_new_with_label(lbl);
     	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(save_image_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m3), "link", img);
     	g_object_set_data(G_OBJECT(m3), "name", name);
     	gtk_menu_append(GTK_MENU(menu), m3);
     	     
     	m4 = gtk_menu_item_new_with_label(_("Copy Image location"));
     	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(copy_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m4), "link", img);
     	gtk_menu_append(GTK_MENU(menu), m4);

     	sep = gtk_menu_item_new();
     	gtk_menu_append(GTK_MENU(menu), sep);
     
     	m5 = gtk_menu_item_new_with_label(_("Open in this Window"));
     	g_signal_connect(G_OBJECT(m5), "activate", G_CALLBACK(browse_in_window_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m5), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m5);
             
     	m6 = gtk_menu_item_new_with_label(_("Open in a new Window"));
     	gtk_menu_append(GTK_MENU(menu), m6);
     	g_object_set_data(G_OBJECT(m6), "link", href);
     	g_signal_connect(G_OBJECT(m6), "activate", G_CALLBACK(make_window_from_popup), skipstone);

     	m7 = gtk_menu_item_new_with_label(_("Download Link"));
     	g_signal_connect(G_OBJECT(m7), "activate", G_CALLBACK(download_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m7), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m7);
     
     	m8 = gtk_menu_item_new_with_label(_("Copy Link location"));
     	g_signal_connect(G_OBJECT(m8), "activate", G_CALLBACK(copy_link_from_popup), skipstone);
     	g_object_set_data(G_OBJECT(m8), "link", href);
     	gtk_menu_append(GTK_MENU(menu), m8);
     
     	gtk_widget_show_all(menu);
     	skipstone->image_link_menu = menu;
     	D_RETURN_ ( menu );
}

GtkWidget * get_reload_menu(SkipStone *skipstone)
{
	GtkWidget *m1,*m2,*m3, *m4;
     	D_ENTER;
	if (skipstone->reload_menu != NULL) D_RETURN_ (skipstone->reload_menu);

	skipstone->reload_menu = gtk_menu_new();
	m1 = gtk_menu_item_new_with_label(_("Reload Normal"));
	g_signal_connect(G_OBJECT(m1), "activate", G_CALLBACK(on_reload_popup_menu_selection_made), skipstone);
	g_object_set_data(G_OBJECT(m1), "reload_flag", GINT_TO_POINTER(0));
	gtk_menu_append(GTK_MENU(skipstone->reload_menu), m1);
	
	m2 = gtk_menu_item_new_with_label(_("Reload by passing Cache (shift - click)"));
	gtk_menu_append(GTK_MENU(skipstone->reload_menu), m2);
	g_object_set_data(G_OBJECT(m2), "reload_flag", GINT_TO_POINTER(1));
	g_signal_connect(G_OBJECT(m2), "activate", G_CALLBACK(on_reload_popup_menu_selection_made), skipstone);
	
	m3  = gtk_menu_item_new_with_label(_("Reload by passing Proxy"));
	g_signal_connect(G_OBJECT(m3), "activate", G_CALLBACK(on_reload_popup_menu_selection_made), skipstone);
	g_object_set_data(G_OBJECT(m3), "reload_flag", GINT_TO_POINTER(2));
	gtk_menu_append(GTK_MENU(skipstone->reload_menu), m3);
	
	m4 = gtk_menu_item_new_with_label(_("Reload by passing Proxy & Cache"));
	g_signal_connect(G_OBJECT(m4), "activate", G_CALLBACK(on_reload_popup_menu_selection_made), skipstone);
	g_object_set_data(G_OBJECT(m4), "reload_flag", GINT_TO_POINTER(3));
	gtk_menu_append(GTK_MENU(skipstone->reload_menu), m4);
	
	gtk_widget_show_all(skipstone->reload_menu);
	D_RETURN_(skipstone->reload_menu);
             
}
