
/* copyright 	Maher Awamy <muhri@muhri.net>		*
 *		Charlie Schmidt <ishamael@themes.org>	*
 *							*
 *  released under the GPL				*/


#include "skipstone.h"

static void close_dialog(GtkWidget *button,DialogData *ddata);
static void destroy_dialog(GtkWidget *dialog,DialogData *ddata);
static void on_url_entry_ok(GtkWidget *button,DialogData *ddata);
static void on_url_entry_ok_current(GtkWidget *button,DialogData *ddata);
static void close_generic_dialog(GtkWidget *button, GtkWidget *dialog);
static void on_save_ok(GtkWidget *button, GtkWidget *fs);
static void on_save_image_ok(GtkWidget *button, GtkWidget *fs);
static void on_save_cancel(GtkWidget *button, GtkWidget *fs);
static void switch_from_notebook_to_regular();
static void switch_from_regular_to_notebook();


extern GSList *window_count;
extern ConfigData config;
extern GList *combo_urls;
extern GtkWidget *main_notebook; 
extern GtkWidget *main_window;
extern gchar *app_path;
extern gchar *home;
extern GSList *prefixes;

gchar *last_find = NULL;

void blank_new_window(GtkWidget *menuitem,gpointer data) 
{
     	D_ENTER;
	make_window(NULL);
/*	make_real_window(NULL); */
	D_RETURN;
}


void open_in_new_window(GtkWidget *menuitem,gpointer data) 
{
	DialogData *ddata;
	GtkWidget *ok, *cancel, *label;
	D_ENTER;
	ddata = g_new0(DialogData,1);
	ddata->dialog = gtk_dialog_new();
        skipstone_window_set_icon(ddata->dialog);
     	setup_escape_key_handler(ddata->dialog);
	gtk_window_set_title(GTK_WINDOW(ddata->dialog), _("Open url in a new window"));
	gtk_window_set_default_size(GTK_WINDOW(ddata->dialog), 250,70);
	gtk_window_set_position(GTK_WINDOW(ddata->dialog), GTK_WIN_POS_MOUSE);
	g_signal_connect(G_OBJECT(ddata->dialog), "destroy", G_CALLBACK(destroy_dialog), ddata);
	ddata->entry = gtk_combo_new();     
        gtk_combo_disable_activate(GTK_COMBO(ddata->entry));
        gtk_combo_set_popdown_strings(GTK_COMBO(ddata->entry),combo_urls);

	label = gtk_label_new(_("Enter URL:"));
	ok = gtk_button_new_with_label (_("Ok"));
	cancel = gtk_button_new_with_label(_("Cancel"));

	g_signal_connect(G_OBJECT(ok), "clicked", G_CALLBACK(on_url_entry_ok), ddata);
	g_signal_connect(G_OBJECT(GTK_COMBO(ddata->entry)->entry), "activate", G_CALLBACK(on_url_entry_ok), ddata);

	g_signal_connect(G_OBJECT(cancel), "clicked", G_CALLBACK(close_dialog), ddata);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->vbox), label, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->vbox), ddata->entry, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->action_area), ok, TRUE, TRUE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->action_area), cancel, TRUE, TRUE, FALSE);
   
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(ddata->entry)->entry), "");
	gtk_widget_show_all(ddata->dialog);
	gtk_widget_grab_focus(GTK_COMBO(ddata->entry)->entry);

	D_RETURN;
}

static void close_dialog(GtkWidget *button, DialogData *ddata)
{
     	D_ENTER;
     	gtk_widget_destroy(ddata->dialog);
	D_RETURN;
}

void open_in_current_window(GtkWidget *menuitem,SkipStone *skipstone) 
{
	DialogData *ddata;
	GtkWidget *ok, *cancel, *label;
	D_ENTER;
     	
     	if (config.navtbar == 1) { /* if the navigation toolbar is on, just grab the entry, otherwise show the dialog */
	     	gtk_entry_select_region(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry), 0, -1);
	     	gtk_widget_grab_focus(GTK_WIDGET(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry)));
		D_RETURN;
	}
				
	ddata = g_new0(DialogData,1);
	ddata->dialog = gtk_dialog_new();
        skipstone_window_set_icon(ddata->dialog);
     	setup_escape_key_handler(ddata->dialog);
	gtk_window_set_title(GTK_WINDOW(ddata->dialog), _("Open url in current window"));
	gtk_window_set_default_size(GTK_WINDOW(ddata->dialog), 250,70);
	gtk_window_set_position(GTK_WINDOW(ddata->dialog), GTK_WIN_POS_MOUSE);
	g_signal_connect(G_OBJECT(ddata->dialog), "destroy", G_CALLBACK(destroy_dialog), ddata);
	ddata->entry = gtk_entry_new();
	g_object_set_data(G_OBJECT(ddata->entry),"skipstone",skipstone);
	label = gtk_label_new(_("Enter URL:"));
	ok = gtk_button_new_with_label (_("Ok"));
	g_object_set_data(G_OBJECT(ok),"skipstone",skipstone);
	cancel = gtk_button_new_with_label(_("Cancel"));

	g_signal_connect(G_OBJECT(ok), "clicked", G_CALLBACK(on_url_entry_ok_current), ddata);
	g_signal_connect(G_OBJECT(ddata->entry), "activate", G_CALLBACK(on_url_entry_ok_current), ddata);
	g_signal_connect(G_OBJECT(cancel), "clicked", G_CALLBACK(close_dialog), ddata);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->vbox), label, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->vbox), ddata->entry, FALSE, FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->action_area), ok, TRUE, TRUE, FALSE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG (ddata->dialog)->action_area), cancel, TRUE, TRUE, FALSE);

	gtk_widget_show_all(ddata->dialog);
	gtk_widget_grab_focus(ddata->entry);

	D_RETURN;
}

void close_window(GtkWidget *menuitem,SkipStone *skipstone) 
{

     	D_ENTER;

         if (!skipstone || skipstone == NULL) {
	      g_print("null skipstone %p\n",skipstone);
	      return;
	 }
     	gtk_moz_embed_stop_load(skipstone->embed);
     	if (skipstone->progressbar) {
     		gtk_progress_set_activity_mode(GTK_PROGRESS(skipstone->progressbar),0);
	}
	if (skipstone->timer) {
		gtk_timeout_remove(skipstone->timer);
	     	skipstone->timer=0;
	}

     	if (skipstone->is_notebook) {
	        if (config.tabs_in_focus_order) {
		  /* DBMK if this is current tab switch page
		     to previously focused tab if there is one
		     (done like this because chrome windows
		     and orphan windows are in window_count
		     - they are not tabs) */
		  SkipStone *tmp_ss;
		  gint w_c;
		  gint page_number;
		  if (skipstone == get_current_browser_from_notebook()) {
		    w_c = g_slist_index(window_count, skipstone);
		    for (w_c-- ; w_c >= 0 ; w_c--)
		      {
			tmp_ss = g_slist_nth_data (window_count, w_c);	
			if (tmp_ss->is_notebook)
			  {
			    page_number = gtk_notebook_page_num(GTK_NOTEBOOK(main_notebook), tmp_ss->vbox);
			    D("Found previously focused tab at %d so change\n", page_number);
			    gtk_notebook_set_page(GTK_NOTEBOOK(main_notebook), page_number);
			    break;
			  }
			else
			  D("tmp_ss was not a tab so try next\n");
		      }
		  }
		  else 
		    D("Not current tab so do nothing\n");
		}
	     
	        g_signal_handlers_destroy(G_OBJECT(skipstone->embed));
	        gtk_widget_hide_all(skipstone->vbox);
	        gtk_widget_destroy(skipstone->vbox);



       	} else {
	        g_signal_handlers_destroy(G_OBJECT(skipstone->embed));
	        gtk_widget_hide_all(skipstone->vbox);
     		gtk_widget_destroy(skipstone->window);
	}

       	D_RETURN;
}



void exit_app(GtkWidget *menuitem,gpointer data)
{
     	D_ENTER;
     	quit_skipstone();
     	D_RETURN;
	
}

void change_layout(GtkWidget *menuitem,gpointer data) 
{
     	D_ENTER;
	config.layout = GPOINTER_TO_INT(data);
	update_layout();
	D_RETURN;
}


void destroy_window_callback(GtkWidget *window,SkipStone *skipstone) 
{
	GSList *l;
     	D_ENTER;
	window_count = g_slist_remove(window_count,skipstone);

	if (g_slist_length(window_count) == 0) {
		quit_skipstone();
	}

	for (l = window_count; l; l=l->next) {
		SkipStone *window_skipstone = l->data;
		if (window_skipstone->is_notebook == 0 && window_skipstone->menubar != NULL) {
	     		make_window_menu(window_skipstone);
		}
	}
     

	if (skipstone->go_menu && skipstone->go_menu->items) {
       		g_slist_free(skipstone->go_menu->items); /* go menu linked list */
	     	g_free(skipstone->go_menu); /* go menu struct itself */
	}
     	if (skipstone->bookmark_toolbar_widgets) g_slist_free(skipstone->bookmark_toolbar_widgets);  
     	if (skipstone->title) g_free(skipstone->title);
     	g_free(skipstone); /* skipstone struct */
     	
	D_RETURN;
}

void _skipstone_load_url(SkipStone *skipstone, gchar *url)
{
   g_return_if_fail(skipstone->embed != NULL);
   g_return_if_fail(url != NULL);
   D_ENTER;
   
   if (!skipstone->initilized) 
     {
	gchar *first_url;
	first_url = g_object_get_data(G_OBJECT(skipstone->embed), "first_url");
	if (first_url != NULL) {
	     g_free(first_url);
/*	     g_object_remove_data(G_OBJECT(skipstone->embed), "first_url");*/
	     g_object_set_data(G_OBJECT(skipstone->embed), "first_url", g_strdup(url));
	     D_RETURN;
	}
	g_object_set_data(G_OBJECT(skipstone->embed), "first_url", g_strdup(url));
	gtk_moz_embed_load_url(skipstone->embed, "about:blank");
	D_RETURN;
     }


	    
   gtk_moz_embed_load_url(skipstone->embed, url);
   g_return_if_fail(GTK_BIN(skipstone->embed)->child != NULL);
   gtk_widget_grab_focus(GTK_BIN(skipstone->embed)->child);
   D_RETURN;
}

   

void on_entry(GtkWidget *entry,SkipStone *skipstone) 
{
     	G_CONST_RETURN gchar *url;
	gchar *real_url = NULL;
   	gchar *curl;
	GSList *l;
	D_ENTER;
	url = gtk_entry_get_text(GTK_ENTRY(entry));

	for (l = prefixes; l; l = l->next) {
		SkipPrefix *prefix = l->data;

		if (g_strncasecmp(url,prefix->prefix,strlen(prefix->prefix)) == 0) {
			gchar *a = strchr(url,':');
			a++;
			real_url = g_strdup_printf(prefix->url,a);
		}
	}

	if (!real_url) {
		real_url = g_strdup(url);
	}

	_skipstone_load_url(skipstone,real_url);
	g_free(real_url);
     	curl = g_strdup(url);
	insert_in_combo(curl,skipstone);
     	
	D_RETURN;
}

gint on_entry_button_press(GtkWidget *entry, GdkEventButton *event, SkipStone *skipstone)
{
     	D_ENTER;
	if (event->button == 1 && event->state & GDK_SHIFT_MASK) {
		gtk_editable_select_region(GTK_EDITABLE(entry), 0, -1);
		D_RETURN_(TRUE);
	} else {
		D_RETURN_(FALSE);
	}
}
	
void on_list_select(GtkWidget *combo,SkipStone *skipstone) 
{
     	D_ENTER;
	on_entry(GTK_WIDGET(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry)), skipstone);
	D_RETURN;
}

static void destroy_dialog(GtkWidget *dialog,DialogData *ddata)
{
     	D_ENTER;
       	g_free(ddata);
	D_RETURN;
}


static void on_url_entry_ok(GtkWidget *button,DialogData *ddata)
{
     	G_CONST_RETURN gchar *url;
	D_ENTER;
     	url = gtk_entry_get_text( GTK_ENTRY(GTK_COMBO(ddata->entry)->entry ) );
     	if (*url) {
     		make_window(url);		
		close_dialog(NULL,ddata);
     	} 
	D_RETURN;
}

static void on_url_entry_ok_current(GtkWidget *button,DialogData *ddata) {
	SkipStone *skipstone;
	D_ENTER;
	skipstone = g_object_get_data(G_OBJECT(button),"skipstone");
	on_entry(ddata->entry,skipstone);
	close_dialog(NULL,ddata);
		
	D_RETURN;
}

void on_back(GtkWidget *button,SkipStone *skipstone) 
{
     	g_return_if_fail(skipstone->embed != NULL);
     	g_return_if_fail(GTK_IS_MOZ_EMBED(skipstone->embed));
     	D_ENTER;
	gtk_moz_embed_go_back(skipstone->embed);
	D_RETURN;
}


void on_forward(GtkWidget *button,SkipStone *skipstone) 
{
     	g_return_if_fail(skipstone->embed != NULL);
     	g_return_if_fail(GTK_IS_MOZ_EMBED(skipstone->embed));
     	D_ENTER;
     	gtk_moz_embed_go_forward(skipstone->embed);
	D_RETURN;
}


void on_reload(GtkWidget *button, SkipStone *skipstone)
{
     	D_ENTER;
	gtk_moz_embed_reload(skipstone->embed,GTK_MOZ_EMBED_FLAG_RELOADNORMAL);
	D_RETURN;
}

gint on_reload_button_press(GtkWidget *button, GdkEventButton *ev, SkipStone *skipstone)
{
     	D_ENTER;
	if (ev->button == 1 && ev->state & GDK_SHIFT_MASK) {
		gtk_moz_embed_reload(skipstone->embed, GTK_MOZ_EMBED_FLAG_RELOADBYPASSCACHE);
	     	D_RETURN_(TRUE);
	} else if (ev->button == 1) {
		gtk_moz_embed_reload(skipstone->embed, GTK_MOZ_EMBED_FLAG_RELOADNORMAL);
		D_RETURN_(TRUE);
	} else if (ev->button == 3) {
		gtk_menu_popup(GTK_MENU(get_reload_menu(skipstone)), NULL, NULL, NULL, NULL, ev->button,ev->time);
	     	D_RETURN_(TRUE);
	}
	D_RETURN_(FALSE);
}

void on_reload_popup_menu_selection_made(GtkWidget *menuitem, SkipStone *skipstone)
{
	gint num = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(menuitem), "reload_flag"));
     	D_ENTER;
	gtk_moz_embed_reload(skipstone->embed, num);
	D_RETURN;
}

void on_stop(GtkWidget *button, SkipStone *skipstone)
{
     	D_ENTER;
     	gtk_moz_embed_stop_load(skipstone->embed);
     	skipstone->is_loading = FALSE;
	D_RETURN;
}


void go_home(GtkWidget *button, SkipStone *skipstone)
{
     	D_ENTER;
     	_skipstone_load_url(skipstone,config.home);
     	D_RETURN;
}

/* create_dialog(sometitle, sometext) creates a dialog with an ok button
 * logo - if true then the logo is passed also.*/
void create_dialog(gchar *title, gchar *labeltext, gint logo, gint lock)
{
     	GtkWidget *dialog, *ok, *label, *logo_pic;
     	D_ENTER;
     	dialog = gtk_dialog_new();
        skipstone_window_set_icon(dialog);
     	setup_escape_key_handler(dialog);
	if (lock)  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	label = gtk_label_new(labeltext);
     	gtk_label_set_line_wrap(GTK_LABEL(label), 1);
     	ok = gtk_button_new_with_label(_("Ok!"));
     	gtk_widget_set_usize(ok, 55, 25);
     	gtk_window_set_title(GTK_WINDOW(dialog), title);
     	gtk_window_set_default_size(GTK_WINDOW(dialog), 150, 100);
     	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), 5);
     	if (logo) {
	        gint loaded;
	     	logo_pic = create_pixmap(dialog,"logo.png",&loaded);
	     	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), logo_pic, TRUE, TRUE, 5);
	}
     	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 5);
     	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), ok, FALSE, FALSE, 5);
     	g_signal_connect(G_OBJECT(ok), "clicked", G_CALLBACK(close_generic_dialog), dialog);
     	gtk_widget_show_all(dialog);
	D_RETURN;
}


/* callback to destroy the generic dialog */
static void close_generic_dialog(GtkWidget *button, GtkWidget *dialog)
{
     	D_ENTER;
     	gtk_widget_destroy(dialog);
	D_RETURN;
}

void about_skipstone(GtkWidget *menuitem)
{

     	gchar *title = g_strdup_printf(_("About SkipStone %d.%d.%d"), SKIPSTONE_MAJOR, SKIPSTONE_MINOR, SKIPSTONE_MICRO);
     	gchar *abouttext = _("SkipStone is a light Gtk+ web browser\nthat embeds Mozilla through GtkMozEmbed\nCopyright(c)\n\tMaher Awamy <muhri@muhri.net>\n\tCharlie Schmidt <ishamael@themes.org>");
     	D_ENTER;
       	create_dialog(title,abouttext,1,0);
     	g_free(title);
	D_RETURN;
}

void hide_bookmark_toolbar(GtkCheckMenuItem *cb_menuitem, SkipStone *skipstone)
{
     GSList *l;
     D_ENTER;
     if (cb_menuitem->active) {
	     	gtk_widget_hide(skipstone->bmarkhandlebox);
		config.bmarktbar = 0;
     	} else {
		gtk_widget_show(skipstone->bmarkhandlebox);
		config.bmarktbar = 1;
	}
	if (window_count !=NULL) {
	    for (l = window_count; l; l = l->next) {
		 	SkipStone *skipstone = l->data;
		 	if (config.bmarktbar == 0) {
		 		gtk_widget_hide(skipstone->bmarkhandlebox);
			} else {
			     	gtk_widget_show(skipstone->bmarkhandlebox);
			}
	    }
	}
	D_RETURN;
}

void hide_navigation_toolbar(GtkCheckMenuItem *cb_menuitem, SkipStone *skipstone)
{
     GSList *l;
     D_ENTER;
     if (cb_menuitem->active) {
		config.navtbar = 0;
     	} else {
		config.navtbar = 1;
	}
	if (window_count !=NULL) {
	    for (l = window_count; l ; l=l->next) {
		 	SkipStone *skipstone = l->data;
		 	if (config.navtbar == 0) {
		 		gtk_widget_hide(skipstone->handlebox);
			} else {
			     	gtk_widget_show(skipstone->handlebox);
			}
	    }
	}
     	D_RETURN;
}

void on_view_source(GtkWidget *MenuItem, SkipStone *skipstone)
{
     	G_CONST_RETURN gchar *url;
	gchar *prot_url = NULL;
	SkipStone *skipstone2;
     	D_ENTER;
	url  = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(skipstone->combo)->entry));
	if (url == NULL || !strcmp(url,"")) D_RETURN;


	prot_url = g_strconcat("view-source:",url,NULL);
	
	if (!config.notebook) {
		skipstone2 = new_skipstone_window(FALSE,TRUE);
		gtk_widget_hide(skipstone2->handlebox);
		gtk_widget_hide(skipstone2->bmarkhandlebox);
		gtk_widget_hide(skipstone2->menuhandlebox);
	} else {
		gint length;
		
		skipstone2 = new_skipstone_tab(FALSE);
		
		length = g_slist_length(window_count);		
		if (!config.show_tabs && length > 1)
		  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(main_notebook), TRUE);

		g_object_set_data(G_OBJECT(skipstone2->vbox), "skipstone", skipstone2);
	     	skipstone_append_tab(skipstone2);
		gtk_widget_show_all(skipstone2->vbox);
		gtk_widget_hide(skipstone2->handlebox);
		gtk_label_set_text(GTK_LABEL(skipstone2->notebook_label), "View-Source");
	}


	_skipstone_load_url(skipstone2,prot_url);
	g_free(prot_url);


	D_RETURN;
}

void on_windowmenu_item_clicked(GtkWidget *menuitem,GtkWidget *window) 
{
     	D_ENTER;
	gdk_window_raise(GTK_WIDGET(window)->window);
	D_RETURN;
}

static void find_dialog_ok_cb (GtkWidget *w, GtkWidget *window)
{
	SkipStone *skipstone = (SkipStone *)g_object_get_data(G_OBJECT(window), "skipstone");
	GtkWidget *entry = (GtkWidget *)g_object_get_data(G_OBJECT(window), "entry");

#define	GET_FIND_OPTION(window, name)	\
	gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_object_get_data(G_OBJECT(window), name)))

	skipstone->didFind = mozilla_find(skipstone->embed,
					gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(entry)->entry)),
					!GET_FIND_OPTION(window, "ignore_case"),
					GET_FIND_OPTION(window, "backwards"),
					GET_FIND_OPTION(window, "auto_wrap"),
					GET_FIND_OPTION(window, "entire_word"),
					GET_FIND_OPTION(window, "in_frame"),
					skipstone->didFind);
	if (!skipstone->didFind) create_dialog(_("Find Results"), _("Expression was not found!"), 0, 1);
        if (last_find) g_free(last_find);
        last_find = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(entry)->entry)));
}

void on_print(GtkWidget *menuitem, SkipStone *skipstone)
{
     	D_ENTER;
     	g_return_if_fail(skipstone != NULL);
     	if (skipstone->pd) { 
	     	gdk_window_raise(skipstone->pd->window->window);
	     	D_RETURN;
	}
     	skipstone_print_dialog_new(skipstone);
     	D_RETURN;
}

/* find a substring in the embed */
void find_dialog (GtkWidget *w, SkipStone *skipstone)
{
	GtkWidget	*window, *hbox, *entry, *label, *button, *ignore_case,
			*back_wards, *auto_wrap, *entire_word, *in_frame, *vbox_l,
                        *vbox_r, *hbox_tog;
        GList *glist = NULL;
     
	D_ENTER;
        if (last_find) glist = g_list_append(glist, last_find);
	window = gtk_dialog_new();
        skipstone_window_set_icon(window);
     	setup_escape_key_handler(window);
	g_object_set_data(G_OBJECT(window), "skipstone", skipstone);
	gtk_window_set_title (GTK_WINDOW(window), _("Find"));
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
	hbox = gtk_hbox_new (FALSE, 0);
        hbox_tog = gtk_hbox_new(FALSE, 0);
        vbox_l = gtk_vbox_new(FALSE, 0);
        vbox_r = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER(hbox), 4);

	label = gtk_label_new (_("Find: "));
	gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 0);

	entry = gtk_combo_new ();
        gtk_combo_disable_activate(GTK_COMBO(entry));
        gtk_combo_set_case_sensitive(GTK_COMBO(entry), TRUE);
        if (last_find) gtk_combo_set_popdown_strings(GTK_COMBO(entry),glist);
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(entry)->entry), "");
	g_object_set_data(G_OBJECT(window), "entry", entry);
	g_signal_connect(G_OBJECT(GTK_COMBO(entry)->entry), "activate", G_CALLBACK(find_dialog_ok_cb), window);
	gtk_box_pack_start (GTK_BOX(hbox), entry, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), hbox, FALSE, FALSE, 0);

	ignore_case = gtk_check_button_new_with_label (_("Ignore case"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(ignore_case), TRUE);
	g_object_set_data(G_OBJECT(window), "ignore_case", ignore_case);
	gtk_box_pack_start(GTK_BOX(vbox_l), ignore_case, FALSE, FALSE, 0);

	back_wards = gtk_check_button_new_with_label(_("Find backwards?"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(back_wards), FALSE);
	g_object_set_data(G_OBJECT(window), "backwards", back_wards);
	gtk_box_pack_start(GTK_BOX(vbox_l), back_wards, FALSE, FALSE, 0);

	in_frame = gtk_check_button_new_with_label(_("Search in frames"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(in_frame), FALSE);
	g_object_set_data(G_OBJECT(window), "in_frame", in_frame);
	gtk_box_pack_start(GTK_BOX(vbox_l), in_frame, FALSE, FALSE, 0);
        
        gtk_box_pack_start(GTK_BOX(hbox_tog), vbox_l, FALSE, FALSE, 0);
     
	entire_word = gtk_check_button_new_with_label(_("Match entire word"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(entire_word), FALSE);
	g_object_set_data(G_OBJECT(window), "entire_word", entire_word);
	gtk_box_pack_start(GTK_BOX(vbox_r), entire_word, FALSE, FALSE, 0);

        
     	auto_wrap = gtk_check_button_new_with_label(_("Wrap around"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(auto_wrap), FALSE);
	g_object_set_data(G_OBJECT(window), "auto_wrap", auto_wrap);
	gtk_box_pack_start(GTK_BOX(vbox_r), auto_wrap, FALSE, FALSE, 0);
     
        gtk_box_pack_start(GTK_BOX(hbox_tog), vbox_r, FALSE, FALSE, 0);
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), hbox_tog, FALSE, FALSE, 0);
     
      	button = gtk_button_new_with_label (_("Find"));
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(window)->action_area), button, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(find_dialog_ok_cb), window);

	button = gtk_button_new_with_label (_("Close"));
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(window)->action_area), button, FALSE, FALSE, 0);
	g_signal_connect_swapped(G_OBJECT(button), "clicked", G_CALLBACK(gtk_widget_destroy), (gpointer)window);

	gtk_widget_show_all (window);
	gtk_widget_grab_focus (entry);
     	D_RETURN;
}


void save_document(GtkWidget *menuitem, SkipStone *skipstone)
{
     	GtkWidget *fs, *all;
	G_CONST_RETURN gchar *location = NULL, *file_name = NULL;
	D_ENTER;
     	g_return_if_fail(skipstone->embed != NULL);
       
     	location = gtk_moz_embed_get_location(skipstone->embed);
     	if (location) file_name = g_basename(location);
     	all = gtk_check_button_new_with_label(_("Save everything, including images and framesets?"));
       	fs = gtk_file_selection_new(_("Enter a filename to save as"));
     	gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fs)->action_area), all, FALSE, FALSE, 0);
     	gtk_widget_show(all);
     	g_object_set_data(G_OBJECT(fs), "skipstone", skipstone);
     	g_object_set_data(G_OBJECT(fs), "save_all", all);
       	if (file_name) gtk_entry_set_text(GTK_ENTRY(GTK_FILE_SELECTION(fs)->selection_entry), file_name);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->ok_button), "clicked", 
			   G_CALLBACK(on_save_ok), fs);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button), "clicked",
			   G_CALLBACK(on_save_cancel), fs);
	gtk_widget_show(fs);

     	D_RETURN;
}

void save_image(SkipStone *skipstone, gchar *image_link, gchar *image_name)
{
     	GtkWidget *fs;
	D_ENTER;
     	fs = gtk_file_selection_new(_("Enter a filename to save as"));
     	g_object_set_data(G_OBJECT(fs), "skipstone", skipstone);
     	g_object_set_data(G_OBJECT(fs), "link", image_link);
     	g_object_set_data(G_OBJECT(fs), "name", image_name);
     	gtk_entry_set_text(GTK_ENTRY(GTK_FILE_SELECTION(fs)->selection_entry), image_name);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->ok_button), "clicked",
			   G_CALLBACK(on_save_image_ok), fs);
     	g_signal_connect(G_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button), "clicked",
			   G_CALLBACK(on_save_cancel), fs);
	gtk_widget_show(fs);
	D_RETURN;
}

static void on_save_ok(GtkWidget *button, GtkWidget *fs)
{
     	SkipStone *skipstone = NULL;     
     	GtkWidget *all;
     	G_CONST_RETURN gchar *filename;
     	D_ENTER;
     	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));     	
     	all = g_object_get_data(G_OBJECT(fs), "save_all");

     	if (!filename || !strcmp(filename,"")) {
       		D_RETURN;
	} else {
     		skipstone = g_object_get_data(G_OBJECT(fs), "skipstone");
     		if (!mozilla_save(skipstone->embed, (gchar *)filename,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(all)))) {
		 	create_dialog(_("Error"), _("Save failed, did you enter a name?"),0,0);
		}
		gtk_widget_destroy(fs);			
	}
	D_RETURN;
}

static void on_save_image_ok(GtkWidget *button, GtkWidget *fs)
{
     	SkipStone *skipstone = NULL;
     	G_CONST_RETURN gchar *filename; 
        gchar *image_link;
	D_ENTER;
     	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
     	
     	if (!filename || !strcmp(filename,"")) {
		D_RETURN;
	} else {
     		skipstone = g_object_get_data(G_OBJECT(fs), "skipstone");
     		image_link = g_object_get_data(G_OBJECT(fs), "link");
	     	mozilla_save_image(skipstone->embed, image_link, (gchar *)filename); 
		gtk_widget_destroy(fs);			
	}
	D_RETURN;
}

static void on_save_cancel(GtkWidget *button, GtkWidget *fs)
{
     	D_ENTER;
     	gtk_widget_destroy(fs);
	D_RETURN;
}


void on_selection_get(GtkWidget *window, GtkSelectionData *selection_data, 
		      guint info, guint time_stamp, SkipStone *skipstone)
{
     	gchar *clip;

     	D_ENTER;

	clip = g_object_get_data (G_OBJECT (window), "clipboard-link");
     	gtk_selection_data_set(selection_data, GDK_SELECTION_TYPE_STRING,
			       8, clip, strlen(clip));
	D_RETURN;
}

void on_selection_received(GtkWidget *window, GtkSelectionData *selection_data,
			   guint time, SkipStone *skipstone)
{
     
     	D_ENTER;
     	if (!skipstone)
     		skipstone = get_current_browser_from_notebook();
     	if (!skipstone) D_RETURN;
     	if (selection_data->data)
       		_skipstone_load_url(skipstone, selection_data->data);
	D_RETURN;
}

void on_window_size_request(GtkWidget *window, GtkRequisition *req, SkipStone *skipstone)
{
     	gint x,y,w,h,d;
     
	D_ENTER;
     
     	gdk_window_get_geometry(window->window,&x,&y,&w,&h,&d);
     
	if (w > config.xsize + 10 || w < config.xsize - 10) {
	     	gint entry_length = w - 150;
	     	if (config.navbar_buttons & NAVBAR_BACK) entry_length -= 50;
	     	if (config.navbar_buttons & NAVBAR_FOR) entry_length -= 50;
	     	if (config.navbar_buttons & NAVBAR_RELOAD) entry_length -= 50;
	     	if (config.navbar_buttons & NAVBAR_STOP) entry_length -= 50;
	     	if (config.navbar_buttons & NAVBAR_HOME) entry_length -= 50;
		if (config.notebook) {
		     GSList *l;
		     for (l = window_count; l ; l = l->next) {
			  SkipStone *curr = (SkipStone *)l->data;
			  if (curr->is_notebook && curr->combo) gtk_widget_set_usize(curr->combo, entry_length, 30);
		     }
		} else {
		     gtk_widget_set_usize(skipstone->combo, entry_length, 30);
		}	     
	}

     	if (w)
	     	config.xsize = w;
     	if (h)
	     	config.ysize = h;

	D_RETURN;
}


void toggle_mime_handling(void)
{
	static gint doing_it = 0;
     	D_ENTER;
	if (doing_it) D_RETURN;

	if (config.use_skipstone_mime) {
		config.use_skipstone_mime = 0;
		if (!config.notebook) {			
			GSList *l;
			SkipStone *skipstone;
			doing_it = 1;
			for (l = window_count; l; l = l->next) {
			  skipstone = (SkipStone *)l->data;				
			  if (skipstone->use_skipstone_mime && !skipstone->is_notebook)
			    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(skipstone->use_skipstone_mime), FALSE);
			}
			doing_it = 0;
		}
	} else {		
		config.use_skipstone_mime = 1;
		if (!config.notebook) {
			GSList *l;
			SkipStone *skipstone;
			doing_it = 1;
			for (l = window_count; l ; l=l->next) {		
			  skipstone = (SkipStone *)l->data;
			  if (skipstone->use_skipstone_mime && !skipstone->is_notebook)
			    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(skipstone->use_skipstone_mime), TRUE);
			}
			doing_it = 0;
		}
	}
	D_RETURN;
}


void on_offline_toggle_cb(GtkCheckMenuItem *menuitem)
{    
     gboolean result;
     D_ENTER;
      result = mozilla_set_offline(menuitem->active);
     if (!result) skipstone_error_dialog(_("Error"), _("Failed to Set Offline status!"), FALSE);
     D_RETURN;
}




void switch_layouts()
{
     	D_ENTER;
	if (config.notebook) {
     		config.notebook = 0;
       		switch_from_notebook_to_regular();
     	} else {
       		config.notebook = 1;
       		switch_from_regular_to_notebook();
	}
	D_RETURN;
}


static void switch_from_notebook_to_regular()
{
     	GSList *list = NULL, *remove = NULL;
     	D_ENTER;
	g_signal_handlers_destroy(G_OBJECT(main_notebook));
     	/* first make windows for notebook tabs */
	for (list = window_count ; list != NULL ; list = list->next) {
    		SkipStone *skipstone = (SkipStone *)list->data;
	     	if (skipstone && skipstone->is_notebook == 1 && skipstone->embed != NULL) {
		     	gchar *location = NULL;
		     	on_stop(NULL, skipstone);
		     	if (skipstone->timer) gtk_timeout_remove(skipstone->timer);
		     	skipstone->timer = 0;
		     	location = gtk_moz_embed_get_location(skipstone->embed);
		     	if (location) {
			     	make_window(location);
			     	g_free(location);
			}
		     	remove = g_slist_append(remove, skipstone);
		}
	}

     
	/* then destroy them */
     	for (list = remove; list != NULL; list = list->next) {
	     	SkipStone *skipstone = (SkipStone *)list->data;
	     	if (skipstone && skipstone->is_notebook == 1 && skipstone->embed != NULL)
	       		close_window(NULL, skipstone);
	}
     	g_slist_free(remove);
        /*  disconnect the gtk_main_quit from the notebook main_window */
     	g_signal_handlers_destroy(G_OBJECT(main_window));
     	gtk_widget_destroy(main_window);
	clear_variables();
     	D_RETURN;
}

static void switch_from_regular_to_notebook()
{	
	GSList *list = NULL, *remove = NULL;
     	D_ENTER;
     	clear_variables();	
    	/*  make notebook tabs for independant browsers */
	for (list = window_count ; list != NULL ; list = list->next) {
		SkipStone *skipstone = (SkipStone *)list->data;
	     	if (skipstone && !skipstone->is_notebook && skipstone->embed != NULL) {
		     	gchar *location = NULL;
	       		on_stop(NULL,skipstone);
		     	if (skipstone->timer) gtk_timeout_remove(skipstone->timer);
		     	skipstone->timer = 0;
		     	location = gtk_moz_embed_get_location(skipstone->embed);
		     	if (location) {
			     	make_window(location);
			     	g_free(location);
			}
		     	remove = g_slist_append(remove, skipstone);
		}
	}
     	/*  then destory them */
     	for (list = remove; list != NULL; list = list->next) {
	     	SkipStone *skipstone = (SkipStone *)list->data;
	     	if (skipstone && !skipstone->is_notebook && skipstone->embed != NULL)
	       		close_window(NULL, skipstone);
	}
	g_slist_free(remove);     	
	D_RETURN;
}

void skipstone_window_set_icon(GtkWidget *window)
{
     GtkWidget *pixmap;
     GdkPixbuf *p;
     gint loaded;
     D_ENTER;

     pixmap = create_pixmap(window, "skipstone.png",&loaded);
     if (!pixmap) D_RETURN;

     p = gtk_image_get_pixbuf(GTK_IMAGE(pixmap));
     if (!p) D_RETURN;
     
     gtk_window_set_icon(GTK_WINDOW(window), p);
     gtk_widget_destroy(pixmap);
     
     D_RETURN;

}
     
