#ifndef SKIPSTONE_PROMPTER_H 
#define SKIPSTONE_PROMPTER_H 1

#include <nsCOMPtr.h>
#include <nsString.h>
#include "nsReadableUtils.h"
#include <gtk/gtk.h>

class SkipStonePrompter {

 public:

     		SkipStonePrompter();
     		~SkipStonePrompter();

     	enum PromptType {
	       TYPE_ALERT,
	       TYPE_ALERT_CHECK,
	       TYPE_CONFIRM,
	       TYPE_CONFIRM_CHECK,
	       TYPE_PROMPT,
	       TYPE_PROMPT_USER_PASS,
	       TYPE_PROMPT_PASS,
	       TYPE_SELECT,
	       TYPE_UNIVERSAL };

     	nsresult Create(PromptType aType);
     	void     SetTitle(const PRUnichar *aTitle);
     	void     SetTextValue (const PRUnichar *aTextValue);
     	void     SetCheckMessage(const PRUnichar *aCheckMessage);
     	void     SetCheckValue(const PRBool aValue);
     	void     SetMessageText(const PRUnichar *aMessageText);
     	void     SetUser(const PRUnichar *aUser);
     	void     SetPassword(const PRUnichar *aPass);
     
     	void     GetCheckValue(PRBool *aValue);
     	void     GetConfirmValue(PRBool *aConfirmValue);
     	void     GetTextValue(PRUnichar **aTextValue);
     	void     GetUser(PRUnichar **aUser);
     	void     GetPassword(PRUnichar **aPass);

     	void     Run(void);

     	void     UserCancel(void);	
     	void     UserOK(void);

 private:

     	enum {
	     	INCLUDE_USERNAME    = 1U,
	       	INCLUDE_CHECKBOX    = 2U,
	       	INCLUDE_TEXTFIELD   = 4U,
	       	INCLUDE_CANCEL      = 8U
	};
  
     	void     CreatePasswordPrompter(int aFlags);
     	void     CreateAlertPrompter(int aFlags);

     	nsCString  mTitle;
     	gchar *  mMessageText;
     	nsCString  mTextValue;
     	nsCString  mCheckMessage;
     	PRBool     mCheckValue;

     	PRBool     mConfirmResult;
     	nsCString  mUser;
     	nsCString  mPass;

     	GtkWidget *mWindow;
     	GtkWidget *mUserField;	
     	GtkWidget *mPassField;
     	GtkWidget *mTextField;
     	GtkWidget *mCheckBox;

};

#endif /* SKIPSTONE_PROMPTER_H */
