/* Function to Zoom Mozilla's docshell for SkipStone's Zoom plugin */
/* Maher <muhri@muhri.net> */
#include "gtkmozembed.h"
#include "gtkmozembed_internal.h"
#include "nsIDOMDocument.h"
#include "nsIDocShell.h"
#include "nsIDocShellTreeItem.h"
#include "nsIDocShellTreeOwner.h"
#include "nsCOMPtr.h"
#include "nsIContentViewer.h"
#include "nsIMarkupDocumentViewer.h"
#include "nsIContentViewerFile.h"

static nsIDocShell *mozilla_get_docshell(GtkMozEmbed *b);

extern "C" gboolean 
mozilla_set_zoom(GtkMozEmbed *m, float ZoomValue)  
{
     nsresult result;      
     
     nsCOMPtr<nsIDocShell> DocShell = mozilla_get_docshell(m);
     if (!DocShell) return FALSE;
     
     nsCOMPtr<nsIContentViewer> contentViewer;
     result = DocShell->GetContentViewer (getter_AddRefs(contentViewer));
     if (!NS_SUCCEEDED (result) || !contentViewer) return FALSE;
     
     nsCOMPtr<nsIMarkupDocumentViewer> mdv = do_QueryInterface(contentViewer,&result);

     if (NS_FAILED(result) || !mdv) return FALSE;
     
     return NS_SUCCEEDED (mdv->SetTextZoom (ZoomValue)) ? TRUE : FALSE;
}

static nsIDocShell *mozilla_get_docshell(GtkMozEmbed *b)
{
     	nsresult result ;	

	/* get nsIBrowser */
	nsIWebBrowser *wb = nsnull;
	gtk_moz_embed_get_nsIWebBrowser(b,&wb);
	nsCOMPtr<nsIDocShell> docShell;

        nsCOMPtr<nsIDocShellTreeItem> browserAsItem;
	browserAsItem = do_QueryInterface(wb);
     	if (!browserAsItem) return NULL;
	// get the tree owner for that item
	nsCOMPtr<nsIDocShellTreeOwner> treeOwner;
	result = browserAsItem->GetTreeOwner(getter_AddRefs(treeOwner));
     	if (!NS_SUCCEEDED(result) || !treeOwner) return NULL;
	// get the primary content shell as an item
	nsCOMPtr<nsIDocShellTreeItem> contentItem;
	result = treeOwner->GetPrimaryContentShell(getter_AddRefs(contentItem));
     	if (!NS_SUCCEEDED(result) || !contentItem) return NULL;
	// QI that back to a docshell
	docShell = do_QueryInterface(contentItem);

     	return docShell;
}
