#include <ctype.h>

#include "../../src/skipstone.h"
#include "fm.xpm"
#include "google.xpm"
#include "yahoo.xpm"
/* demo plugin for SkipStone  */
/* SkipStone will look in ~/.skipstone/plugins for shared objects to load
 * and it will pass them a pointer to the skipstone struct after packing
 * the toolbar, so you can pack anything after the toolbar is packed. 
 * Please dont access anything other than skipstone->embed
 * from the struct. For info on how to use embed to do stuff, look at gtkmozembed.h
 * <muhri@muhri.net> */

/* every plugin must have an init_plugin() function that returns a pointer to
 * a SkipStonePlugin struct */

#define	GOOGLE_NAME		"Google!"
#define	FRESHMEAT_NAME		"Freshmeat!"
#define	YAHOO_NAME		"Yahoo!"

#define	GOOGLE_SEARCH_URL	"http://www.google.com/search?q="
#define	FRESHMEAT_SEARCH_URL	"http://www.freshmeat.net/search/?q="
#define	YAHOO_SEARCH_URL	"http://search.yahoo.com/bin/search?p="

#define	GOOGLE_URL		"http://www.google.com/"
#define	FRESHMEAT_URL		"http://www.freshmeat.net/"
#define	YAHOO_URL		"http://search.yahoo.com/"

static void create_plugin(SkipStone *skipstone);
static void on_entry_activate(GtkWidget *entry, SkipStone *skipstone);
static void on_button_clicked(GtkWidget *button, SkipStone *skipstone);
static GtkWidget *get_pixmap(GtkWidget *hbox, gchar **icon);

typedef	struct	{
	gchar	*name;
	gchar	*url;
	gchar	*search_url;
	gchar	**icon;
} SEARCH_ENGINE;

const SEARCH_ENGINE	search_engines[] = {
	{GOOGLE_NAME, GOOGLE_URL, GOOGLE_SEARCH_URL, google_xpm},
	{FRESHMEAT_NAME, FRESHMEAT_URL, FRESHMEAT_SEARCH_URL, fm_xpm},
	{YAHOO_NAME, YAHOO_URL, YAHOO_SEARCH_URL, yahoo_xpm},
	{NULL, NULL, NULL, NULL}
};

static SkipStonePlugin plugin = {
	"SearchToolbar!",	/* plugin name */
	PLUGIN_AFTER_TOOLBAR,	/* position after toolbar */
	create_plugin,		/* create plugin function */
	NULL,			/* get_config_widget() */
	NULL,			/* save_config() */
	1			/* do we create this plugin for each window */
};

static void create_plugin(SkipStone *skipstone)
{
	GtkWidget *box, *hb;
	gint i;

	box = gtk_hbox_new(0,5);
	hb = gtk_handle_box_new();
	for (i = 0; search_engines[i].name != NULL; ++i) {
		GtkWidget *entry, *hbox, *pix, *button;
		gchar *name = search_engines[i].name;

		entry = gtk_entry_new();
		hbox = gtk_hbox_new(0,5);
		pix = get_pixmap(hbox, search_engines[i].icon);

		if (pix) {
			button = gtk_button_new();
			gtk_container_add(GTK_CONTAINER(button), pix);
		} else {
			button = gtk_button_new_with_label(name);
		}
		gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
		gtk_box_pack_start(GTK_BOX(hbox), button, 0, 0, 0);
		gtk_box_pack_start(GTK_BOX(hbox), entry, 0, 0, 0);
		gtk_object_set_data(GTK_OBJECT(button), "engine", name);
		gtk_object_set_data(GTK_OBJECT(entry), "engine", name);
		gtk_box_pack_start(GTK_BOX(box), hbox, 0, 0, 2);
		gtk_signal_connect(GTK_OBJECT(entry), "activate", 
				   GTK_SIGNAL_FUNC(on_entry_activate), 
				   skipstone);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(on_button_clicked),
				   skipstone);
	}
	
	/* pack our box onto skipstone's vbox and show it all */
	gtk_container_add(GTK_CONTAINER(hb), box);
/*	gtk_container_set_border_width(GTK_CONTAINER(hb), 2);*/
	skipstone_pack_plugin(skipstone, hb);
	gtk_widget_show_all(box);
}

static void on_button_clicked(GtkWidget *button, SkipStone *skipstone)
{
	gchar *engine;
	gint i;

	g_return_if_fail(skipstone != NULL);
	g_return_if_fail(skipstone->embed != NULL);

	engine = gtk_object_get_data(GTK_OBJECT(button), "engine");

	for (i = 0; search_engines[i].name != NULL; i++)
	{
		if (!strcmp(engine, search_engines[i].name))
		{
			skipstone_load_url(skipstone, search_engines[i].url);
			return;
		}
	}
}

static void on_entry_activate(GtkWidget *entry, SkipStone *skipstone)
{
	G_CONST_RETURN gchar *stuff;
        gchar *engine;
	GString *encoded = g_string_new(NULL);
	gchar *url = NULL;
	int len, i;

	g_return_if_fail(skipstone != NULL);
	g_return_if_fail(skipstone->embed != NULL);

	stuff = gtk_entry_get_text(GTK_ENTRY(entry));

	len = (stuff != NULL) ? strlen(stuff) : 0;

	for (i = 0; i < len; i++)
	{
		if (isgraph(stuff[i]))
			g_string_sprintfa(encoded, "%c", stuff[i] & 0xff);
		else
		{
			/* encode all non printable characters */
			g_string_sprintfa(encoded, "%%%02X", stuff[i] & 0xff);
		}
	}
	engine = gtk_object_get_data(GTK_OBJECT(entry), "engine");

	for (i = 0; search_engines[i].name != NULL; i++)
	{
		if (!strcmp(engine, search_engines[i].name))
		{
			url = g_strconcat(search_engines[i].search_url,
						encoded->str, NULL);
			skipstone_load_url(skipstone, url);
			g_free(url);
			break;
		}
	}
	if (encoded)
		g_string_free(encoded, TRUE);
	return;
}

SkipStonePlugin *init_plugin(void)
{
	return &plugin;
}

static GtkWidget * get_pixmap(GtkWidget *hbox, gchar **icon)
{
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkWidget *retpixmap = NULL;

	if (icon == NULL)
		return (NULL);

	pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL,
						gtk_widget_get_colormap(hbox),
						&mask, NULL, icon);
	if (pixmap && mask) {
		retpixmap = gtk_pixmap_new(pixmap, mask);
		gdk_pixmap_unref(pixmap);
		gdk_bitmap_unref(mask);
	}
	return (retpixmap);
}
