#include "../../src/skipstone.h"


static void create_plugin(SkipStone *ss);
static GtkWidget *create_user_image(void);

static gint mode = 0, follow = 0;
static gchar *image_path=NULL;

static GtkWidget *create_config(void);
static void save_my_config(GtkWidget *my_widget);

static SkipStonePlugin plugin =
{
   "NewButton",
     PLUGIN_IN_TOOLBAR_START,
     create_plugin,
     create_config,
     save_my_config,
     1
};

static void on_button_click(GtkWidget *b, GdkEventButton *ev);
static void on_selection(GtkWidget *b, GtkSelectionData *data, guint time);


static GtkWidget *create_config(void)
{
     GtkWidget *retval, *graphical, *path, *label, *hbox, *followtheme;
     retval = gtk_vbox_new(FALSE, 5);
     path = gtk_entry_new();
     label = gtk_label_new("Path to Image file: ");
     graphical = gtk_check_button_new_with_label("Use Image?");
     followtheme = gtk_check_button_new_with_label("Follow SkipStone Theme for Image? (Will fall back to your image if no new.png image is available");
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(graphical),
				  skipstone_get_config_value_as_int("NewButton",
								    "mode"));
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(followtheme), skipstone_get_config_value_as_int("NewButton","FollowTheme"));
     gtk_entry_set_text(GTK_ENTRY(path), skipstone_get_config_value_as_str("NewButton",
									   "ImagePath"));
     hbox = gtk_hbox_new(FALSE, 0);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(hbox), path, FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(retval), graphical, FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(retval), followtheme, FALSE, FALSE, 0);
     gtk_box_pack_start(GTK_BOX(retval), hbox, FALSE, FALSE, 0);
     
     gtk_object_set_data(GTK_OBJECT(retval), "mode", graphical);
     gtk_object_set_data(GTK_OBJECT(retval), "ImagePath", path);
     gtk_object_set_data(GTK_OBJECT(retval), "FollowTheme", followtheme);
     gtk_widget_show_all(retval);
     return retval;
}


static void save_my_config(GtkWidget *my_widget)
{
     GtkWidget *path, *graphical, *followtheme;
     path = gtk_object_get_data(GTK_OBJECT(my_widget), "ImagePath");
     graphical = gtk_object_get_data(GTK_OBJECT(my_widget), "mode");
     followtheme = gtk_object_get_data(GTK_OBJECT(my_widget), "FollowTheme");
     mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(graphical));
     follow = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(followtheme));
     skipstone_set_config_value_as_str("NewButton","ImagePath",(gchar *)gtk_entry_get_text(
										  GTK_ENTRY(path)));
     image_path = skipstone_get_config_value_as_str("NewButton","ImagePath");
     skipstone_set_config_value_as_int("NewButton","mode",mode);
     skipstone_set_config_value_as_int("NewButton","FollowTheme",follow);
     
     return;
}
	




static void on_selection(GtkWidget *b, GtkSelectionData *data, guint time)
{
   if (data->data)
      skipstone_new_window(data->data);
}

static void on_button_click(GtkWidget *b, GdkEventButton *ev)
{
   
   switch (ev->button)
     {
      case 1: 
	skipstone_new_window(NULL);
	break;
      case 2: 
	gtk_selection_convert(b, GDK_SELECTION_PRIMARY,
			      GDK_SELECTION_TYPE_STRING,
			      GDK_CURRENT_TIME);
	break;
      default:
	break;
     }
   
}


static GtkWidget *create_user_image(void)
{
     GtkWidget *da;
     GdkPixbuf *p;
     p = gdk_pixbuf_new_from_file_at_size(image_path, 24, 24, NULL);
     if (p) {
	  da = gtk_image_new_from_pixbuf(p);
	  gdk_pixbuf_unref(p);
	  return da;
     }
     return NULL;
}

static void create_plugin(SkipStone *ss)
{
     GtkWidget *button=NULL;
     GtkWidget *da=NULL;
     gint loaded=0;
     image_path=skipstone_get_config_value_as_str("NewButton","ImagePath");
   
   if ((!image_path || !strcmp(image_path," ")) && mode && !follow) {
	g_print("Could not find file for new button\n");
	mode = 0;
   }
     
   if (!mode) 
     {
	
	button = gtk_button_new_with_label("New");
     }
   
   else
     
       {
	    button  = gtk_button_new ();
	    if (follow) {
		 da=create_pixmap(button, "new.png", &loaded);
	    }
	    
	    if (!loaded || !follow) {
		 if (da) gtk_widget_destroy(da);
		 da = create_user_image();
		 if (!da) {
		      gtk_button_set_label(GTK_BUTTON(button), "New");
		 }
	    }
	    if (da)
	      gtk_container_add(GTK_CONTAINER(button), da);   	
       }

   gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
   
   gtk_signal_connect(GTK_OBJECT(button), "button_press_event",
			GTK_SIGNAL_FUNC(on_button_click),
			NULL);
   gtk_selection_add_target(button, GDK_SELECTION_PRIMARY, 
			    GDK_SELECTION_TYPE_STRING,1);
   gtk_signal_connect(GTK_OBJECT(button), "selection_received",
		      GTK_SIGNAL_FUNC(on_selection), NULL);

   gtk_widget_show_all(button);   
   skipstone_add_plugin_to_toolbar(ss, button, 
				   "Click for a new Window/Tab or Paste buffer to open a new Window/Tab and load the contents of the buffer.");
   
}

SkipStonePlugin * init_plugin(void)
{
   
   mode = skipstone_get_config_value_as_int("NewButton","mode");
   follow = skipstone_get_config_value_as_int("NewButton","FollowTheme");
   if (mode == -1) 
     {
	mode = 0;
	follow=0;
	skipstone_set_config_value_as_int("NewButton","mode",mode);
	skipstone_set_config_value_as_str("NewButton","ImagePath", " ");
	skipstone_set_config_value_as_int("NewButton","FollowTheme",follow);
     }
   
   return &plugin;
}

