/* 	Launcher.c
		Skipstone Plugin to add a Communicator-like Launcher
		100% configureable via $HOME/.skipstone/launchers

		written by:	Michael Clifford aka cliffom
		email:			cliffom@cliffom.net
		support:		Charlie Schmidt aka ishamael
*/

#include "../../src/skipstone.h"
#include <stdlib.h>

static void create_plugin(SkipStone *skipstone);
static void on_button_clicked(GtkWidget *button, SkipStone *skipstone);
static GtkWidget *get_pixmap(GtkWidget *hbox, gchar *pixmap_file);
static void on_button_destroy(GtkWidget *button, gchar *data);

static SkipStonePlugin plugin =
{
	"Launcher",   		/* plugin name */
	  PLUGIN_AFTER_STATUSBAR, /* position after statusbar */
	  create_plugin,	   	/* create plugin function */
       	  NULL,	/* get_config_widget() */
       	  NULL, /* save_config () */      
	  1 											/* do we create this plugin for each window */
};

static void create_plugin(SkipStone *skipstone)
{
	GtkWidget *hb,*hbox;

	FILE *launch_file;
	gchar *file;
	gchar *home;
	gchar *line;


	home = getenv("HOME");

	file = g_strconcat(home,"/.skipstone/launchers",NULL);
	launch_file = fopen(file, "r");
	
	if(launch_file == NULL) {
		printf("No launcher config to read!\n");
		g_free(file);
		return;
	}
	
	line = g_new0(gchar, 1024);

	hb = gtk_handle_box_new();
	hbox = gtk_hbox_new(FALSE,5);

	while(fgets(line,1024,launch_file) != NULL) {
		GtkWidget *button, *pix;
		gchar **launcher_info = NULL;	
		gchar *data=NULL;
		line[strlen(line)-1] = '\0';
		launcher_info = g_strsplit(line, ",", -1);

		pix = get_pixmap(hbox, launcher_info[1]);
		/* printf("%s\n",launcher_info[1]); */
		
		if (pix) {
			button = gtk_button_new();
			gtk_container_add(GTK_CONTAINER(button), pix);
		} else { 
			button = gtk_button_new_with_label(launcher_info[2]); 
		}
		
		gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);	     	
		gtk_box_pack_start(GTK_BOX(hbox), button, 0, 0, 0);
	     	data =  g_strdup(launcher_info[0]);
		gtk_object_set_data(GTK_OBJECT(button), "program",data);
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(on_button_clicked), skipstone);
	     	gtk_signal_connect(GTK_OBJECT(button), "destroy",
				   GTK_SIGNAL_FUNC(on_button_destroy), data);
		g_strfreev(launcher_info);
	}


	fclose(launch_file);
	g_free(line);
	g_free(file);
	
	/* pack our box onto skipstone's vbox and show it all */
	gtk_container_add(GTK_CONTAINER(hb), hbox);
	skipstone_pack_plugin(skipstone, hb);
	gtk_widget_show_all(hb);

}

static void on_button_destroy(GtkWidget *button, gchar *data)
{
     if (data)
       	g_free(data);
}

static void on_button_clicked(GtkWidget *button, SkipStone *skipstone)
{
	gchar *program;
	g_return_if_fail(skipstone != NULL);
	g_return_if_fail(skipstone->embed != NULL);
     
	program = gtk_object_get_data(GTK_OBJECT(button), "program");

	system(program);
	
	return;
}

SkipStonePlugin *init_plugin(void)
{
	return &plugin;
}

static GtkWidget * get_pixmap(GtkWidget *hbox, gchar *pixmap_file)
{
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkWidget *retpixmap = NULL;
	gchar *home;
	gchar *icon = NULL;
	gchar **tmp;

	home = getenv("HOME");
	tmp = g_strsplit(pixmap_file, "/", 2);

	if (!g_strcasecmp(tmp[0], "$HOME")) {
		icon = g_strconcat(home, "/", tmp[1], NULL);
	} else {
		icon = pixmap_file;
	}
	
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL,
						gtk_widget_get_colormap(hbox),
						&mask,
						NULL,
						icon);

	if (pixmap && mask) {
		retpixmap =  gtk_pixmap_new(pixmap,mask);
		gdk_pixmap_unref(pixmap);
		gdk_bitmap_unref(mask);
	}
	
	g_strfreev(tmp);
	if (icon != NULL)
	  g_free(icon);
	
	return retpixmap;
}
